/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.analysis.CharFilterFactory;
import org.apache.solr.analysis.TokenFilterFactory;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.analysis.TrieTokenizerFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.response.XMLWriter;
import org.apache.solr.schema.DateField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieDateField;
import org.apache.solr.schema.TrieDateFieldSource;
import org.apache.solr.search.QParser;
import org.apache.solr.search.function.DoubleFieldSource;
import org.apache.solr.search.function.FloatFieldSource;
import org.apache.solr.search.function.IntFieldSource;
import org.apache.solr.search.function.LongFieldSource;
import org.apache.solr.search.function.ValueSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrieField
extends FieldType {
    public static final int DEFAULT_PRECISION_STEP = 8;
    protected int precisionStepArg = 8;
    protected int precisionStep;
    protected TrieTypes type;
    static final DateField dateField = new DateField();
    static final String INT_PREFIX = new String(new char[]{'`'});
    static final String LONG_PREFIX = new String(new char[]{' '});

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        String t;
        String p = args.remove("precisionStep");
        if (p != null) {
            this.precisionStepArg = Integer.parseInt(p);
        }
        this.precisionStep = this.precisionStepArg;
        if (this.precisionStep <= 0 || this.precisionStep >= 64) {
            this.precisionStep = Integer.MAX_VALUE;
        }
        if ((t = args.remove("type")) != null) {
            try {
                this.type = TrieTypes.valueOf(t.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid type specified in schema.xml for field: " + args.get("name"), (Throwable)e);
            }
        }
        CharFilterFactory[] filterFactories = new CharFilterFactory[]{};
        TokenFilterFactory[] tokenFilterFactories = new TokenFilterFactory[]{};
        this.analyzer = new TokenizerChain(filterFactories, new TrieTokenizerFactory(this.type, this.precisionStep), tokenFilterFactories);
        this.queryAnalyzer = new TokenizerChain(filterFactories, new TrieTokenizerFactory(this.type, Integer.MAX_VALUE), tokenFilterFactories);
    }

    @Override
    public Object toObject(Fieldable f) {
        if (f instanceof NumericField) {
            Number val = ((NumericField)f).getNumericValue();
            if (val == null) {
                return TrieField.badFieldString(f);
            }
            return this.type == TrieTypes.DATE ? new Date(val.longValue()) : val;
        }
        byte[] arr = f.getBinaryValue();
        if (arr == null) {
            return TrieField.badFieldString(f);
        }
        switch (this.type) {
            case INTEGER: {
                return TrieField.toInt(arr);
            }
            case FLOAT: {
                return Float.valueOf(Float.intBitsToFloat(TrieField.toInt(arr)));
            }
            case LONG: {
                return TrieField.toLong(arr);
            }
            case DOUBLE: {
                return Double.longBitsToDouble(TrieField.toLong(arr));
            }
            case DATE: {
                return new Date(TrieField.toLong(arr));
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + f.name());
    }

    @Override
    public SortField getSortField(SchemaField field, boolean top) {
        field.checkSortability();
        switch (this.type) {
            case INTEGER: {
                return new SortField(field.getName(), (FieldCache.Parser)FieldCache.NUMERIC_UTILS_INT_PARSER, top);
            }
            case FLOAT: {
                return new SortField(field.getName(), (FieldCache.Parser)FieldCache.NUMERIC_UTILS_FLOAT_PARSER, top);
            }
            case LONG: 
            case DATE: {
                return new SortField(field.getName(), (FieldCache.Parser)FieldCache.NUMERIC_UTILS_LONG_PARSER, top);
            }
            case DOUBLE: {
                return new SortField(field.getName(), (FieldCache.Parser)FieldCache.NUMERIC_UTILS_DOUBLE_PARSER, top);
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + field.name);
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser qparser) {
        field.checkFieldCacheSource(qparser);
        switch (this.type) {
            case INTEGER: {
                return new IntFieldSource(field.getName(), FieldCache.NUMERIC_UTILS_INT_PARSER);
            }
            case FLOAT: {
                return new FloatFieldSource(field.getName(), FieldCache.NUMERIC_UTILS_FLOAT_PARSER);
            }
            case DATE: {
                return new TrieDateFieldSource(field.getName(), FieldCache.NUMERIC_UTILS_LONG_PARSER);
            }
            case LONG: {
                return new LongFieldSource(field.getName(), FieldCache.NUMERIC_UTILS_LONG_PARSER);
            }
            case DOUBLE: {
                return new DoubleFieldSource(field.getName(), FieldCache.NUMERIC_UTILS_DOUBLE_PARSER);
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + field.name);
    }

    @Override
    public void write(XMLWriter xmlWriter, String name, Fieldable f) throws IOException {
        xmlWriter.writeVal(name, this.toObject(f));
    }

    @Override
    public void write(TextResponseWriter writer, String name, Fieldable f) throws IOException {
        writer.writeVal(name, this.toObject(f));
    }

    @Override
    public boolean isTokenized() {
        return true;
    }

    @Override
    public boolean multiValuedFieldCache() {
        return false;
    }

    public int getPrecisionStep() {
        return this.precisionStepArg;
    }

    public TrieTypes getType() {
        return this.type;
    }

    @Override
    public Query getRangeQuery(QParser parser, SchemaField field, String min, String max, boolean minInclusive, boolean maxInclusive) {
        int ps = this.precisionStep;
        NumericRangeQuery query = null;
        switch (this.type) {
            case INTEGER: {
                query = NumericRangeQuery.newIntRange((String)field.getName(), (int)ps, (Integer)(min == null ? null : Integer.valueOf(Integer.parseInt(min))), (Integer)(max == null ? null : Integer.valueOf(Integer.parseInt(max))), (boolean)minInclusive, (boolean)maxInclusive);
                break;
            }
            case FLOAT: {
                query = NumericRangeQuery.newFloatRange((String)field.getName(), (int)ps, (Float)(min == null ? null : Float.valueOf(Float.parseFloat(min))), (Float)(max == null ? null : Float.valueOf(Float.parseFloat(max))), (boolean)minInclusive, (boolean)maxInclusive);
                break;
            }
            case LONG: {
                query = NumericRangeQuery.newLongRange((String)field.getName(), (int)ps, (Long)(min == null ? null : Long.valueOf(Long.parseLong(min))), (Long)(max == null ? null : Long.valueOf(Long.parseLong(max))), (boolean)minInclusive, (boolean)maxInclusive);
                break;
            }
            case DOUBLE: {
                query = NumericRangeQuery.newDoubleRange((String)field.getName(), (int)ps, (Double)(min == null ? null : Double.valueOf(Double.parseDouble(min))), (Double)(max == null ? null : Double.valueOf(Double.parseDouble(max))), (boolean)minInclusive, (boolean)maxInclusive);
                break;
            }
            case DATE: {
                query = NumericRangeQuery.newLongRange((String)field.getName(), (int)ps, (Long)(min == null ? null : Long.valueOf(dateField.parseMath(null, min).getTime())), max == null ? null : Long.valueOf(dateField.parseMath(null, max).getTime()), (boolean)minInclusive, (boolean)maxInclusive);
                break;
            }
            default: {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field");
            }
        }
        return query;
    }

    @Deprecated
    static int toInt(byte[] arr) {
        return arr[0] << 24 | (arr[1] & 0xFF) << 16 | (arr[2] & 0xFF) << 8 | arr[3] & 0xFF;
    }

    @Deprecated
    static long toLong(byte[] arr) {
        int high = arr[0] << 24 | (arr[1] & 0xFF) << 16 | (arr[2] & 0xFF) << 8 | arr[3] & 0xFF;
        int low = arr[4] << 24 | (arr[5] & 0xFF) << 16 | (arr[6] & 0xFF) << 8 | arr[7] & 0xFF;
        return (long)high << 32 | (long)low & 0xFFFFFFFFL;
    }

    @Override
    public String storedToReadable(Fieldable f) {
        return this.toExternal(f);
    }

    @Override
    public String readableToIndexed(String val) {
        switch (this.type) {
            case INTEGER: {
                return NumericUtils.intToPrefixCoded((int)Integer.parseInt(val));
            }
            case FLOAT: {
                return NumericUtils.intToPrefixCoded((int)NumericUtils.floatToSortableInt((float)Float.parseFloat(val)));
            }
            case LONG: {
                return NumericUtils.longToPrefixCoded((long)Long.parseLong(val));
            }
            case DOUBLE: {
                return NumericUtils.longToPrefixCoded((long)NumericUtils.doubleToSortableLong((double)Double.parseDouble(val)));
            }
            case DATE: {
                return NumericUtils.longToPrefixCoded((long)dateField.parseMath(null, val).getTime());
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + (Object)((Object)this.type));
    }

    @Override
    public String toInternal(String val) {
        return this.readableToIndexed(val);
    }

    static String badFieldString(Fieldable f) {
        String s = f.stringValue();
        return "ERROR:SCHEMA-INDEX-MISMATCH,stringValue=" + s;
    }

    @Override
    public String toExternal(Fieldable f) {
        return this.type == TrieTypes.DATE ? dateField.toExternal((Date)this.toObject(f)) : this.toObject(f).toString();
    }

    @Override
    public String indexedToReadable(String indexedForm) {
        switch (this.type) {
            case INTEGER: {
                return Integer.toString(NumericUtils.prefixCodedToInt((String)indexedForm));
            }
            case FLOAT: {
                return Float.toString(NumericUtils.sortableIntToFloat((int)NumericUtils.prefixCodedToInt((String)indexedForm)));
            }
            case LONG: {
                return Long.toString(NumericUtils.prefixCodedToLong((String)indexedForm));
            }
            case DOUBLE: {
                return Double.toString(NumericUtils.sortableLongToDouble((long)NumericUtils.prefixCodedToLong((String)indexedForm)));
            }
            case DATE: {
                return dateField.toExternal(new Date(NumericUtils.prefixCodedToLong((String)indexedForm)));
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + (Object)((Object)this.type));
    }

    @Override
    public String storedToIndexed(Fieldable f) {
        if (f instanceof NumericField) {
            Number val = ((NumericField)f).getNumericValue();
            if (val == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid field contents: " + f.name());
            }
            switch (this.type) {
                case INTEGER: {
                    return NumericUtils.intToPrefixCoded((int)val.intValue());
                }
                case FLOAT: {
                    return NumericUtils.intToPrefixCoded((int)NumericUtils.floatToSortableInt((float)val.floatValue()));
                }
                case LONG: 
                case DATE: {
                    return NumericUtils.longToPrefixCoded((long)val.longValue());
                }
                case DOUBLE: {
                    return NumericUtils.longToPrefixCoded((long)NumericUtils.doubleToSortableLong((double)val.doubleValue()));
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + f.name());
        }
        byte[] arr = f.getBinaryValue();
        if (arr == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid field contents: " + f.name());
        }
        switch (this.type) {
            case INTEGER: {
                return NumericUtils.intToPrefixCoded((int)TrieField.toInt(arr));
            }
            case FLOAT: {
                int v = TrieField.toInt(arr);
                if (v < 0) {
                    v ^= Integer.MAX_VALUE;
                }
                return NumericUtils.intToPrefixCoded((int)v);
            }
            case LONG: 
            case DATE: {
                return NumericUtils.longToPrefixCoded((long)TrieField.toLong(arr));
            }
            case DOUBLE: {
                long v = TrieField.toLong(arr);
                if (v < 0L) {
                    v ^= Long.MAX_VALUE;
                }
                return NumericUtils.longToPrefixCoded((long)v);
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + f.name());
    }

    @Override
    public Fieldable createField(SchemaField field, String externalVal, float boost) {
        boolean indexed = field.indexed();
        boolean stored = field.stored();
        if (!indexed && !stored) {
            if (log.isTraceEnabled()) {
                log.trace("Ignoring unindexed/unstored field: " + field);
            }
            return null;
        }
        NumericField f = new NumericField(field.getName(), this.precisionStep, stored ? Field.Store.YES : Field.Store.NO, indexed);
        switch (this.type) {
            case INTEGER: {
                f.setIntValue(Integer.parseInt(externalVal));
                break;
            }
            case FLOAT: {
                f.setFloatValue(Float.parseFloat(externalVal));
                break;
            }
            case LONG: {
                f.setLongValue(Long.parseLong(externalVal));
                break;
            }
            case DOUBLE: {
                f.setDoubleValue(Double.parseDouble(externalVal));
                break;
            }
            case DATE: {
                f.setLongValue(dateField.parseMath(null, externalVal).getTime());
                break;
            }
            default: {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + (Object)((Object)this.type));
            }
        }
        f.setOmitNorms(field.omitNorms());
        f.setIndexOptions(this.getIndexOptions(field, externalVal));
        f.setBoost(boost);
        return f;
    }

    public static String getMainValuePrefix(FieldType ft) {
        if (ft instanceof TrieDateField) {
            ft = ((TrieDateField)ft).wrappedField;
        }
        if (ft instanceof TrieField) {
            TrieField trie = (TrieField)ft;
            if (trie.precisionStep == Integer.MAX_VALUE) {
                return null;
            }
            switch (trie.type) {
                case INTEGER: 
                case FLOAT: {
                    return INT_PREFIX;
                }
                case LONG: 
                case DOUBLE: 
                case DATE: {
                    return LONG_PREFIX;
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + (Object)((Object)trie.type));
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TrieTypes {
        INTEGER,
        LONG,
        FLOAT,
        DOUBLE,
        DATE;

    }
}

