/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.search.WrappedQuery;

public class QueryUtils {
    static boolean isNegative(Query q) {
        if (!(q instanceof BooleanQuery)) {
            return false;
        }
        BooleanQuery bq = (BooleanQuery)q;
        List clauses = bq.clauses();
        if (clauses.size() == 0) {
            return false;
        }
        for (BooleanClause clause : clauses) {
            if (clause.isProhibited()) continue;
            return false;
        }
        return true;
    }

    static Query getAbs(Query q) {
        if (q instanceof WrappedQuery) {
            Query subQ = ((WrappedQuery)q).getWrappedQuery();
            Query absSubQ = QueryUtils.getAbs(subQ);
            if (absSubQ == subQ) {
                return q;
            }
            WrappedQuery newQ = (WrappedQuery)q.clone();
            newQ.setWrappedQuery(absSubQ);
            return newQ;
        }
        if (!(q instanceof BooleanQuery)) {
            return q;
        }
        BooleanQuery bq = (BooleanQuery)q;
        List clauses = bq.clauses();
        if (clauses.size() == 0) {
            return q;
        }
        for (BooleanClause clause : clauses) {
            if (clause.isProhibited()) continue;
            return q;
        }
        if (clauses.size() == 1) {
            Query negClause = ((BooleanClause)clauses.get(0)).getQuery();
            return negClause;
        }
        BooleanQuery newBq = new BooleanQuery(bq.isCoordDisabled());
        newBq.setBoost(bq.getBoost());
        for (BooleanClause clause : clauses) {
            newBq.add(clause.getQuery(), BooleanClause.Occur.SHOULD);
        }
        return newBq;
    }

    static Query makeQueryable(Query q) {
        if (q instanceof WrappedQuery) {
            return QueryUtils.makeQueryable(((WrappedQuery)q).getWrappedQuery());
        }
        return QueryUtils.isNegative(q) ? QueryUtils.fixNegativeQuery(q) : q;
    }

    static Query fixNegativeQuery(Query q) {
        BooleanQuery newBq = (BooleanQuery)q.clone();
        newBq.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
        return newBq;
    }
}

