/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NoSuchDirectoryException;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NRTCachingDirectory
extends Directory {
    private final RAMDirectory cache = new RAMDirectory();
    private final Directory delegate;
    private final long maxMergeSizeBytes;
    private final long maxCachedBytes;
    private static final boolean VERBOSE = false;
    private final ConcurrentHashMap<Thread, MergePolicy.OneMerge> merges = new ConcurrentHashMap();

    public NRTCachingDirectory(Directory delegate, double maxMergeSizeMB, double maxCachedMB) {
        this.delegate = delegate;
        this.maxMergeSizeBytes = (long)(maxMergeSizeMB * 1024.0 * 1024.0);
        this.maxCachedBytes = (long)(maxCachedMB * 1024.0 * 1024.0);
    }

    public LockFactory getLockFactory() {
        return this.delegate.getLockFactory();
    }

    public void setLockFactory(LockFactory lf) throws IOException {
        this.delegate.setLockFactory(lf);
    }

    public String getLockID() {
        return this.delegate.getLockID();
    }

    public Lock makeLock(String name) {
        return this.delegate.makeLock(name);
    }

    public void clearLock(String name) throws IOException {
        this.delegate.clearLock(name);
    }

    public String toString() {
        return "NRTCachingDirectory(" + this.delegate + "; maxCacheMB=" + (double)(this.maxCachedBytes / 1024L) / 1024.0 + " maxMergeSizeMB=" + (double)(this.maxMergeSizeBytes / 1024L) / 1024.0 + ")";
    }

    public synchronized String[] listAll() throws IOException {
        HashSet<String> files;
        block4: {
            files = new HashSet<String>();
            for (String f : this.cache.listAll()) {
                files.add(f);
            }
            try {
                for (String f : this.delegate.listAll()) {
                    files.add(f);
                }
            }
            catch (NoSuchDirectoryException ex) {
                if (!files.isEmpty()) break block4;
                throw ex;
            }
        }
        return files.toArray(new String[files.size()]);
    }

    public long sizeInBytes() {
        return this.cache.sizeInBytes();
    }

    public synchronized boolean fileExists(String name) throws IOException {
        return this.cache.fileExists(name) || this.delegate.fileExists(name);
    }

    public synchronized long fileModified(String name) throws IOException {
        if (this.cache.fileExists(name)) {
            return this.cache.fileModified(name);
        }
        return this.delegate.fileModified(name);
    }

    @Deprecated
    public synchronized void touchFile(String name) throws IOException {
        if (this.cache.fileExists(name)) {
            this.cache.touchFile(name);
        } else {
            this.delegate.touchFile(name);
        }
    }

    public synchronized void deleteFile(String name) throws IOException {
        if (this.cache.fileExists(name)) {
            assert (!this.delegate.fileExists(name));
            this.cache.deleteFile(name);
        } else {
            this.delegate.deleteFile(name);
        }
    }

    public synchronized long fileLength(String name) throws IOException {
        if (this.cache.fileExists(name)) {
            return this.cache.fileLength(name);
        }
        return this.delegate.fileLength(name);
    }

    public String[] listCachedFiles() {
        return this.cache.listAll();
    }

    public IndexOutput createOutput(String name) throws IOException {
        if (this.doCacheWrite(name)) {
            return this.cache.createOutput(name);
        }
        return this.delegate.createOutput(name);
    }

    public void sync(Collection<String> fileNames) throws IOException {
        for (String fileName : fileNames) {
            this.unCache(fileName);
        }
        this.delegate.sync(fileNames);
    }

    public synchronized IndexInput openInput(String name) throws IOException {
        if (this.cache.fileExists(name)) {
            return this.cache.openInput(name);
        }
        return this.delegate.openInput(name);
    }

    public synchronized IndexInput openInput(String name, int bufferSize) throws IOException {
        if (this.cache.fileExists(name)) {
            return this.cache.openInput(name, bufferSize);
        }
        return this.delegate.openInput(name, bufferSize);
    }

    public void close() throws IOException {
        for (String fileName : this.cache.listAll()) {
            this.unCache(fileName);
        }
        this.cache.close();
        this.delegate.close();
    }

    public MergeScheduler getMergeScheduler() {
        return new ConcurrentMergeScheduler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void doMerge(MergePolicy.OneMerge merge) throws IOException {
                try {
                    NRTCachingDirectory.this.merges.put(Thread.currentThread(), merge);
                    super.doMerge(merge);
                }
                finally {
                    NRTCachingDirectory.this.merges.remove(Thread.currentThread());
                }
            }
        };
    }

    protected boolean doCacheWrite(String name) {
        MergePolicy.OneMerge merge = this.merges.get(Thread.currentThread());
        return !name.equals("segments.gen") && (merge == null || merge.estimatedMergeBytes <= this.maxMergeSizeBytes) && this.cache.sizeInBytes() <= this.maxCachedBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unCache(String fileName) throws IOException {
        block11: {
            IndexOutput out;
            NRTCachingDirectory nRTCachingDirectory = this;
            synchronized (nRTCachingDirectory) {
                if (!this.delegate.fileExists(fileName)) {
                    assert (this.cache.fileExists(fileName));
                    out = this.delegate.createOutput(fileName);
                } else {
                    out = null;
                }
            }
            if (out == null) break block11;
            IndexInput in = null;
            try {
                in = this.cache.openInput(fileName);
                in.copyBytes(out, in.length());
            }
            catch (Throwable throwable) {
                IOUtils.close((Closeable[])new Closeable[]{in, out});
                throw throwable;
            }
            IOUtils.close((Closeable[])new Closeable[]{in, out});
            NRTCachingDirectory nRTCachingDirectory2 = this;
            synchronized (nRTCachingDirectory2) {
                this.cache.deleteFile(fileName);
            }
        }
    }
}

