/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.IOException;
import java.io.Reader;
import java.util.Properties;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.ContextImpl;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentStreamDataSource
extends DataSource<Reader> {
    private ContextImpl context;
    private ContentStream contentStream;
    private Reader reader;

    @Override
    public void init(Context context, Properties initProps) {
        this.context = (ContextImpl)context;
    }

    @Override
    public Reader getData(String query) {
        this.contentStream = this.context.getDocBuilder().requestParameters.contentStream;
        if (this.contentStream == null) {
            throw new DataImportHandlerException(500, "No stream available. The request has no body");
        }
        try {
            this.reader = this.contentStream.getReader();
            return this.reader;
        }
        catch (IOException e) {
            DataImportHandlerException.wrapAndThrow(500, e);
            return null;
        }
    }

    @Override
    public void close() {
        if (this.contentStream != null) {
            try {
                if (this.reader == null) {
                    this.reader = this.contentStream.getReader();
                }
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

