/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIter;
import java.util.Iterator;

public class QueryIterExtendByVar
extends QueryIter {
    private Binding binding;
    private Var var;
    private Iterator<Node> members;

    public QueryIterExtendByVar(Binding binding, Var var, Iterator<Node> members, ExecutionContext execCxt) {
        super(execCxt);
        if (binding.contains(var)) {
            throw new ARQInternalErrorException("Var " + var + " already set in " + binding);
        }
        this.binding = binding;
        this.var = var;
        this.members = members;
    }

    @Override
    protected boolean hasNextBinding() {
        return this.members.hasNext();
    }

    @Override
    protected Binding moveToNextBinding() {
        Node n = this.members.next();
        Binding b = BindingFactory.binding(this.binding, this.var, n);
        return b;
    }

    @Override
    protected void closeIterator() {
    }

    @Override
    protected void requestCancel() {
    }
}

