/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang3.time.FastDateFormat;

public class Utils {
    private static final FastDateFormat dateTimeFmt_display = FastDateFormat.getInstance("yyyy/MM/dd HH:mm:ss z");
    private static final FastDateFormat dateFmt_yyyymmdd = FastDateFormat.getInstance("yyyy-MM-ddZZ");
    private static final FastDateFormat dateTimeFmt_XSD_ms0 = FastDateFormat.getInstance("yyyy-MM-dd'T'HH:mm:ssZZ");
    private static final FastDateFormat dateTimeFmt_XSD_ms = FastDateFormat.getInstance("yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
    private static final FastDateFormat timeFmt_XSD_ms0 = FastDateFormat.getInstance("HH:mm:ssZZ");
    private static final FastDateFormat timeFmt_XSD_ms = FastDateFormat.getInstance("HH:mm:ss.SSSZZ");

    public static String className(Object obj) {
        if (obj == null) {
            return "null";
        }
        return Utils.classShortName(obj.getClass());
    }

    public static String classShortName(Class<?> cls) {
        String tmp = cls.getName();
        int i = tmp.lastIndexOf(46);
        tmp = tmp.substring(i + 1);
        return tmp;
    }

    public static String nowAsXSDDateTimeString() {
        return Utils.calendarToXSDDateTimeString(new GregorianCalendar());
    }

    public static String todayAsXSDDateString() {
        return Utils.calendarToXSDDateString(new GregorianCalendar());
    }

    public static String XSDDateTime2String(XSDDateTime xdt) {
        return xdt.toString();
    }

    public static String nowAsString() {
        return Utils.nowAsString(dateTimeFmt_display);
    }

    public static String nowAsString(String formatString) {
        FastDateFormat df = FastDateFormat.getInstance(formatString);
        return df.format(new Date());
    }

    public static String nowAsString(FastDateFormat dateFormat) {
        return dateFormat.format(new Date());
    }

    private static boolean hasZeroMilliSeconds(Calendar cal) {
        return !cal.isSet(14) || cal.get(14) == 0;
    }

    public static String calendarToXSDDateTimeString(Calendar cal) {
        FastDateFormat fmt = Utils.hasZeroMilliSeconds(cal) ? dateTimeFmt_XSD_ms0 : dateTimeFmt_XSD_ms;
        return Utils.calendarToXSDString(cal, fmt);
    }

    public static String calendarToXSDDateString(Calendar cal) {
        return Utils.calendarToXSDString(cal, dateFmt_yyyymmdd);
    }

    public static String calendarToXSDTimeString(Calendar cal) {
        FastDateFormat fmt = Utils.hasZeroMilliSeconds(cal) ? timeFmt_XSD_ms0 : timeFmt_XSD_ms;
        return Utils.calendarToXSDString(cal, fmt);
    }

    private static String calendarToXSDString(Calendar cal, FastDateFormat fmt) {
        String lex = fmt.format(cal);
        return lex;
    }

    public static String stringForm(BigDecimal decimal) {
        return decimal.toPlainString();
    }

    public static String stringForm(double d) {
        if (Double.isInfinite(d)) {
            if (d < 0.0) {
                return "-INF";
            }
            return "INF";
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        String x = Double.toString(d);
        if (x.indexOf(101) != -1 || x.indexOf(69) != -1) {
            return x;
        }
        return x + "e0";
    }

    public static String stringForm(float f) {
        return Float.toString(f);
    }
}

