/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.io;

import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public final class InputStreamUtils {
    private static final MLogger logger = MLog.getLogger(InputStreamUtils.class);
    private static InputStream EMPTY_ISTREAM = new ByteArrayInputStream(new byte[0]);

    public static boolean compare(InputStream is1, InputStream is2, long num_bytes) throws IOException {
        for (long num_read = 0L; num_read < num_bytes; ++num_read) {
            int b = is1.read();
            if (b != is2.read()) {
                return false;
            }
            if (b < 0) break;
        }
        return true;
    }

    public static boolean compare(InputStream is1, InputStream is2) throws IOException {
        int b = 0;
        while (b >= 0) {
            b = is1.read();
            if (b == is2.read()) continue;
            return false;
        }
        return true;
    }

    public static byte[] getBytes(InputStream is, int max_len) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(max_len);
        int b = is.read();
        for (int i = 0; b >= 0 && i < max_len; ++i) {
            baos.write(b);
            b = is.read();
        }
        return baos.toByteArray();
    }

    public static byte[] getBytes(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int b = is.read();
        while (b >= 0) {
            baos.write(b);
            b = is.read();
        }
        return baos.toByteArray();
    }

    public static String getContentsAsString(InputStream is, String enc) throws IOException, UnsupportedEncodingException {
        return new String(InputStreamUtils.getBytes(is), enc);
    }

    public static String getContentsAsString(InputStream is) throws IOException {
        try {
            return InputStreamUtils.getContentsAsString(is, System.getProperty("file.encoding", "8859_1"));
        }
        catch (UnsupportedEncodingException e2) {
            throw new InternalError("You have no default character encoding, and iso-8859-1 is unsupported?!?!");
        }
    }

    public static String getContentsAsString(InputStream is, int max_len, String enc) throws IOException, UnsupportedEncodingException {
        return new String(InputStreamUtils.getBytes(is, max_len), enc);
    }

    public static String getContentsAsString(InputStream is, int max_len) throws IOException {
        try {
            return InputStreamUtils.getContentsAsString(is, max_len, System.getProperty("file.encoding", "8859_1"));
        }
        catch (UnsupportedEncodingException e2) {
            throw new InternalError("You have no default character encoding, and iso-8859-1 is unsupported?!?!");
        }
    }

    public static InputStream getEmptyInputStream() {
        return EMPTY_ISTREAM;
    }

    public static void attemptClose(InputStream is) {
        block3: {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e2) {
                if (!logger.isLoggable(MLevel.WARNING)) break block3;
                logger.log(MLevel.WARNING, "InputStream close FAILED.", e2);
            }
        }
    }

    public static void skipFully(InputStream is, long num_bytes) throws EOFException, IOException {
        long num_skipped = 0L;
        while (num_skipped < num_bytes) {
            long just_skipped = is.skip(num_bytes - num_skipped);
            if (just_skipped > 0L) {
                num_skipped += just_skipped;
                continue;
            }
            int test_byte = is.read();
            if (is.read() < 0) {
                throw new EOFException("Skipped only " + num_skipped + " bytes to end of file.");
            }
            ++num_skipped;
        }
    }

    private InputStreamUtils() {
    }
}

