/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.CopyInformee;
import net.sf.saxon.event.LocationCopier;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.Sink;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.DummyNamespaceResolver;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.ValidatingInstruction;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.wrapper.VirtualCopy;
import net.sf.saxon.tree.wrapper.VirtualUntypedCopy;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.SequenceType;

public class CopyOf
extends Instruction
implements ValidatingInstruction {
    private Operand selectOp;
    private boolean copyNamespaces;
    private boolean copyAccumulators;
    private int validation;
    private SchemaType schemaType;
    private boolean requireDocumentOrElement = false;
    private boolean rejectDuplicateAttributes;
    private boolean validating;
    private boolean copyLineNumbers = false;
    private boolean copyForUpdate = false;
    private boolean isSchemaAware = true;

    public CopyOf(Expression select, boolean copyNamespaces, int validation, SchemaType schemaType, boolean rejectDuplicateAttributes) {
        this.selectOp = new Operand(this, select, OperandRole.SINGLE_ATOMIC);
        this.copyNamespaces = copyNamespaces;
        this.validation = validation;
        this.schemaType = schemaType;
        this.validating = schemaType != null || validation != 3;
        this.rejectDuplicateAttributes = rejectDuplicateAttributes;
    }

    public Expression getSelect() {
        return this.selectOp.getChildExpression();
    }

    public void setSelect(Expression select) {
        this.selectOp.setChildExpression(select);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.selectOp;
    }

    @Override
    public int getValidationAction() {
        return this.validation;
    }

    public boolean isValidating() {
        return this.validating;
    }

    @Override
    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    public void setSchemaAware(boolean schemaAware) {
        this.isSchemaAware = schemaAware;
    }

    public void setCopyLineNumbers(boolean copy) {
        this.copyLineNumbers = copy;
    }

    @Override
    public final boolean mayCreateNewNodes() {
        return !this.getSelect().getItemType().isPlainType();
    }

    @Override
    public int getInstructionNameCode() {
        return 146;
    }

    public void setRequireDocumentOrElement(boolean requireDocumentOrElement) {
        this.requireDocumentOrElement = requireDocumentOrElement;
    }

    public boolean isDocumentOrElementRequired() {
        return this.requireDocumentOrElement;
    }

    public void setCopyForUpdate(boolean forUpdate) {
        this.copyForUpdate = forUpdate;
    }

    public boolean isCopyForUpdate() {
        return this.copyForUpdate;
    }

    @Override
    public int getImplementationMethod() {
        return 14;
    }

    public boolean isCopyNamespaces() {
        return this.copyNamespaces;
    }

    public void setCopyAccumulators(boolean copy) {
        this.copyAccumulators = copy;
    }

    public boolean isCopyAccumulators() {
        return this.copyAccumulators;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        CopyOf c = new CopyOf(this.getSelect().copy(rebindings), this.copyNamespaces, this.validation, this.schemaType, this.rejectDuplicateAttributes);
        ExpressionTool.copyLocationInfo(this, c);
        c.setCopyForUpdate(this.copyForUpdate);
        c.setCopyLineNumbers(this.copyLineNumbers);
        c.isSchemaAware = this.isSchemaAware;
        c.setCopyAccumulators(this.copyAccumulators);
        return c;
    }

    @Override
    public ItemType getItemType() {
        ItemType in = this.getSelect().getItemType();
        if (!this.isSchemaAware) {
            return in;
        }
        Configuration config = this.getConfiguration();
        if (this.schemaType != null) {
            TypeHierarchy th = config.getTypeHierarchy();
            int e2 = th.relationship(in, NodeKindTest.ELEMENT);
            if (e2 == 0 || e2 == 2) {
                return new ContentTypeTest(1, this.schemaType, config, false);
            }
            int a = th.relationship(in, NodeKindTest.ATTRIBUTE);
            if (a == 0 || a == 2) {
                return new ContentTypeTest(2, this.schemaType, config, false);
            }
        } else {
            switch (this.validation) {
                case 3: {
                    return in;
                }
                case 4: {
                    TypeHierarchy th = config.getTypeHierarchy();
                    int e3 = th.relationship(in, NodeKindTest.ELEMENT);
                    if (e3 == 0 || e3 == 2) {
                        return new ContentTypeTest(1, Untyped.getInstance(), config, false);
                    }
                    int a = th.relationship(in, NodeKindTest.ATTRIBUTE);
                    if (a == 0 || a == 2) {
                        return new ContentTypeTest(2, BuiltInAtomicType.UNTYPED_ATOMIC, config, false);
                    }
                    if (e3 != 4 || a != 4) {
                        return in instanceof NodeTest ? AnyNodeTest.getInstance() : AnyItemType.getInstance();
                    }
                    return in;
                }
                case 1: 
                case 2: {
                    if (in instanceof NodeTest) {
                        TypeHierarchy th = config.getTypeHierarchy();
                        int fp = ((NodeTest)in).getFingerprint();
                        if (fp != -1) {
                            int e4 = th.relationship(in, NodeKindTest.ELEMENT);
                            if (e4 == 0 || e4 == 2) {
                                SchemaDeclaration elem = config.getElementDeclaration(fp);
                                if (elem != null) {
                                    try {
                                        return new ContentTypeTest(1, elem.getType(), config, false);
                                    }
                                    catch (MissingComponentException e1) {
                                        return new ContentTypeTest(1, AnyType.getInstance(), config, false);
                                    }
                                }
                                return new ContentTypeTest(1, AnyType.getInstance(), config, false);
                            }
                            int a = th.relationship(in, NodeKindTest.ATTRIBUTE);
                            if (a == 0 || a == 2) {
                                SchemaDeclaration attr = config.getElementDeclaration(fp);
                                if (attr != null) {
                                    try {
                                        return new ContentTypeTest(2, attr.getType(), config, false);
                                    }
                                    catch (MissingComponentException e1) {
                                        return new ContentTypeTest(2, AnySimpleType.getInstance(), config, false);
                                    }
                                }
                                return new ContentTypeTest(2, AnySimpleType.getInstance(), config, false);
                            }
                        } else {
                            int e5 = th.relationship(in, NodeKindTest.ELEMENT);
                            if (e5 == 0 || e5 == 2) {
                                return NodeKindTest.ELEMENT;
                            }
                            int a = th.relationship(in, NodeKindTest.ATTRIBUTE);
                            if (a == 0 || a == 2) {
                                return NodeKindTest.ATTRIBUTE;
                            }
                        }
                        return AnyNodeTest.getInstance();
                    }
                    if (in instanceof AtomicType) {
                        return in;
                    }
                    return AnyItemType.getInstance();
                }
            }
        }
        return this.getSelect().getItemType();
    }

    @Override
    public int getCardinality() {
        return this.getSelect().getCardinality();
    }

    @Override
    public int getDependencies() {
        return this.getSelect().getDependencies();
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        if (this.isDocumentOrElementRequired()) {
            RoleDiagnostic role = new RoleDiagnostic(2, "validate", 0);
            role.setErrorCode("XQTY0030");
            Configuration config = visitor.getConfiguration();
            this.setSelect(config.getTypeChecker(false).staticTypeCheck(this.getSelect(), SequenceType.SINGLE_NODE, role, visitor));
            TypeHierarchy th = config.getTypeHierarchy();
            ItemType t = this.getSelect().getItemType();
            if (th.isSubType(t, NodeKindTest.ATTRIBUTE)) {
                throw new XPathException("validate{} expression cannot be applied to an attribute", "XQTY0030");
            }
            if (th.isSubType(t, NodeKindTest.TEXT)) {
                throw new XPathException("validate{} expression cannot be applied to a text node", "XQTY0030");
            }
            if (th.isSubType(t, NodeKindTest.COMMENT)) {
                throw new XPathException("validate{} expression cannot be applied to a comment node", "XQTY0030");
            }
            if (th.isSubType(t, NodeKindTest.PROCESSING_INSTRUCTION)) {
                throw new XPathException("validate{} expression cannot be applied to a processing instruction node", "XQTY0030");
            }
            if (th.isSubType(t, NodeKindTest.NAMESPACE)) {
                throw new XPathException("validate{} expression cannot be applied to a namespace node", "XQTY0030");
            }
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        this.selectOp.optimize(visitor, contextItemType);
        if (Literal.isEmptySequence(this.getSelect())) {
            return this.getSelect();
        }
        this.adoptChildExpression(this.getSelect());
        if (this.getSelect().getItemType().isPlainType()) {
            return this.getSelect();
        }
        return this;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("copyOf", this);
        if (this.validation != 4) {
            out.emitAttribute("validation", Validation.toString(this.validation));
        }
        if (this.schemaType != null) {
            out.emitAttribute("type", this.schemaType.getStructuredQName());
        }
        FastStringBuffer fsb = new FastStringBuffer(16);
        if (this.requireDocumentOrElement) {
            fsb.append('p');
        }
        if (this.rejectDuplicateAttributes) {
            fsb.append('a');
        }
        if (this.validating) {
            fsb.append('v');
        }
        if (this.copyLineNumbers) {
            fsb.append('l');
        }
        if (this.copyForUpdate) {
            fsb.append('u');
        }
        if (this.isSchemaAware) {
            fsb.append('s');
        }
        if (this.copyNamespaces) {
            fsb.append('c');
        }
        if (this.copyAccumulators) {
            fsb.append('m');
        }
        if (!fsb.isEmpty()) {
            out.emitAttribute("flags", fsb.toString());
        }
        this.getSelect().export(out);
        out.endElement();
    }

    @Override
    public String getStreamerName() {
        return "CopyOf";
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet result = super.addToPathMap(pathMap, pathMapNodeSet);
        result.setReturnable(false);
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        ItemType type = this.getItemType();
        if (th.relationship(type, NodeKindTest.ELEMENT) != 4 || th.relationship(type, NodeKindTest.DOCUMENT) != 4) {
            result.addDescendants();
        }
        return new PathMap.PathMapNodeSet(pathMap.makeNewRoot(this));
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Receiver out = context.getReceiver();
        if (this.copyAccumulators) {
            if (this.mustPush()) {
                this.getSelect().iterate(context).forEachOrFail(item -> {
                    if (item instanceof NodeInfo) {
                        TinyBuilder builder = new TinyBuilder(out.getPipelineConfiguration());
                        builder.open();
                        this.copyOneNode(context, new TreeReceiver(builder), (NodeInfo)item, 2);
                        builder.close();
                        TinyNodeImpl copy = (TinyNodeImpl)builder.getCurrentRoot();
                        copy.getTree().setCopiedFrom((NodeInfo)item);
                        out.append(copy);
                    } else {
                        out.append(item);
                    }
                });
            } else {
                this.iterate(context).forEachOrFail(out::append);
            }
        } else {
            int copyOptions = 4 | (this.copyNamespaces ? 2 : 0) | (this.copyForUpdate ? 8 : 0);
            this.getSelect().iterate(context).forEachOrFail(item -> {
                if (item instanceof NodeInfo) {
                    this.copyOneNode(context, out, (NodeInfo)item, copyOptions);
                } else {
                    out.append(item, this.getLocation(), 524288);
                }
            });
        }
        return null;
    }

    private void copyOneNode(XPathContext context, Receiver out, NodeInfo item, int copyOptions) throws XPathException {
        Controller controller = context.getController();
        boolean copyBaseURI = out.getSystemId() == null;
        int kind = item.getNodeKind();
        if (this.requireDocumentOrElement && kind != 1 && kind != 9) {
            XPathException e2 = new XPathException("Operand of validate expression must be a document or element node");
            e2.setXPathContext(context);
            e2.setErrorCode("XQTY0030");
            throw e2;
        }
        Configuration config = controller.getConfiguration();
        switch (kind) {
            case 1: {
                Receiver eval2 = out;
                if (this.validating) {
                    String xsitype;
                    ParseOptions options = new ParseOptions();
                    options.setSchemaValidationMode(this.validation);
                    SchemaType type = this.schemaType;
                    if (type == null && (this.validation == 1 || this.validation == 2) && (xsitype = item.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) != null) {
                        StructuredQName typeName;
                        try {
                            typeName = StructuredQName.fromLexicalQName(xsitype, true, false, new InscopeNamespaceResolver(item));
                        }
                        catch (XPathException e3) {
                            throw new XPathException("Invalid QName in xsi:type attribute of element being validated: " + xsitype + ". " + e3.getMessage(), "XTTE1510");
                        }
                        type = config.getSchemaType(typeName);
                        if (type == null) {
                            throw new XPathException("Unknown xsi:type in element being validated: " + xsitype, "XTTE1510");
                        }
                    }
                    options.setTopLevelType(type);
                    options.setTopLevelElement(NameOfNode.makeName(item).getStructuredQName());
                    options.setErrorListener(context.getErrorListener());
                    config.prepareValidationReporting(context, options);
                    eval2 = config.getElementValidator(out, options, this.getLocation());
                }
                if (copyBaseURI) {
                    eval2.setSystemId(CopyOf.computeNewBaseUri(item, this.getStaticBaseURIString()));
                }
                Receiver savedReceiver = null;
                PipelineConfiguration savedPipe = null;
                if (this.copyLineNumbers) {
                    savedReceiver = eval2;
                    PipelineConfiguration pipe = eval2.getPipelineConfiguration();
                    savedPipe = new PipelineConfiguration(pipe);
                    LocationCopier copier = new LocationCopier(false);
                    pipe.setComponent(CopyInformee.class.getName(), copier);
                }
                item.copy(eval2, copyOptions, this.getLocation());
                if (!this.copyLineNumbers) break;
                eval2 = savedReceiver;
                assert (eval2 != null);
                eval2.setPipelineConfiguration(savedPipe);
                break;
            }
            case 2: {
                if (this.schemaType != null && this.schemaType.isComplexType()) {
                    XPathException e4 = new XPathException("When copying an attribute with schema validation, the requested type must not be a complex type");
                    e4.setLocation(this.getLocation());
                    e4.setXPathContext(context);
                    e4.setErrorCode("XTTE1535");
                    throw CopyOf.dynamicError(this.getLocation(), e4, context);
                }
                try {
                    CopyOf.copyAttribute(item, (SimpleType)this.schemaType, this.validation, this, context, this.rejectDuplicateAttributes);
                    break;
                }
                catch (NoOpenStartTagException err) {
                    XPathException e5 = new XPathException(err.getMessage());
                    e5.setLocation(this.getLocation());
                    e5.setXPathContext(context);
                    e5.setErrorCodeQName(err.getErrorCodeQName());
                    throw CopyOf.dynamicError(this.getLocation(), e5, context);
                }
            }
            case 3: {
                out.characters(item.getStringValueCS(), this.getLocation(), 0);
                break;
            }
            case 7: {
                if (copyBaseURI) {
                    out.setSystemId(item.getBaseURI());
                }
                out.processingInstruction(item.getDisplayName(), item.getStringValueCS(), this.getLocation(), 0);
                break;
            }
            case 8: {
                out.comment(item.getStringValueCS(), this.getLocation(), 0);
                break;
            }
            case 13: {
                try {
                    item.copy(out, 0, this.getLocation());
                    break;
                }
                catch (NoOpenStartTagException err) {
                    XPathException e6 = new XPathException(err.getMessage());
                    e6.setXPathContext(context);
                    e6.setErrorCodeQName(err.getErrorCodeQName());
                    throw CopyOf.dynamicError(this.getLocation(), e6, context);
                }
            }
            case 9: {
                ParseOptions options = new ParseOptions();
                options.setSchemaValidationMode(this.validation);
                options.setSpaceStrippingRule(NoElementsSpaceStrippingRule.getInstance());
                options.setTopLevelType(this.schemaType);
                options.setErrorListener(context.getErrorListener());
                config.prepareValidationReporting(context, options);
                Receiver val = config.getDocumentValidator(out, item.getBaseURI(), options, this.getLocation());
                if (copyBaseURI) {
                    val.setSystemId(item.getBaseURI());
                }
                Receiver savedReceiver = null;
                PipelineConfiguration savedPipe = null;
                if (this.copyLineNumbers) {
                    savedReceiver = val;
                    savedPipe = new PipelineConfiguration(val.getPipelineConfiguration());
                    LocationCopier copier = new LocationCopier(true);
                    val.getPipelineConfiguration().setComponent(CopyInformee.class.getName(), copier);
                }
                item.copy(val, copyOptions, this.getLocation());
                if (!this.copyLineNumbers) break;
                val = savedReceiver;
                assert (val != null);
                val.setPipelineConfiguration(savedPipe);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown node kind " + item.getNodeKind());
            }
        }
    }

    public static String computeNewBaseUri(NodeInfo source, String staticBaseURI) {
        String newBaseUri;
        block6: {
            String xmlBase = source.getAttributeValue("http://www.w3.org/XML/1998/namespace", "base");
            if (xmlBase != null) {
                try {
                    URI xmlBaseUri = new URI(xmlBase);
                    if (xmlBaseUri.isAbsolute()) {
                        newBaseUri = xmlBase;
                        break block6;
                    }
                    if (staticBaseURI != null) {
                        URI sbu = new URI(staticBaseURI);
                        URI abs = sbu.resolve(xmlBaseUri);
                        newBaseUri = abs.toString();
                        break block6;
                    }
                    newBaseUri = source.getBaseURI();
                }
                catch (URISyntaxException err) {
                    newBaseUri = source.getBaseURI();
                }
            } else {
                newBaseUri = source.getBaseURI();
            }
        }
        return newBaseUri;
    }

    static void copyAttribute(NodeInfo source, SimpleType schemaType, int validation, Instruction instruction, XPathContext context, boolean rejectDuplicates) throws XPathException {
        int opt = 0;
        if (rejectDuplicates) {
            opt |= 0x20;
        }
        CharSequence value = source.getStringValueCS();
        SimpleType annotation = CopyOf.validateAttribute(source, schemaType, validation, context);
        try {
            context.getReceiver().attribute(NameOfNode.makeName(source), annotation, value, instruction.getLocation(), opt);
        }
        catch (XPathException e2) {
            e2.maybeSetContext(context);
            e2.maybeSetLocation(instruction.getLocation());
            if (instruction.getPackageData().getHostLanguage() == 51 && e2.getErrorCodeLocalPart().equals("XTTE0950")) {
                e2.setErrorCode("XQTY0086");
            }
            throw e2;
        }
    }

    public static SimpleType validateAttribute(NodeInfo source, SimpleType schemaType, int validation, XPathContext context) throws XPathException {
        CharSequence value = source.getStringValueCS();
        SimpleType annotation = BuiltInAtomicType.UNTYPED_ATOMIC;
        if (schemaType != null) {
            if (schemaType.isNamespaceSensitive()) {
                XPathException err = new XPathException("Cannot create a parentless attribute whose type is namespace-sensitive (such as xs:QName)");
                err.setErrorCode("XTTE1545");
                throw err;
            }
            ValidationFailure err = schemaType.validateContent(value, DummyNamespaceResolver.getInstance(), context.getConfiguration().getConversionRules());
            if (err != null) {
                err.setMessage("Attribute being copied does not match the required type. " + err.getMessage());
                err.setErrorCode("XTTE1510");
                throw err.makeException();
            }
            annotation = schemaType;
        } else if (validation == 1 || validation == 2) {
            try {
                annotation = context.getConfiguration().validateAttribute(NameOfNode.makeName(source).getStructuredQName(), value, validation);
            }
            catch (ValidationException e2) {
                XPathException err = XPathException.makeXPathException(e2);
                err.setErrorCodeQName(e2.getErrorCodeQName());
                err.setIsTypeError(true);
                throw err;
            }
        } else if (validation == 3 && !(annotation = (SimpleType)source.getSchemaType()).equals(BuiltInAtomicType.UNTYPED_ATOMIC) && annotation.isNamespaceSensitive()) {
            XPathException err = new XPathException("Cannot preserve type annotation when copying an attribute with namespace-sensitive content");
            err.setErrorCode(context.getController().getExecutable().getHostLanguage() == 50 ? "XTTE0950" : "XQTY0086");
            err.setIsTypeError(true);
            throw err;
        }
        return annotation;
    }

    private boolean mustPush() {
        return this.schemaType != null || this.validation == 2 || this.validation == 1 || this.copyForUpdate;
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        if (this.schemaType == null && !this.copyForUpdate) {
            if (this.validation == 3) {
                ItemMappingFunction<Item, Item> copier = item -> {
                    if (item instanceof NodeInfo) {
                        if (((NodeInfo)item).getTreeInfo().isTyped()) {
                            if (!this.copyNamespaces && ((NodeInfo)item).getNodeKind() == 1) {
                                Sink sink = new Sink(controller.makePipelineConfiguration());
                                ((NodeInfo)item).copy(sink, 4, this.getLocation());
                            }
                            if (((NodeInfo)item).getNodeKind() == 2 && ((SimpleType)((NodeInfo)item).getSchemaType()).isNamespaceSensitive()) {
                                throw new XPathException("Cannot copy an attribute with namespace-sensitive content except as part of its containing element", "XTTE0950");
                            }
                        }
                        VirtualCopy vc = VirtualCopy.makeVirtualCopy((NodeInfo)item);
                        vc.setDropNamespaces(!this.copyNamespaces);
                        vc.getTreeInfo().setCopyAccumulators(this.copyAccumulators);
                        if (((NodeInfo)item).getNodeKind() == 1) {
                            vc.setSystemId(CopyOf.computeNewBaseUri((NodeInfo)item, this.getStaticBaseURIString()));
                        }
                        return vc;
                    }
                    return item;
                };
                return new ItemMappingIterator<Item, Item>(this.getSelect().iterate(context), copier, true);
            }
            if (this.validation == 4) {
                ItemMappingFunction<Item, Item> copier = item -> {
                    if (!(item instanceof NodeInfo)) {
                        return item;
                    }
                    VirtualCopy vc = VirtualUntypedCopy.makeVirtualUntypedTree((NodeInfo)item, (NodeInfo)item);
                    vc.getTreeInfo().setCopyAccumulators(this.copyAccumulators);
                    vc.setDropNamespaces(!this.copyNamespaces);
                    if (((NodeInfo)item).getNodeKind() == 1) {
                        vc.setSystemId(CopyOf.computeNewBaseUri((NodeInfo)item, this.getStaticBaseURIString()));
                    }
                    return vc;
                };
                return new ItemMappingIterator<Item, Item>(this.getSelect().iterate(context), copier, true);
            }
        }
        Receiver saved = context.getReceiver();
        PipelineConfiguration pipe = controller.makePipelineConfiguration();
        pipe.setXPathContext(context);
        SequenceOutputter out = new SequenceOutputter(pipe);
        if (this.copyForUpdate) {
            out.setTreeModel(TreeModel.LINKED_TREE);
        }
        pipe.setHostLanguage(this.getPackageData().getHostLanguage());
        context.setReceiver(out);
        try {
            this.process(context);
        }
        catch (XPathException err) {
            err.maybeSetLocation(this.getLocation());
            err.maybeSetContext(context);
            throw err;
        }
        context.setReceiver(saved);
        return out.getSequence().iterate();
    }
}

