/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.lib.ResourceFactory;
import net.sf.saxon.ma.json.ParseJsonFn;
import net.sf.saxon.om.Item;
import net.sf.saxon.resource.AbstractResourceCollection;
import net.sf.saxon.resource.CatalogCollection;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.StringValue;

public class JSONResource
implements Resource {
    private String href;
    private String jsonStr;
    private InputStream inputStream;
    private String encoding;
    public static final ResourceFactory FACTORY = new ResourceFactory(){

        @Override
        public Resource makeResource(Configuration config, String resourceURI, String contentType, AbstractResourceCollection.InputDetails details) throws XPathException {
            return new JSONResource(resourceURI, details);
        }
    };

    public JSONResource(String href, AbstractResourceCollection.InputDetails details) {
        this.href = href;
        this.inputStream = details.inputStream;
        this.encoding = details.encoding;
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
    }

    public JSONResource(String href, InputStream in) {
        this.href = href;
        this.inputStream = in;
        this.encoding = "utf-8";
    }

    @Override
    public String getResourceURI() {
        return this.href;
    }

    public Item getItem(XPathContext context) throws XPathException {
        if (this.jsonStr == null) {
            try {
                StringBuilder sb = CatalogCollection.makeStringBuilderFromStream(this.inputStream, this.encoding);
                this.jsonStr = sb.toString();
            }
            catch (IOException e2) {
                throw new XPathException(e2);
            }
        }
        HashMap options = new HashMap();
        options.put("liberal", BooleanValue.FALSE);
        options.put("duplicates", new StringValue("use-first"));
        options.put("escape", BooleanValue.FALSE);
        return ParseJsonFn.parse(this.jsonStr, options, context);
    }

    @Override
    public String getContentType() {
        return "application/json";
    }
}

