/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.manager;

import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.factory.ComponentInstantiationException;
import org.codehaus.plexus.component.manager.ComponentManager;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.lifecycle.LifecycleHandler;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.PhaseExecutionException;

public abstract class AbstractComponentManager
implements ComponentManager,
Cloneable {
    private PlexusContainer container;
    private ComponentDescriptor componentDescriptor;
    private LifecycleHandler lifecycleHandler;
    private int connections;
    private String id = null;

    public ComponentManager copy() {
        try {
            ComponentManager componentManager = (ComponentManager)this.clone();
            return componentManager;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public ComponentDescriptor getComponentDescriptor() {
        return this.componentDescriptor;
    }

    public String getId() {
        return this.id;
    }

    public LifecycleHandler getLifecycleHandler() {
        return this.lifecycleHandler;
    }

    protected void incrementConnectionCount() {
        ++this.connections;
    }

    protected void decrementConnectionCount() {
        --this.connections;
    }

    protected boolean connected() {
        return this.connections > 0;
    }

    public int getConnections() {
        return this.connections;
    }

    public void setup(PlexusContainer container2, LifecycleHandler lifecycleHandler, ComponentDescriptor componentDescriptor) {
        this.container = container2;
        this.lifecycleHandler = lifecycleHandler;
        this.componentDescriptor = componentDescriptor;
    }

    public void initialize() {
    }

    protected Object createComponentInstance() throws ComponentInstantiationException, ComponentLifecycleException {
        Object component = this.container.createComponentInstance(this.componentDescriptor);
        this.startComponentLifecycle(component);
        return component;
    }

    protected void startComponentLifecycle(Object component) throws ComponentLifecycleException {
        try {
            this.getLifecycleHandler().start(component, this);
        }
        catch (PhaseExecutionException e2) {
            throw new ComponentLifecycleException("Error starting component", e2);
        }
    }

    public void suspend(Object component) throws ComponentLifecycleException {
        try {
            this.getLifecycleHandler().suspend(component, this);
        }
        catch (PhaseExecutionException e2) {
            throw new ComponentLifecycleException("Error suspending component", e2);
        }
    }

    public void resume(Object component) throws ComponentLifecycleException {
        try {
            this.getLifecycleHandler().resume(component, this);
        }
        catch (PhaseExecutionException e2) {
            throw new ComponentLifecycleException("Error suspending component", e2);
        }
    }

    protected void endComponentLifecycle(Object component) throws ComponentLifecycleException {
        try {
            this.getLifecycleHandler().end(component, this);
        }
        catch (PhaseExecutionException e2) {
            throw new ComponentLifecycleException("Error ending component lifecycle", e2);
        }
    }

    public PlexusContainer getContainer() {
        return this.container;
    }

    public Logger getLogger() {
        return this.container.getLogger();
    }

    public abstract /* synthetic */ Object getComponent() throws ComponentInstantiationException, ComponentLifecycleException;

    public abstract /* synthetic */ void release(Object var1) throws ComponentLifecycleException;

    public abstract /* synthetic */ void dispose() throws ComponentLifecycleException;
}

