/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.index;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.cn.index.App;
import org.dataone.cn.index.IndexingTask;

public class IndexingTaskList
extends ArrayList<IndexingTask> {
    private static String basePath = "";
    Log log = LogFactory.getLog(App.class);

    public IndexingTaskList(String sourcePath) {
        this.loadTasks(sourcePath);
    }

    public IndexingTaskList(String sourcePath, String basePath) {
        if (basePath != null) {
            this.log.info("Initializing with basePath = " + basePath);
            IndexingTaskList.basePath = basePath;
        }
        this.loadTasks(sourcePath);
    }

    public void loadTasks(String sourcePath) {
        File sourceFile = new File(sourcePath);
        try {
            List<String> lines = FileUtils.readLines(sourceFile);
            int lineCount = 0;
            IndexingTask task = null;
            for (String line : lines) {
                if (line.startsWith("TIMESTAMP")) continue;
                if (task == null || line.trim().equals("::")) {
                    if (task != null) {
                        this.add(task);
                    }
                    task = new IndexingTask();
                    lineCount = 0;
                    continue;
                }
                switch (++lineCount) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        task.setPid(line);
                        break;
                    }
                    case 2: {
                        task.setFmtid(line);
                        break;
                    }
                    case 3: {
                        task.setDateSysmModified(line);
                        break;
                    }
                    case 4: {
                        task.setSysMetaPath(basePath + line);
                        break;
                    }
                    case 5: {
                        if (!(!line.equals("null") & line != null)) break;
                        task.setObjectPath(basePath + line);
                    }
                }
            }
        }
        catch (IOException e2) {
            this.log.error(e2.getMessage());
        }
    }
}

