/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.index.processor;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.dataone.cn.index.processor.IndexTaskProcessorJob;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class IndexTaskProcessorScheduler {
    private static Logger logger = Logger.getLogger(IndexTaskProcessorScheduler.class.getName());
    private static final String QUARTZ_PROCESSOR_TRIGGER = "index-process-trigger";
    private static final String QUARTZ_PROCESSOR_GROUP = "d1-cn-index-processor";
    private static final String QUARTZ_PROCESSOR_JOB = "d1-index-processor-job";
    private Scheduler scheduler;

    public void start() {
        try {
            logger.warn("starting index task processor quartz scheduler [" + this + "] ...");
            Properties properties = new Properties();
            properties.load(this.getClass().getResourceAsStream("/org/dataone/configuration/quartz.properties"));
            StdSchedulerFactory schedulerFactory = new StdSchedulerFactory(properties);
            this.scheduler = schedulerFactory.getScheduler();
            JobDetail job = JobBuilder.newJob(IndexTaskProcessorJob.class).withIdentity(QUARTZ_PROCESSOR_JOB, QUARTZ_PROCESSOR_GROUP).build();
            SimpleTrigger trigger = TriggerBuilder.newTrigger().withIdentity(QUARTZ_PROCESSOR_TRIGGER, QUARTZ_PROCESSOR_GROUP).startNow().withSchedule(SimpleScheduleBuilder.repeatMinutelyForever(2)).build();
            this.scheduler.scheduleJob(job, trigger);
            this.scheduler.start();
        }
        catch (SchedulerException e2) {
            logger.error(e2.getMessage(), e2);
        }
        catch (FileNotFoundException e3) {
            logger.error(e3.getMessage(), e3);
        }
        catch (IOException e4) {
            logger.error(e4.getMessage(), e4);
        }
    }

    public void stop() {
        logger.warn("stopping index task processor quartz scheduler [" + this + "] ...");
        try {
            if (this.scheduler.isStarted()) {
                this.scheduler.standby();
                boolean success = this.scheduler.interrupt(JobKey.jobKey(QUARTZ_PROCESSOR_JOB, QUARTZ_PROCESSOR_GROUP));
                if (!success) {
                    logger.info("Scheuler.interrupt method can't succeed to interrupt the d1 index job and the static method IndexTaskProcessorJob.interruptCurrent() will be called.");
                    IndexTaskProcessorJob.interruptCurrent();
                    logger.info("The scheuler.interrupt method seems not interrupt the d1 index job and the static method IndexTaskProcessorJob.interruptCurrent() was called.");
                }
                while (!this.scheduler.getCurrentlyExecutingJobs().isEmpty()) {
                    logger.warn(String.format("%d jobs executing,  waiting for them to complete...", this.scheduler.getCurrentlyExecutingJobs().size()));
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ex) {
                        logger.warn("Sleep interrupted while waiting for executing jobs to finish. check again!");
                    }
                }
                this.scheduler.deleteJob(JobKey.jobKey(QUARTZ_PROCESSOR_JOB, QUARTZ_PROCESSOR_GROUP));
                logger.warn("Job scheduler [" + this + "] finished executing all jobs. The d1-index-processor shut down sucessfully.============================================");
            }
        }
        catch (Exception e2) {
            logger.error("There was an issue to shut down d1-index-processor " + e2.getMessage(), e2);
        }
    }
}

