/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.annotation;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.xpath.XPathExpressionException;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.dataone.cn.index.util.PerformanceLogger;
import org.dataone.cn.indexer.annotation.SparqlField;
import org.dataone.cn.indexer.annotation.TripleStoreService;
import org.dataone.cn.indexer.parser.IDocumentSubprocessor;
import org.dataone.cn.indexer.parser.ISolrDataField;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.cn.indexer.solrhttp.SolrElementField;
import org.dataone.configuration.Settings;

public class RemoteAnnotatorSubprocessor
implements IDocumentSubprocessor {
    private PerformanceLogger perfLog = PerformanceLogger.getInstance();
    private static Log log = LogFactory.getLog(RemoteAnnotatorSubprocessor.class);
    private List<ISolrDataField> fieldList = new ArrayList<ISolrDataField>();
    private HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();

    public List<ISolrDataField> getFieldList() {
        return this.fieldList;
    }

    public void setFieldList(List<ISolrDataField> fieldList) {
        this.fieldList = fieldList;
    }

    @Override
    public boolean canProcess(String formatId) {
        return true;
    }

    @Override
    public Map<String, SolrDoc> processDocument(String identifier, Map<String, SolrDoc> docs, InputStream is) throws Exception {
        for (Map.Entry<String, SolrDoc> entry : docs.entrySet()) {
            String pid = entry.getKey();
            SolrDoc solrDoc = entry.getValue();
            long lookUpAnnotationsStart = System.currentTimeMillis();
            SolrDoc annotations = this.lookUpAnnotations(pid);
            this.perfLog.log("RemoteAnnotatorSubprocessor.lookUpAnnotations()", System.currentTimeMillis() - lookUpAnnotationsStart);
            if (annotations == null) continue;
            for (SolrElementField annotation : annotations.getFieldList()) {
                solrDoc.addField(annotation);
            }
        }
        return docs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SolrDoc lookUpAnnotations(String pid) {
        String annotatorUrl = null;
        String consumerKey = null;
        try {
            annotatorUrl = Settings.getConfiguration().getString("annotator.store.url");
            consumerKey = Settings.getConfiguration().getString("annotator.consumerKey");
            if (annotatorUrl == null || annotatorUrl.length() == 0) {
                return null;
            }
            String urlParameters = "consumer=" + consumerKey;
            String url = annotatorUrl + "?" + urlParameters;
            CloseableHttpClient client = this.httpClientBuilder.build();
            HttpGet method = new HttpGet(url);
            method.addHeader("Accept", "application/json");
            HttpResponse response = client.execute(method);
            InputStream is = response.getEntity().getContent();
            String results = null;
            try {
                results = IOUtils.toString(is, "UTF-8");
            }
            finally {
                IOUtils.closeQuietly(is);
            }
            log.debug("RESULTS: " + results);
            JSONObject jo = (JSONObject)JSONValue.parse(results);
            JSONArray rows = (JSONArray)jo.get("rows");
            int count = rows.size();
            SolrDoc annotations = new SolrDoc();
            String tagKey = "sem_annotation";
            String commentKey = "sem_comment";
            for (int i = 0; i < count; ++i) {
                String value;
                Object commentObj;
                Object reject;
                JSONObject row = (JSONObject)rows.get(i);
                String pidValue = row.get("pid").toString();
                if (!pidValue.equals(pid)) continue;
                Object field = row.get("field");
                if (field != null) {
                    tagKey = field.toString();
                }
                if ((reject = row.get("reject")) != null && Boolean.parseBoolean(reject.toString())) {
                    if (!annotations.hasFieldWithValue(tagKey, "")) {
                        annotations.addField(new SolrElementField(tagKey, ""));
                    }
                    if (annotations.hasFieldWithValue(commentKey, "")) continue;
                    annotations.addField(new SolrElementField(commentKey, ""));
                    continue;
                }
                Object obj = row.get("tags");
                if (obj instanceof JSONArray) {
                    JSONArray tags = (JSONArray)obj;
                    for (Object tag : tags) {
                        String value2 = tag.toString();
                        if (annotations.hasFieldWithValue(tagKey, value2)) continue;
                        annotations.addField(new SolrElementField(tagKey, value2));
                    }
                } else {
                    String value3 = obj.toString();
                    if (!annotations.hasFieldWithValue(tagKey, value3)) {
                        annotations.addField(new SolrElementField(tagKey, value3));
                    }
                }
                if ((commentObj = row.get("text")) == null || (value = commentObj.toString()) == null || value.length() <= 0 || annotations.hasFieldWithValue(commentKey, value)) continue;
                annotations.addField(new SolrElementField(commentKey, value));
            }
            for (String tag : annotations.getAllFieldValues(tagKey)) {
                try {
                    Map<String, Set<String>> expandedConcepts = this.expandConcepts(tag);
                    for (Map.Entry<String, Set<String>> entry : expandedConcepts.entrySet()) {
                        for (String value3 : entry.getValue()) {
                            String name = entry.getKey();
                            if (annotations.hasFieldWithValue(name, value3)) continue;
                            annotations.addField(new SolrElementField(name, value3));
                        }
                    }
                }
                catch (Exception e2) {
                    log.error("Problem exapnding concept: " + tag, e2);
                }
            }
            return annotations;
        }
        catch (Exception e3) {
            log.error("Could not lookup annotation using: " + annotatorUrl, e3);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Set<String>> expandConcepts(String uri) throws Exception {
        HashMap<String, Set<String>> conceptFields = new HashMap<String, Set<String>>();
        if (uri == null || uri.length() < 1) {
            return conceptFields;
        }
        Dataset dataset = TripleStoreService.getInstance().getDataset();
        try {
            boolean loaded = dataset.containsNamedModel(uri);
            if (!loaded) {
                OntModel ontModel = ModelFactory.createOntologyModel();
                ontModel.read(uri);
                dataset.addNamedModel(uri, ontModel);
            }
            for (ISolrDataField field : this.fieldList) {
                String q = null;
                if (!(field instanceof SparqlField)) continue;
                q = ((SparqlField)field).getQuery();
                q = q.replaceAll("\\$CONCEPT_URI", uri);
                q = q.replaceAll("\\$GRAPH_NAME", uri);
                Query query2 = QueryFactory.create(q);
                QueryExecution qexec = QueryExecutionFactory.create(query2, dataset);
                ResultSet results = qexec.execSelect();
                String name = field.getName();
                TreeSet<String> values = new TreeSet<String>();
                while (results.hasNext()) {
                    QuerySolution solution = results.next();
                    log.debug(solution.toString());
                    if (!solution.contains(name)) continue;
                    String value = solution.get(field.getName()).toString();
                    values.add(value);
                }
                conceptFields.put(name, values);
            }
        }
        finally {
            try {
                TripleStoreService.getInstance().destoryDataset(dataset);
            }
            catch (Exception e2) {
                log.warn("A tdb directory can't be removed since " + e2.getMessage(), e2);
            }
        }
        return conceptFields;
    }

    @Override
    public SolrDoc mergeWithIndexedDocument(SolrDoc indexDocument) throws IOException, EncoderException, XPathExpressionException {
        return indexDocument;
    }
}

