/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser.utility;

import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.cn.indexer.parser.utility.FilterGroupProcessor;
import org.dataone.cn.indexer.parser.utility.FilterProcessor;
import org.dataone.cn.indexer.parser.utility.LeafElement;

public class FilterRootElement {
    private String name;
    private String xPath;
    private XPathExpression xPathExpression = null;
    private String delimiter = " ";
    private List<LeafElement> leafs = new ArrayList<LeafElement>();
    private List<FilterRootElement> subRoots = new ArrayList<FilterRootElement>();
    private List<FilterProcessor> filters = null;
    private FilterGroupProcessor filterGroup = null;
    private String idFilterMatch = null;
    private String catalogQuery = null;
    private String isPartOfMatch = null;
    private Log log = LogFactory.getLog(FilterRootElement.class);

    public String getRootValues(Object docOrNode) throws XPathExpressionException {
        Object idFilterValue = null;
        Object isPartOfFilterValue = null;
        Object filterValue = null;
        this.filters = this.getFilters();
        this.filterGroup = this.getFilterGroup();
        this.idFilterMatch = this.getIdFilterMatch();
        this.catalogQuery = this.getCatalogQuery();
        this.isPartOfMatch = this.getIsPartOfFilterMatch();
        String completeFilterValue = null;
        FilterGroupProcessor fgp = new FilterGroupProcessor();
        this.log.trace("getRootValues, xpath: " + this.getxPath());
        completeFilterValue = fgp.getFilterGroupValue(docOrNode, this.filters, this.filterGroup, this.idFilterMatch, this.isPartOfMatch, this.xPath);
        this.log.trace("completeFilterValue: " + completeFilterValue);
        if (completeFilterValue == null) {
            completeFilterValue = "(id:*)";
        }
        if (this.catalogQuery != null) {
            completeFilterValue = completeFilterValue != null ? "(" + completeFilterValue + ") AND " + this.catalogQuery : this.catalogQuery;
        }
        return completeFilterValue;
    }

    public void initXPathExpressions(XPath xPathObject) {
        try {
            if (this.xPathExpression == null) {
                this.xPathExpression = xPathObject.compile(this.xPath);
            }
            for (LeafElement leaf : this.leafs) {
                leaf.initXPathExpression(xPathObject);
            }
            for (FilterRootElement subRoot : this.subRoots) {
                subRoot.initXPathExpressions(xPathObject);
            }
        }
        catch (XPathExpressionException e2) {
            e2.printStackTrace();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getxPath() {
        return this.xPath;
    }

    public void setxPath(String xPath) {
        this.xPath = xPath;
    }

    public XPathExpression getxPathExpression() {
        return this.xPathExpression;
    }

    public void setxPathExpression(XPathExpression xPathExpression) {
        this.xPathExpression = xPathExpression;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getIdFilterMatch() {
        return this.idFilterMatch;
    }

    public void setIdFilterMatch(String idFilterMatch) {
        this.idFilterMatch = idFilterMatch;
    }

    public String getCatalogQuery() {
        return this.catalogQuery;
    }

    public void setCatalogQuery(String catalogQuery) {
        this.catalogQuery = catalogQuery;
    }

    public String getIsPartOfFilterMatch() {
        return this.isPartOfMatch;
    }

    public void setIsPartOfFilterMatch(String isPartOfMatch) {
        this.isPartOfMatch = isPartOfMatch;
    }

    public List<LeafElement> getLeafs() {
        return this.leafs;
    }

    public void setLeafs(List<LeafElement> leafs) {
        this.leafs = leafs;
    }

    public List<FilterRootElement> getSubRoots() {
        return this.subRoots;
    }

    public void setSubRoots(List<FilterRootElement> subRoots) {
        this.subRoots = subRoots;
    }

    public List<FilterProcessor> getFilters() {
        return this.filters;
    }

    public void setFilters(List<FilterProcessor> filters) {
        this.filters = filters;
    }

    public FilterGroupProcessor getFilterGroup() {
        return this.filterGroup;
    }

    public void setFilterGroup(FilterGroupProcessor filterGroup) {
        this.filterGroup = filterGroup;
    }
}

