/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.solrhttp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrServerException;
import org.dataone.cn.indexer.solrhttp.OutputStreamHttpEntity;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.cn.indexer.solrhttp.SolrElementAdd;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.UnsupportedType;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class HTTPService {
    private static final String CHAR_ENCODING = "UTF-8";
    private static final String XML_CONTENT_TYPE = "text/xml";
    static final String PARAM_START = "start";
    static final String PARAM_ROWS = "rows";
    static final String PARAM_INDENT = "indent";
    static final String VALUE_INDENT_ON = "on";
    static final String VALUE_INDENT_OFF = "off";
    static final String PARAM_QUERY = "q";
    static final String PARAM_RETURN = "fl";
    static final String VALUE_WILDCARD = "*";
    private static final String MAX_ROWS = "5000";
    private static Logger log = Logger.getLogger(HTTPService.class.getName());
    private HttpComponentsClientHttpRequestFactory httpRequestFactory;
    private String SOLR_SCHEMA_PATH;
    private String solrIndexUri;
    private List<String> validSolrFieldNames = new ArrayList<String>();

    public HTTPService(HttpComponentsClientHttpRequestFactory requestFactory) {
        this.httpRequestFactory = requestFactory;
    }

    public void sendUpdate(String uri, SolrElementAdd data, String encoding) throws IOException {
        this.sendUpdate(uri, data, encoding, XML_CONTENT_TYPE);
    }

    public void sendUpdate(String uri, SolrElementAdd data) throws IOException {
        this.sendUpdate(uri, data, CHAR_ENCODING, XML_CONTENT_TYPE);
    }

    public void sendUpdate(String uri, SolrElementAdd data, String encoding, String contentType) throws IOException {
        InputStream inputStreamResponse = null;
        HttpPost post = null;
        HttpResponse response = null;
        try {
            post = new HttpPost(uri);
            post.setHeader("Content-Type", contentType);
            post.setEntity(new OutputStreamHttpEntity(data, encoding));
            response = this.getHttpClient().execute(post);
            HttpEntity responseEntity = response.getEntity();
            inputStreamResponse = responseEntity.getContent();
            if (response.getStatusLine().getStatusCode() != 200) {
                this.writeError(null, data, inputStreamResponse, uri);
                post.abort();
                throw new IOException("unable to update solr, non 200 response code.");
            }
            post.abort();
        }
        catch (Exception ex) {
            try {
                this.writeError(ex, data, inputStreamResponse, uri);
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStreamResponse);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(inputStreamResponse);
    }

    private void sendPost(String uri, String data) throws IOException {
        this.sendPost(uri, data, CHAR_ENCODING, XML_CONTENT_TYPE);
    }

    private void sendPost(String uri, String data, String encoding, String contentType) throws IOException {
        InputStream inputStreamResponse = null;
        HttpPost post = null;
        HttpResponse response = null;
        try {
            post = new HttpPost(uri);
            post.setHeader("Content-Type", contentType);
            ByteArrayEntity entity = new ByteArrayEntity(data.getBytes());
            entity.setContentEncoding(encoding);
            post.setEntity(entity);
            response = this.getHttpClient().execute(post);
            HttpEntity responseEntity = response.getEntity();
            inputStreamResponse = responseEntity.getContent();
            if (response.getStatusLine().getStatusCode() != 200) {
                this.writeError(null, data, inputStreamResponse, uri);
            }
            post.abort();
        }
        catch (Exception ex) {
            this.writeError(ex, data, inputStreamResponse, uri);
        }
    }

    public void sendSolrDelete(String pid) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            IOUtils.write("<?xml version=\"1.1\" encoding=\"utf-8\"?>\n", (OutputStream)outputStream, CHAR_ENCODING);
            String escapedId = StringEscapeUtils.escapeXml(pid);
            IOUtils.write("<delete><id>" + escapedId + "</id></delete>", (OutputStream)outputStream, CHAR_ENCODING);
            this.sendPost(this.getSolrIndexUri(), ((Object)outputStream).toString());
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public void sendSolrDeletes(List<String> pids) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            IOUtils.write("<?xml version=\"1.1\" encoding=\"utf-8\"?>\n", (OutputStream)outputStream, CHAR_ENCODING);
            IOUtils.write("<update>", (OutputStream)outputStream, CHAR_ENCODING);
            for (String pid : pids) {
                String escapedId = StringEscapeUtils.escapeXml(pid);
                IOUtils.write("<delete><id>" + escapedId + "</id></delete>", (OutputStream)outputStream, CHAR_ENCODING);
            }
            IOUtils.write("</update>", (OutputStream)outputStream, CHAR_ENCODING);
            this.sendPost(this.getSolrIndexUri(), ((Object)outputStream).toString());
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static String escapeQueryChars(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~' || c == '*' || c == '?' || c == '|' || c == '&' || c == ';' || Character.isWhitespace(c)) {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private void writeError(Exception ex, SolrElementAdd data, InputStream inputStreamResonse, String uri) throws IOException {
        try {
            if (ex != null) {
                log.error("Unable to write to stream", ex);
            }
            log.error("URL: " + uri);
            log.error("Post: ");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            data.serialize(baos, CHAR_ENCODING);
            log.error(new String(baos.toByteArray(), CHAR_ENCODING));
            log.error("\n\n\nResponse: \n");
            ByteArrayOutputStream baosResponse = new ByteArrayOutputStream();
            IOUtils.copy(inputStreamResonse, (OutputStream)baosResponse);
            log.error(new String(baosResponse.toByteArray()));
            inputStreamResonse.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void writeError(Exception ex, String data, InputStream inputStreamResonse, String uri) throws IOException {
        try {
            if (ex != null) {
                log.error("Unable to write to stream", ex);
            }
            log.error("URL: " + uri);
            log.error("Post: ");
            log.error(data);
            log.error("\n\n\nResponse: \n");
            ByteArrayOutputStream baosResponse = new ByteArrayOutputStream();
            IOUtils.copy(inputStreamResonse, (OutputStream)baosResponse);
            log.error(new String(baosResponse.toByteArray()));
            inputStreamResonse.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public List<SolrDoc> getDocumentsById(String uir, List<String> ids) throws IOException, XPathExpressionException, EncoderException {
        List<SolrDoc> docs = this.getDocumentsByField(uir, ids, "seriesId", false);
        docs.addAll(this.getDocumentsByField(uir, ids, "id", false));
        return docs;
    }

    public SolrDoc getDocumentBySeriesId(String seriesId, String uir) throws MalformedURLException, UnsupportedType, NotFound, SolrServerException, ParserConfigurationException, IOException, SAXException, XPathExpressionException {
        StringBuilder query2 = new StringBuilder();
        query2.append("seriesId:" + HTTPService.escapeQueryChars(seriesId) + " AND -obsoletedBy:*");
        log.info("HTTPService.getDocumentBeySeriesId - the uir is " + uir);
        log.info("HTTPService.getDocumentBeySeriesId - the query is " + query2.toString());
        ArrayList<SolrDoc> list = new ArrayList<SolrDoc>();
        list.addAll(this.doRequest(uir, query2, MAX_ROWS));
        SolrDoc doc = null;
        if (list != null && !list.isEmpty()) {
            doc = (SolrDoc)list.get(0);
        }
        return doc;
    }

    public List<SolrDoc> getDocumentById(String uir, String id) throws IOException, XPathExpressionException, EncoderException {
        return this.getDocumentsByField(uir, Collections.singletonList(id), "id", false);
    }

    public List<SolrDoc> getDocumentsByResourceMap(String uir, String resourceMapId) throws IOException, XPathExpressionException, EncoderException {
        return this.getDocumentsByField(uir, Collections.singletonList(resourceMapId), "resourceMap", true);
    }

    public List<SolrDoc> getDocumentsByField(String uir, List<String> fieldValues, String queryField, boolean maxRows) throws IOException, XPathExpressionException, EncoderException {
        if (fieldValues == null || fieldValues.size() <= 0) {
            return null;
        }
        this.loadSolrSchemaFields();
        ArrayList<SolrDoc> docs = new ArrayList<SolrDoc>();
        int rows = 0;
        String rowString = "";
        StringBuilder sb = new StringBuilder();
        for (String id : fieldValues) {
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append(queryField + ":").append(HTTPService.escapeQueryChars(id));
            ++rows;
            if (sb.length() <= 5000) continue;
            rowString = maxRows ? MAX_ROWS : Integer.toString(rows);
            docs.addAll(this.doRequest(uir, sb, rowString));
            rows = 0;
            sb = new StringBuilder();
        }
        if (sb.length() > 0) {
            rowString = maxRows ? MAX_ROWS : Integer.toString(rows);
            docs.addAll(this.doRequest(uir, sb, rowString));
        }
        return docs;
    }

    public List<SolrDoc> getDocumentsByResourceMapFieldAndDocumentsField(String uir, String resourceMapId, String documentsId) throws IOException, XPathExpressionException, EncoderException {
        return this.getDocumentsByTwoFields(uir, "resourceMap", resourceMapId, "documents", documentsId);
    }

    public List<SolrDoc> getDocumentsByResourceMapFieldAndIsDocumentedByField(String uir, String resourceMapId, String isDocumentedById) throws IOException, XPathExpressionException, EncoderException {
        return this.getDocumentsByTwoFields(uir, "resourceMap", resourceMapId, "isDocumentedBy", isDocumentedById);
    }

    private List<SolrDoc> getDocumentsByTwoFields(String uir, String field1, String field1Value, String field2, String field2Value) throws IOException, XPathExpressionException, EncoderException {
        this.loadSolrSchemaFields();
        ArrayList<SolrDoc> docs = new ArrayList<SolrDoc>();
        StringBuilder sb = new StringBuilder();
        sb.append(field1 + ":").append(HTTPService.escapeQueryChars(field1Value));
        sb.append(" AND ");
        sb.append(field2 + ":").append(HTTPService.escapeQueryChars(field2Value));
        docs.addAll(this.doRequest(uir, sb, MAX_ROWS));
        return docs;
    }

    private List<SolrDoc> doRequest(String uir, StringBuilder sb, String rows) throws IOException, ClientProtocolException, XPathExpressionException {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair(PARAM_QUERY, sb.toString()));
        params.add(new BasicNameValuePair(PARAM_START, "0"));
        params.add(new BasicNameValuePair(PARAM_ROWS, rows));
        params.add(new BasicNameValuePair(PARAM_INDENT, VALUE_INDENT_ON));
        params.add(new BasicNameValuePair(PARAM_RETURN, VALUE_WILDCARD));
        String paramString = URLEncodedUtils.format(params, CHAR_ENCODING);
        String requestURI = uir + "?" + paramString;
        log.info("REQUEST URI= " + requestURI);
        HttpGet commandGet = new HttpGet(requestURI);
        HttpResponse response = this.getHttpClient().execute(commandGet);
        HttpEntity entity = response.getEntity();
        InputStream content = entity.getContent();
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(content);
        }
        catch (SAXException e2) {
            log.error(e2);
        }
        catch (ParserConfigurationException e3) {
            log.error(e3);
        }
        commandGet.abort();
        List<SolrDoc> docs = this.parseResults(document);
        return docs;
    }

    public SolrDoc retrieveDocumentFromSolrServer(String id, String solrQueryUri) throws XPathExpressionException, IOException, EncoderException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(id);
        List<SolrDoc> indexedDocuments = this.getDocumentsById(solrQueryUri, ids);
        if (indexedDocuments.size() > 0) {
            return indexedDocuments.get(0);
        }
        return null;
    }

    private List<SolrDoc> parseResults(Document document) throws XPathExpressionException {
        NodeList nodeList = (NodeList)XPathFactory.newInstance().newXPath().evaluate("/response/result/doc", document, XPathConstants.NODESET);
        ArrayList<SolrDoc> docList = new ArrayList<SolrDoc>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element docElement = (Element)nodeList.item(i);
            docList.add(this.parseDoc(docElement));
        }
        return docList;
    }

    private SolrDoc parseDoc(Element docElement) {
        SolrDoc doc = new SolrDoc();
        doc.loadFromElement(docElement, this.validSolrFieldNames);
        return doc;
    }

    public void setSolrSchemaPath(String path) {
        this.SOLR_SCHEMA_PATH = path;
    }

    private void loadSolrSchemaFields() {
        if (this.SOLR_SCHEMA_PATH != null && this.validSolrFieldNames.isEmpty()) {
            Document doc = this.loadSolrSchemaDocument();
            NodeList nList = doc.getElementsByTagName("copyField");
            ArrayList<String> copyDestinationFields = new ArrayList<String>();
            for (int i = 0; i < nList.getLength(); ++i) {
                Node node = nList.item(i);
                String destinationField = node.getAttributes().getNamedItem("dest").getNodeValue();
                copyDestinationFields.add(destinationField);
            }
            nList = doc.getElementsByTagName("field");
            ArrayList<String> fields = new ArrayList<String>();
            for (int i = 0; i < nList.getLength(); ++i) {
                Node node = nList.item(i);
                String fieldName = node.getAttributes().getNamedItem("name").getNodeValue();
                fields.add(fieldName);
            }
            fields.removeAll(copyDestinationFields);
            this.validSolrFieldNames = fields;
            fields.remove("_version_");
        }
    }

    private Document loadSolrSchemaDocument() {
        Document doc = null;
        File schemaFile = new File(this.SOLR_SCHEMA_PATH);
        if (schemaFile != null) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(schemaFile);
            }
            catch (FileNotFoundException e2) {
                log.error(e2.getMessage(), e2);
            }
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = null;
            try {
                dBuilder = dbFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e3) {
                log.error(e3.getMessage(), e3);
            }
            try {
                doc = dBuilder.parse(fis);
            }
            catch (SAXException e4) {
                log.error(e4.getMessage(), e4);
            }
            catch (IOException e5) {
                log.error(e5.getMessage(), e5);
            }
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e6) {
                log.error(e6.getMessage(), e6);
            }
        }
        return doc;
    }

    public void setSolrIndexUri(String uri) {
        this.solrIndexUri = uri;
    }

    public String getSolrIndexUri() {
        return this.solrIndexUri;
    }

    public HttpClient getHttpClient() {
        return this.httpRequestFactory.getHttpClient();
    }
}

