/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.log;

import java.util.Date;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.solr.client.solrj.beans.Field;
import org.dataone.cn.log.AuditEvent;

public class AuditLogEntry {
    private static final String seperatorChar = "|";
    private final FastDateFormat format = FastDateFormat.getInstance("MM/dd/yyyy:HH:mm:ss:SS");
    @Field
    private String id;
    @Field
    private String pid;
    @Field
    private String nodeId;
    @Field
    private AuditEvent event;
    @Field
    private Date dateLogged;
    @Field
    private String logText;

    public AuditLogEntry() {
    }

    public AuditLogEntry(String pid, String nodeId, AuditEvent event, Date dateLogged, String logText) {
        this.pid = pid;
        this.nodeId = nodeId;
        this.event = event;
        this.dateLogged = dateLogged;
        this.logText = logText;
        this.id = this.generateId();
    }

    public AuditLogEntry(String pid, String nodeId, AuditEvent event, String logText) {
        this(pid, nodeId, event, new Date(System.currentTimeMillis()), logText);
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public AuditEvent getEvent() {
        return this.event;
    }

    public void setEvent(AuditEvent event) {
        this.event = event;
    }

    public Date getDateLogged() {
        return this.dateLogged;
    }

    public void setDateLogged(Date dateLogged) {
        this.dateLogged = dateLogged;
    }

    public String getLogText() {
        return this.logText;
    }

    public void setLogText(String logText) {
        this.logText = logText;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    private String generateId() {
        StringBuffer id = new StringBuffer();
        if (this.pid != null) {
            id.append(this.pid + seperatorChar);
        }
        if (this.nodeId != null) {
            id.append(this.nodeId + seperatorChar);
        }
        if (this.event != null) {
            id.append((Object)((Object)this.event) + seperatorChar);
        }
        if (this.dateLogged != null) {
            id.append(this.dateLogged);
        }
        return id.toString();
    }

    public String toString() {
        return "AuditLogEntry {id: " + this.id + ", pid: " + this.pid + ", auditEvent: " + this.event.toString() + ", nodeId: " + this.nodeId + ", dateLogged: " + this.format.format(this.dateLogged) + ", log text: " + this.logText + "'}";
    }
}

