/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.foresite;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.dspace.foresite.OREParser;
import org.dspace.foresite.OREParserException;
import org.dspace.foresite.OREParserFactory;
import org.dspace.foresite.ORESerialiser;
import org.dspace.foresite.ORESerialiserException;
import org.dspace.foresite.ORESerialiserFactory;
import org.dspace.foresite.ResourceMap;
import org.dspace.foresite.ResourceMapDocument;

public class ORETransformer {
    public static ResourceMapDocument transformToDocument(String source, String target, InputStream is) throws OREParserException, ORESerialiserException {
        OREParser parser = OREParserFactory.getInstance(source);
        ResourceMap rem = parser.parse(is);
        ORESerialiser serialiser = ORESerialiserFactory.getInstance(target);
        ResourceMapDocument rmd = serialiser.serialise(rem);
        return rmd;
    }

    public static InputStream transformToStream(String source, String target, InputStream is) throws OREParserException, ORESerialiserException {
        ResourceMapDocument rmd = ORETransformer.transformToDocument(source, target, is);
        byte[] bytes = rmd.getSerialisation().getBytes();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        return bais;
    }

    public static void transformToStream(String source, String target, InputStream is, OutputStream os) throws OREParserException, ORESerialiserException {
        try {
            ResourceMapDocument rmd = ORETransformer.transformToDocument(source, target, is);
            byte[] bytes = rmd.getSerialisation().getBytes();
            for (int i = 0; i < bytes.length; ++i) {
                os.write(bytes[i]);
            }
        }
        catch (IOException e2) {
            throw new ORESerialiserException("Problem construcing output stream");
        }
    }
}

