/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.foresite.jena;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.net.URI;
import java.util.ArrayList;
import org.dspace.foresite.OREException;
import org.dspace.foresite.REMValidator;
import org.dspace.foresite.ResourceMap;
import org.dspace.foresite.jena.ORE;
import org.dspace.foresite.jena.OREX;
import org.dspace.foresite.jena.ResourceMapJena;

public class REMValidatorJena
extends REMValidator {
    public void prepForSerialisation(ResourceMap rem) throws OREException {
        super.prepForSerialisation(rem);
        Model model = ((ResourceMapJena)rem).getModel();
        URI uri = rem.getURI();
        model.setNsPrefix("ore", "http://www.openarchives.org/ore/terms/");
        model.setNsPrefix("foaf", "http://xmlns.com/foaf/0.1/");
        model.setNsPrefix("dcterms", "http://purl.org/dc/terms/");
        model.setNsPrefix("dc", "http://purl.org/dc/elements/1.1/");
        model.setNsPrefix("owl", "http://www.w3.org/2002/07/owl#");
        ArrayList<Statement> describes = new ArrayList<Statement>();
        SimpleSelector selector = new SimpleSelector(null, ORE.describes, (RDFNode)null);
        StmtIterator itr = model.listStatements(selector);
        while (itr.hasNext()) {
            Statement statement = itr.nextStatement();
            if (statement.getSubject().getURI().equals(uri.toString())) continue;
            describes.add(statement);
        }
        model.remove(describes);
        SimpleSelector sel = new SimpleSelector(null, OREX.isAuthoritativeFor, (RDFNode)null);
        StmtIterator sitr = model.listStatements(sel);
        model.remove(sitr);
    }
}

