/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.annotation;

import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.transaction.annotation.TransactionAnnotationParser;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;

public class SpringTransactionAnnotationParser
implements TransactionAnnotationParser,
Serializable {
    public TransactionAttribute parseTransactionAnnotation(AnnotatedElement ae) {
        Transactional ann = AnnotationUtils.getAnnotation(ae, Transactional.class);
        if (ann != null) {
            return this.parseTransactionAnnotation(ann);
        }
        return null;
    }

    public TransactionAttribute parseTransactionAnnotation(Transactional ann) {
        String[] nrbfc;
        Class<? extends Throwable>[] nrbf;
        String[] rbfc;
        Class<? extends Throwable>[] rbf;
        RuleBasedTransactionAttribute rbta = new RuleBasedTransactionAttribute();
        rbta.setPropagationBehavior(ann.propagation().value());
        rbta.setIsolationLevel(ann.isolation().value());
        rbta.setTimeout(ann.timeout());
        rbta.setReadOnly(ann.readOnly());
        rbta.setQualifier(ann.value());
        ArrayList<RollbackRuleAttribute> rollBackRules = new ArrayList<RollbackRuleAttribute>();
        Class<? extends Throwable>[] classArray = rbf = ann.rollbackFor();
        int n = rbf.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Throwable> rbRule = classArray[n2];
            RollbackRuleAttribute rule = new RollbackRuleAttribute(rbRule);
            rollBackRules.add(rule);
            ++n2;
        }
        String[] stringArray = rbfc = ann.rollbackForClassName();
        int n3 = rbfc.length;
        n = 0;
        while (n < n3) {
            String rbRule = stringArray[n];
            RollbackRuleAttribute rule = new RollbackRuleAttribute(rbRule);
            rollBackRules.add(rule);
            ++n;
        }
        Class<? extends Throwable>[] classArray2 = nrbf = ann.noRollbackFor();
        int n4 = nrbf.length;
        n3 = 0;
        while (n3 < n4) {
            Class<? extends Throwable> rbRule = classArray2[n3];
            NoRollbackRuleAttribute rule = new NoRollbackRuleAttribute(rbRule);
            rollBackRules.add(rule);
            ++n3;
        }
        String[] stringArray2 = nrbfc = ann.noRollbackForClassName();
        int n5 = nrbfc.length;
        n4 = 0;
        while (n4 < n5) {
            String rbRule = stringArray2[n4];
            NoRollbackRuleAttribute rule = new NoRollbackRuleAttribute(rbRule);
            rollBackRules.add(rule);
            ++n4;
        }
        rbta.getRollbackRules().addAll(rollBackRules);
        return rbta;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof SpringTransactionAnnotationParser;
    }

    public int hashCode() {
        return SpringTransactionAnnotationParser.class.hashCode();
    }
}

