/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.beans.PropertyEditorSupport;
import org.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.util.StringUtils;

public class TransactionAttributeEditor
extends PropertyEditorSupport {
    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.hasLength(text)) {
            String[] tokens2 = StringUtils.commaDelimitedListToStringArray(text);
            RuleBasedTransactionAttribute attr = new RuleBasedTransactionAttribute();
            int i = 0;
            while (i < tokens2.length) {
                String token = StringUtils.trimWhitespace(tokens2[i].trim());
                if (StringUtils.containsWhitespace(token)) {
                    throw new IllegalArgumentException("Transaction attribute token contains illegal whitespace: [" + token + "]");
                }
                if (token.startsWith("PROPAGATION_")) {
                    attr.setPropagationBehaviorName(token);
                } else if (token.startsWith("ISOLATION_")) {
                    attr.setIsolationLevelName(token);
                } else if (token.startsWith("timeout_")) {
                    String value = token.substring("timeout_".length());
                    attr.setTimeout(Integer.parseInt(value));
                } else if (token.equals("readOnly")) {
                    attr.setReadOnly(true);
                } else if (token.startsWith("+")) {
                    attr.getRollbackRules().add(new NoRollbackRuleAttribute(token.substring(1)));
                } else if (token.startsWith("-")) {
                    attr.getRollbackRules().add(new RollbackRuleAttribute(token.substring(1)));
                } else {
                    throw new IllegalArgumentException("Invalid transaction attribute token: [" + token + "]");
                }
                ++i;
            }
            this.setValue(attr);
        } else {
            this.setValue(null);
        }
    }
}

