/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jar;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.jar.AbstractJarMojo;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class JarSignVerifyMojo
extends AbstractMojo {
    private File workingDirectory;
    private File basedir;
    private String finalName;
    private File jarPath;
    private boolean checkCerts;
    private boolean verbose;
    private boolean errorWhenNotSigned = true;
    private boolean signed;

    File getJarFile() {
        if (this.jarPath != null) {
            return this.jarPath;
        }
        return AbstractJarMojo.getJarFile(this.basedir, this.finalName, null);
    }

    public void execute() throws MojoExecutionException {
        ArrayList<Object> arguments = new ArrayList<Object>();
        Commandline commandLine = new Commandline();
        commandLine.setExecutable(this.getJarsignerPath());
        arguments.add("-verify");
        this.addArgIf(arguments, this.verbose, "-verbose");
        this.addArgIf(arguments, this.checkCerts, "-certs");
        arguments.add(this.getJarFile());
        Iterator it = arguments.iterator();
        while (it.hasNext()) {
            commandLine.createArgument().setValue(it.next().toString());
        }
        commandLine.setWorkingDirectory(this.workingDirectory.getAbsolutePath());
        this.getLog().debug("Executing: " + commandLine);
        LineMatcherStreamConsumer outConsumer = new LineMatcherStreamConsumer("jar verified.");
        final StringBuffer errBuffer = new StringBuffer();
        StreamConsumer errConsumer = new StreamConsumer(){

            public void consumeLine(String line) {
                errBuffer.append(line);
                JarSignVerifyMojo.this.getLog().warn(line);
            }
        };
        try {
            int result = this.executeCommandLine(commandLine, null, outConsumer, errConsumer);
            if (result != 0) {
                throw new MojoExecutionException("Result of " + commandLine + " execution is: '" + result + "'.");
            }
            this.signed = outConsumer.matched;
            if (!this.signed && this.errorWhenNotSigned) {
                throw new MojoExecutionException("Verify failed: " + outConsumer.firstOutLine);
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("command execution failed", e);
        }
    }

    private String getJarsignerPath() {
        return JarSignVerifyMojo.getJDKCommandPath("jarsigner", this.getLog());
    }

    private static String getJDKCommandPath(String command, Log logger) {
        String path = JarSignVerifyMojo.getJDKCommandExe(command).getAbsolutePath();
        logger.debug(command + " executable=[" + path + "]");
        return path;
    }

    private static File getJDKCommandExe(String command) {
        String fullCommand = command + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
        File exe = SystemUtils.IS_OS_AIX ? new File(SystemUtils.getJavaHome() + "/../sh", fullCommand) : (SystemUtils.IS_OS_MAC_OSX ? new File(SystemUtils.getJavaHome() + "/bin", fullCommand) : new File(SystemUtils.getJavaHome() + "/../bin", fullCommand));
        return exe;
    }

    private void addArgIf(List arguments, boolean b, String value) {
        if (b) {
            arguments.add(value);
        }
    }

    private void addArgIfNotEmpty(List arguments, String key, String value) {
        this.addArgIfNotEmpty(arguments, key, value, false);
    }

    private void addArgIfNotEmpty(List arguments, String key, String value, boolean repeatKey) {
        if (!StringUtils.isEmpty(value)) {
            arguments.add(key);
            StringTokenizer token = new StringTokenizer(value, ",");
            while (token.hasMoreTokens()) {
                String current = token.nextToken().trim();
                if (StringUtils.isEmpty(current)) continue;
                arguments.add(current);
                if (!token.hasMoreTokens() || !repeatKey) continue;
                arguments.add(key);
            }
        }
    }

    protected int executeCommandLine(Commandline commandLine, InputStream inputStream, StreamConsumer systemOut, StreamConsumer systemErr) throws CommandLineException {
        return CommandLineUtils.executeCommandLine(commandLine, inputStream, systemOut, systemErr);
    }

    public void setWorkingDir(File workingDir) {
        this.workingDirectory = workingDir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public void setJarPath(File jarPath) {
        this.jarPath = jarPath;
    }

    public void setCheckCerts(boolean checkCerts) {
        this.checkCerts = checkCerts;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public void setErrorWhenNotSigned(boolean errorWhenNotSigned) {
        this.errorWhenNotSigned = errorWhenNotSigned;
    }

    class LineMatcherStreamConsumer
    implements StreamConsumer {
        private String toMatch;
        private boolean matched;
        private String firstOutLine;

        LineMatcherStreamConsumer(String toMatch) {
            this.toMatch = toMatch;
        }

        public void consumeLine(String line) {
            if (this.firstOutLine == null) {
                this.firstOutLine = line;
            }
            this.matched = this.matched || this.toMatch.equals(line);
            JarSignVerifyMojo.this.getLog().info(line);
        }
    }
}

