/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.hazelcast;

import org.apache.commons.lang.StringUtils;
import org.dataone.configuration.Settings;

public class HazelcastConfigLocationFactory {
    private static final String DEFAULT_STORAGE_CLUSTER_CONFIG = "/etc/dataone/storage/hazelcast.xml";
    private static final String DEFAULT_PROCESS_CLUSTER_CONFIG = "/etc/dataone/process/hazelcast.xml";
    private static final String DEFAULT_SESSION_CLUSTER_CONFIG = "/etc/dataone/portal/hazelcast.xml";
    private static final String STORAGE_CLUSTER_OVERRIDE_PROPERTY = "dataone.hazelcast.location.clientconfig";
    private static final String PROCESS_CLUSTER_OVERRIDE_PROPERTY = "dataone.hazelcast.location.processing.clientconfig";
    private static final String SESSION_CLUSTER_OVERRIDE_PROPERTY = "dataone.hazelcast.location.session.clientconfig";

    public static String getStorageConfigLocation() {
        return HazelcastConfigLocationFactory.getConfigLocation(DEFAULT_STORAGE_CLUSTER_CONFIG, STORAGE_CLUSTER_OVERRIDE_PROPERTY);
    }

    public static String getProcessingConfigLocation() {
        return HazelcastConfigLocationFactory.getConfigLocation(DEFAULT_PROCESS_CLUSTER_CONFIG, PROCESS_CLUSTER_OVERRIDE_PROPERTY);
    }

    public static String getSessionConfigLocation() {
        return HazelcastConfigLocationFactory.getConfigLocation(DEFAULT_SESSION_CLUSTER_CONFIG, SESSION_CLUSTER_OVERRIDE_PROPERTY);
    }

    private static String getConfigLocation(String defaultLocation, String overrideProperty) {
        String configLocation = null;
        if (overrideProperty != null) {
            configLocation = Settings.getConfiguration().getString(overrideProperty);
        }
        if (StringUtils.isBlank(configLocation)) {
            configLocation = defaultLocation;
        }
        return configLocation;
    }
}

