/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import org.springframework.data.jpa.repository.query.StringQuery;
import org.springframework.data.jpa.repository.support.JpaEntityMetadata;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;

class ExpressionBasedStringQuery
extends StringQuery {
    private static final String ENTITY_NAME = "entityName";

    public ExpressionBasedStringQuery(String query, JpaEntityMetadata<?> metadata) {
        super(ExpressionBasedStringQuery.renderQueryIfExpressionOrReturnQuery(query, metadata));
    }

    private static String renderQueryIfExpressionOrReturnQuery(String query, JpaEntityMetadata<?> metadata) {
        Assert.notNull(query, "query must not be null!");
        Assert.notNull(metadata, "metadata must not be null!");
        if (!ExpressionBasedStringQuery.containsExpression(query)) {
            return query;
        }
        StandardEvaluationContext evalContext = new StandardEvaluationContext();
        evalContext.setVariable(ENTITY_NAME, metadata.getEntityName());
        SpelExpressionParser parser = new SpelExpressionParser();
        Expression expr = parser.parseExpression(query, ParserContext.TEMPLATE_EXPRESSION);
        String result = expr.getValue((EvaluationContext)evalContext, String.class);
        return result == null ? query : String.valueOf(result);
    }

    private static boolean containsExpression(String query) {
        return query.contains("#{#entityName}");
    }
}

