/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.AttributeAccessorSupport;
import org.springframework.core.style.ToStringCreator;
import org.springframework.test.context.ContextCache;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.ContextLoader;
import org.springframework.test.context.ContextLoaderUtils;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.SmartContextLoader;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestContext
extends AttributeAccessorSupport {
    private static final long serialVersionUID = -5827157174866681233L;
    private static final Log logger = LogFactory.getLog(TestContext.class);
    private final ContextCache contextCache;
    private final MergedContextConfiguration mergedContextConfiguration;
    private final Class<?> testClass;
    private Object testInstance;
    private Method testMethod;
    private Throwable testException;

    TestContext(Class<?> testClass, ContextCache contextCache) {
        this(testClass, contextCache, null);
    }

    TestContext(Class<?> testClass, ContextCache contextCache, String defaultContextLoaderClassName) {
        MergedContextConfiguration mergedContextConfiguration;
        Assert.notNull(testClass, "Test class must not be null");
        Assert.notNull(contextCache, "ContextCache must not be null");
        ContextConfiguration contextConfiguration = testClass.getAnnotation(ContextConfiguration.class);
        if (contextConfiguration == null) {
            if (logger.isInfoEnabled()) {
                logger.info(String.format("@ContextConfiguration not found for class [%s]", testClass));
            }
            mergedContextConfiguration = new MergedContextConfiguration(testClass, null, null, null, null);
        } else {
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("Retrieved @ContextConfiguration [%s] for class [%s]", contextConfiguration, testClass));
            }
            mergedContextConfiguration = ContextLoaderUtils.buildMergedContextConfiguration(testClass, defaultContextLoaderClassName);
        }
        this.contextCache = contextCache;
        this.mergedContextConfiguration = mergedContextConfiguration;
        this.testClass = testClass;
    }

    private ApplicationContext loadApplicationContext() throws Exception {
        ApplicationContext applicationContext;
        ContextLoader contextLoader = this.mergedContextConfiguration.getContextLoader();
        Assert.notNull(contextLoader, "Can not load an ApplicationContext with a NULL 'contextLoader'. Consider annotating your test class with @ContextConfiguration.");
        if (contextLoader instanceof SmartContextLoader) {
            SmartContextLoader smartContextLoader = (SmartContextLoader)contextLoader;
            applicationContext = smartContextLoader.loadContext(this.mergedContextConfiguration);
        } else {
            String[] locations = this.mergedContextConfiguration.getLocations();
            Assert.notNull(locations, "Can not load an ApplicationContext with a NULL 'locations' array. Consider annotating your test class with @ContextConfiguration.");
            applicationContext = contextLoader.loadContext(locations);
        }
        return applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationContext getApplicationContext() {
        ContextCache contextCache = this.contextCache;
        synchronized (contextCache) {
            ApplicationContext context = this.contextCache.get(this.mergedContextConfiguration);
            if (context == null) {
                try {
                    context = this.loadApplicationContext();
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("Storing ApplicationContext for test class [%s] in cache under key [%s].", this.testClass, this.mergedContextConfiguration));
                    }
                    this.contextCache.put(this.mergedContextConfiguration, context);
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Failed to load ApplicationContext", ex);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug(String.format("Retrieved ApplicationContext for test class [%s] from cache with key [%s].", this.testClass, this.mergedContextConfiguration));
            }
            return context;
        }
    }

    public final Class<?> getTestClass() {
        return this.testClass;
    }

    public final Object getTestInstance() {
        return this.testInstance;
    }

    public final Method getTestMethod() {
        return this.testMethod;
    }

    public final Throwable getTestException() {
        return this.testException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markApplicationContextDirty() {
        ContextCache contextCache = this.contextCache;
        synchronized (contextCache) {
            this.contextCache.setDirty(this.mergedContextConfiguration);
        }
    }

    void updateState(Object testInstance, Method testMethod, Throwable testException) {
        this.testInstance = testInstance;
        this.testMethod = testMethod;
        this.testException = testException;
    }

    public String toString() {
        return new ToStringCreator(this).append("testClass", this.testClass).append("testInstance", this.testInstance).append("testMethod", this.testMethod).append("testException", this.testException).append("mergedContextConfiguration", this.mergedContextConfiguration).toString();
    }
}

