/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.core.DatasetDescription;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphMap;
import com.hp.hpl.jena.sparql.core.DatasetGraphReadOnly;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.graph.GraphOps;
import com.hp.hpl.jena.sparql.graph.GraphUnionRead;
import com.hp.hpl.jena.sparql.util.NodeUtils;
import java.util.Collection;
import java.util.Set;

public class DynamicDatasets {
    public static Dataset dynamicDataset(DatasetDescription description, Dataset ds, boolean defaultUnionGraph) {
        DatasetGraph dsg2;
        DatasetGraph dsg = ds.asDatasetGraph();
        if (dsg == (dsg2 = DynamicDatasets.dynamicDataset(description, dsg, defaultUnionGraph))) {
            return ds;
        }
        return DatasetFactory.create(dsg2);
    }

    public static DatasetGraph dynamicDataset(DatasetDescription description, DatasetGraph dsg, boolean defaultUnionGraph) {
        if (description == null) {
            return dsg;
        }
        Set<Node> defaultGraphs = NodeUtils.convertToNodes(description.getDefaultGraphURIs());
        Set<Node> namedGraphs = NodeUtils.convertToNodes(description.getNamedGraphURIs());
        return DynamicDatasets.dynamicDataset(defaultGraphs, namedGraphs, dsg, defaultUnionGraph);
    }

    public static DatasetGraph dynamicDataset(Collection<Node> defaultGraphs, Collection<Node> namedGraphs, DatasetGraph dsg, boolean defaultUnionGraph) {
        GraphUnionRead dft = new GraphUnionRead(dsg, defaultGraphs);
        DatasetGraph dsg2 = new DatasetGraphMap(dft);
        for (Node gn : namedGraphs) {
            Graph g = GraphOps.getGraph(dsg, gn);
            if (g == null) continue;
            dsg2.addGraph(gn, g);
        }
        if (dsg.getContext() != null) {
            dsg2.getContext().putAll(dsg.getContext());
        }
        if (defaultUnionGraph && defaultGraphs.size() == 0) {
            GraphUnionRead unionGraph = new GraphUnionRead(dsg, namedGraphs);
            dsg2.setDefaultGraph(unionGraph);
        }
        dsg2 = new DynamicDatasetGraph(dsg2);
        dsg2.getContext().set(ARQConstants.symDatasetDefaultGraphs, defaultGraphs);
        dsg2.getContext().set(ARQConstants.symDatasetNamedGraphs, namedGraphs);
        return dsg2;
    }

    public static class DynamicDatasetGraph
    extends DatasetGraphReadOnly {
        private Graph unionGraph = null;

        public DynamicDatasetGraph(DatasetGraph dsg) {
            super(dsg);
        }

        @Override
        public boolean containsGraph(Node graphNode) {
            if (Quad.isUnionGraph(graphNode)) {
                return true;
            }
            if (Quad.isDefaultGraphExplicit(graphNode)) {
                return true;
            }
            return super.containsGraph(graphNode);
        }

        @Override
        public Graph getGraph(Node graphNode) {
            if (Quad.isUnionGraph(graphNode)) {
                if (this.unionGraph == null) {
                    this.unionGraph = GraphOps.unionGraph(super.getWrapped());
                }
                return this.unionGraph;
            }
            if (Quad.isDefaultGraphExplicit(graphNode)) {
                return this.getDefaultGraph();
            }
            return super.getGraph(graphNode);
        }
    }
}

