/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.graph;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.graph.GraphOps;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.Collection;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorConcat;

public class GraphUnionRead
extends GraphBase {
    private final DatasetGraph dataset;
    private final Collection<Node> graphs;

    public GraphUnionRead(DatasetGraph dsg, Collection<Node> graphs) {
        this.dataset = dsg;
        this.graphs = graphs;
    }

    @Override
    protected PrefixMapping createPrefixMapping() {
        PrefixMappingImpl pmap = new PrefixMappingImpl();
        for (Node gn : this.graphs) {
            if (!gn.isURI()) continue;
            Graph g = this.dataset.getGraph(gn);
            PrefixMapping pmapNamedGraph = g.getPrefixMapping();
            pmap.setNsPrefixes(pmapNamedGraph);
        }
        return pmap;
    }

    @Override
    protected ExtendedIterator<Triple> graphBaseFind(Triple m) {
        IteratorConcat<Triple> iter = new IteratorConcat<Triple>();
        for (Node gn : this.graphs) {
            if (!GraphOps.containsGraph(this.dataset, gn)) continue;
            ExtendedIterator<Triple> eIter = GraphOps.getGraph(this.dataset, gn).find(m);
            iter.add(eIter);
        }
        return WrappedIterator.create(Iter.distinct(iter));
    }
}

