/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.ext;

import com.hp.hpl.jena.tdb.base.StorageException;
import com.hp.hpl.jena.tdb.base.block.Block;
import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.base.recordbuffer.RecordBufferPageBase;
import java.nio.ByteBuffer;
import org.apache.jena.atlas.lib.Alg;
import org.apache.jena.atlas.lib.NotImplemented;

public final class HashBucket
extends RecordBufferPageBase {
    public static final int TRIE = 4;
    public static final int BITLEN = 8;
    public static final int FIELD_LENGTH = 8;
    private int trie;
    private int bucketBitLen;

    public static HashBucket format(Block block, RecordFactory factory) {
        ByteBuffer byteBuffer = block.getByteBuffer();
        int count = byteBuffer.getInt(0);
        int hash = byteBuffer.getInt(4);
        int hashLen = byteBuffer.getInt(8);
        HashBucket bucket = new HashBucket(-1, hash, hashLen, block, factory, count);
        return bucket;
    }

    public static HashBucket createBlank(Block block, RecordFactory factory) {
        ByteBuffer byteBuffer = block.getByteBuffer();
        int count = 0;
        int hash = -1;
        int hashLen = -1;
        HashBucket bucket = new HashBucket(-1, hash, hashLen, block, factory, count);
        return bucket;
    }

    public HashBucket(int id, int hashValue, int bucketBitLen, Block block, RecordFactory factory, int count) {
        super(block, 8, factory, count);
        this.bucketBitLen = bucketBitLen;
        this.trie = hashValue;
    }

    public final int findIndex(Record key) {
        int i = this.getRecordBuffer().find(key);
        return i;
    }

    public final Record find(Record key) {
        int i = this.getRecordBuffer().find(key);
        if (i < 0) {
            return null;
        }
        return this.getRecordBuffer().get(i);
    }

    public final boolean put(Record record) {
        int i = this.findIndex(record);
        if (i >= 0) {
            Record recordOrig = this.getRecordBuffer().get(i);
            if (record.equals(recordOrig)) {
                return false;
            }
            this.getRecordBuffer().set(i, record);
            return true;
        }
        i = Alg.decodeIndex(i);
        if (this.getRecordBuffer().isFull()) {
            throw new StorageException("Bucket overflow");
        }
        this.getRecordBuffer().add(i, record);
        return true;
    }

    public void set(int x, Record record) {
        this.getRecordBuffer().set(x, record);
    }

    public final boolean removeByKey(Record key) {
        int i = this.findIndex(key);
        if (i < 0) {
            return false;
        }
        this.getRecordBuffer().remove(i);
        return true;
    }

    @Override
    public void _reset(Block block) {
        throw new NotImplemented("reset");
    }

    public final boolean isFull() {
        return this.getRecordBuffer().isFull();
    }

    public final boolean isEmpty() {
        return this.getRecordBuffer().isEmpty();
    }

    public final Record get(int idx) {
        if (idx >= this.getRecordBuffer().size()) {
            return null;
        }
        return this.getRecordBuffer().get(idx);
    }

    public final int getTrieValue() {
        return this.trie;
    }

    final void setTrieValue(int newHash) {
        this.trie = newHash;
    }

    public final int getTrieBitLen() {
        return this.bucketBitLen;
    }

    public void setTrieLength(int trieBitLen) {
        this.bucketBitLen = trieBitLen;
    }

    final void incTrieBitLen() {
        ++this.bucketBitLen;
    }

    @Override
    public String toString() {
        return String.format("HashBucket [id=%d, trie=0x%04X, bitlen=%d]: %s", this.getId(), this.getTrieValue(), this.getTrieBitLen(), this.getRecordBuffer().toString());
    }
}

