/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bag;

import java.util.Set;
import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.collection.SynchronizedCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedBag<E>
extends SynchronizedCollection<E>
implements Bag<E> {
    private static final long serialVersionUID = 8084674570753837109L;

    public static <E> SynchronizedBag<E> synchronizedBag(Bag<E> bag2) {
        return new SynchronizedBag<E>(bag2);
    }

    protected SynchronizedBag(Bag<E> bag2) {
        super(bag2);
    }

    protected SynchronizedBag(Bag<E> bag2, Object lock) {
        super(bag2, lock);
    }

    protected Bag<E> getBag() {
        return (Bag)this.decorated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E object, int count) {
        Object object2 = this.lock;
        synchronized (object2) {
            return this.getBag().add(object, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object, int count) {
        Object object2 = this.lock;
        synchronized (object2) {
            return this.getBag().remove(object, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<E> uniqueSet() {
        Object object = this.lock;
        synchronized (object) {
            Set<E> set = this.getBag().uniqueSet();
            return new SynchronizedBagSet(set, this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCount(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            return this.getBag().getCount(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SynchronizedBagSet
    extends SynchronizedCollection<E>
    implements Set<E> {
        private static final long serialVersionUID = 2990565892366827855L;

        SynchronizedBagSet(Set<E> set, Object lock) {
            super(set, lock);
        }
    }
}

