/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.CharSetUtils;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang.text.StrBuilder;

public class StringUtils {
    public static final String EMPTY = "";
    public static final int INDEX_NOT_FOUND = -1;
    private static final int PAD_LIMIT = 8192;

    public static boolean isEmpty(String str2) {
        return str2 == null || str2.length() == 0;
    }

    public static boolean isNotEmpty(String str2) {
        return !StringUtils.isEmpty(str2);
    }

    public static boolean isBlank(String str2) {
        int strLen;
        if (str2 == null || (strLen = str2.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str2) {
        return !StringUtils.isBlank(str2);
    }

    public static String clean(String str2) {
        return str2 == null ? EMPTY : str2.trim();
    }

    public static String trim(String str2) {
        return str2 == null ? null : str2.trim();
    }

    public static String trimToNull(String str2) {
        String ts = StringUtils.trim(str2);
        return StringUtils.isEmpty(ts) ? null : ts;
    }

    public static String trimToEmpty(String str2) {
        return str2 == null ? EMPTY : str2.trim();
    }

    public static String strip(String str2) {
        return StringUtils.strip(str2, null);
    }

    public static String stripToNull(String str2) {
        if (str2 == null) {
            return null;
        }
        return (str2 = StringUtils.strip(str2, null)).length() == 0 ? null : str2;
    }

    public static String stripToEmpty(String str2) {
        return str2 == null ? EMPTY : StringUtils.strip(str2, null);
    }

    public static String strip(String str2, String stripChars) {
        if (StringUtils.isEmpty(str2)) {
            return str2;
        }
        str2 = StringUtils.stripStart(str2, stripChars);
        return StringUtils.stripEnd(str2, stripChars);
    }

    public static String stripStart(String str2, String stripChars) {
        int start;
        int strLen;
        if (str2 == null || (strLen = str2.length()) == 0) {
            return str2;
        }
        if (stripChars == null) {
            for (start = 0; start != strLen && Character.isWhitespace(str2.charAt(start)); ++start) {
            }
        } else {
            if (stripChars.length() == 0) {
                return str2;
            }
            while (start != strLen && stripChars.indexOf(str2.charAt(start)) != -1) {
                ++start;
            }
        }
        return str2.substring(start);
    }

    public static String stripEnd(String str2, String stripChars) {
        int end;
        if (str2 == null || (end = str2.length()) == 0) {
            return str2;
        }
        if (stripChars == null) {
            while (end != 0 && Character.isWhitespace(str2.charAt(end - 1))) {
                --end;
            }
        } else {
            if (stripChars.length() == 0) {
                return str2;
            }
            while (end != 0 && stripChars.indexOf(str2.charAt(end - 1)) != -1) {
                --end;
            }
        }
        return str2.substring(0, end);
    }

    public static String[] stripAll(String[] strs) {
        return StringUtils.stripAll(strs, null);
    }

    public static String[] stripAll(String[] strs, String stripChars) {
        int strsLen;
        if (strs == null || (strsLen = strs.length) == 0) {
            return strs;
        }
        String[] newArr = new String[strsLen];
        for (int i = 0; i < strsLen; ++i) {
            newArr[i] = StringUtils.strip(strs[i], stripChars);
        }
        return newArr;
    }

    public static boolean equals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equalsIgnoreCase(str2);
    }

    public static int indexOf(String str2, char searchChar) {
        if (StringUtils.isEmpty(str2)) {
            return -1;
        }
        return str2.indexOf(searchChar);
    }

    public static int indexOf(String str2, char searchChar, int startPos) {
        if (StringUtils.isEmpty(str2)) {
            return -1;
        }
        return str2.indexOf(searchChar, startPos);
    }

    public static int indexOf(String str2, String searchStr) {
        if (str2 == null || searchStr == null) {
            return -1;
        }
        return str2.indexOf(searchStr);
    }

    public static int ordinalIndexOf(String str2, String searchStr, int ordinal) {
        return StringUtils.ordinalIndexOf(str2, searchStr, ordinal, false);
    }

    private static int ordinalIndexOf(String str2, String searchStr, int ordinal, boolean lastIndex) {
        if (str2 == null || searchStr == null || ordinal <= 0) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return lastIndex ? str2.length() : 0;
        }
        int found = 0;
        int index = lastIndex ? str2.length() : -1;
        do {
            if ((index = lastIndex ? str2.lastIndexOf(searchStr, index - 1) : str2.indexOf(searchStr, index + 1)) >= 0) continue;
            return index;
        } while (++found < ordinal);
        return index;
    }

    public static int indexOf(String str2, String searchStr, int startPos) {
        if (str2 == null || searchStr == null) {
            return -1;
        }
        if (searchStr.length() == 0 && startPos >= str2.length()) {
            return str2.length();
        }
        return str2.indexOf(searchStr, startPos);
    }

    public static int indexOfIgnoreCase(String str2, String searchStr) {
        return StringUtils.indexOfIgnoreCase(str2, searchStr, 0);
    }

    public static int indexOfIgnoreCase(String str2, String searchStr, int startPos) {
        int endLimit;
        if (str2 == null || searchStr == null) {
            return -1;
        }
        if (startPos < 0) {
            startPos = 0;
        }
        if (startPos > (endLimit = str2.length() - searchStr.length() + 1)) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return startPos;
        }
        for (int i = startPos; i < endLimit; ++i) {
            if (!str2.regionMatches(true, i, searchStr, 0, searchStr.length())) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(String str2, char searchChar) {
        if (StringUtils.isEmpty(str2)) {
            return -1;
        }
        return str2.lastIndexOf(searchChar);
    }

    public static int lastIndexOf(String str2, char searchChar, int startPos) {
        if (StringUtils.isEmpty(str2)) {
            return -1;
        }
        return str2.lastIndexOf(searchChar, startPos);
    }

    public static int lastIndexOf(String str2, String searchStr) {
        if (str2 == null || searchStr == null) {
            return -1;
        }
        return str2.lastIndexOf(searchStr);
    }

    public static int lastOrdinalIndexOf(String str2, String searchStr, int ordinal) {
        return StringUtils.ordinalIndexOf(str2, searchStr, ordinal, true);
    }

    public static int lastIndexOf(String str2, String searchStr, int startPos) {
        if (str2 == null || searchStr == null) {
            return -1;
        }
        return str2.lastIndexOf(searchStr, startPos);
    }

    public static int lastIndexOfIgnoreCase(String str2, String searchStr) {
        if (str2 == null || searchStr == null) {
            return -1;
        }
        return StringUtils.lastIndexOfIgnoreCase(str2, searchStr, str2.length());
    }

    public static int lastIndexOfIgnoreCase(String str2, String searchStr, int startPos) {
        if (str2 == null || searchStr == null) {
            return -1;
        }
        if (startPos > str2.length() - searchStr.length()) {
            startPos = str2.length() - searchStr.length();
        }
        if (startPos < 0) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return startPos;
        }
        for (int i = startPos; i >= 0; --i) {
            if (!str2.regionMatches(true, i, searchStr, 0, searchStr.length())) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(String str2, char searchChar) {
        if (StringUtils.isEmpty(str2)) {
            return false;
        }
        return str2.indexOf(searchChar) >= 0;
    }

    public static boolean contains(String str2, String searchStr) {
        if (str2 == null || searchStr == null) {
            return false;
        }
        return str2.indexOf(searchStr) >= 0;
    }

    public static boolean containsIgnoreCase(String str2, String searchStr) {
        if (str2 == null || searchStr == null) {
            return false;
        }
        int len = searchStr.length();
        int max2 = str2.length() - len;
        for (int i = 0; i <= max2; ++i) {
            if (!str2.regionMatches(true, i, searchStr, 0, len)) continue;
            return true;
        }
        return false;
    }

    public static int indexOfAny(String str2, char[] searchChars) {
        if (StringUtils.isEmpty(str2) || ArrayUtils.isEmpty(searchChars)) {
            return -1;
        }
        int csLen = str2.length();
        int csLast = csLen - 1;
        int searchLen = searchChars.length;
        int searchLast = searchLen - 1;
        for (int i = 0; i < csLen; ++i) {
            char ch = str2.charAt(i);
            for (int j = 0; j < searchLen; ++j) {
                if (searchChars[j] != ch) continue;
                if (i < csLast && j < searchLast && CharUtils.isHighSurrogate(ch)) {
                    if (searchChars[j + 1] != str2.charAt(i + 1)) continue;
                    return i;
                }
                return i;
            }
        }
        return -1;
    }

    public static int indexOfAny(String str2, String searchChars) {
        if (StringUtils.isEmpty(str2) || StringUtils.isEmpty(searchChars)) {
            return -1;
        }
        return StringUtils.indexOfAny(str2, searchChars.toCharArray());
    }

    public static boolean containsAny(String str2, char[] searchChars) {
        if (StringUtils.isEmpty(str2) || ArrayUtils.isEmpty(searchChars)) {
            return false;
        }
        int csLength = str2.length();
        int searchLength = searchChars.length;
        int csLast = csLength - 1;
        int searchLast = searchLength - 1;
        for (int i = 0; i < csLength; ++i) {
            char ch = str2.charAt(i);
            for (int j = 0; j < searchLength; ++j) {
                if (searchChars[j] != ch) continue;
                if (CharUtils.isHighSurrogate(ch)) {
                    if (j == searchLast) {
                        return true;
                    }
                    if (i >= csLast || searchChars[j + 1] != str2.charAt(i + 1)) continue;
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(String str2, String searchChars) {
        if (searchChars == null) {
            return false;
        }
        return StringUtils.containsAny(str2, searchChars.toCharArray());
    }

    public static int indexOfAnyBut(String str2, char[] searchChars) {
        if (StringUtils.isEmpty(str2) || ArrayUtils.isEmpty(searchChars)) {
            return -1;
        }
        int csLen = str2.length();
        int csLast = csLen - 1;
        int searchLen = searchChars.length;
        int searchLast = searchLen - 1;
        block0: for (int i = 0; i < csLen; ++i) {
            char ch = str2.charAt(i);
            for (int j = 0; j < searchLen; ++j) {
                if (searchChars[j] == ch && (i >= csLast || j >= searchLast || !CharUtils.isHighSurrogate(ch) || searchChars[j + 1] == str2.charAt(i + 1))) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int indexOfAnyBut(String str2, String searchChars) {
        if (StringUtils.isEmpty(str2) || StringUtils.isEmpty(searchChars)) {
            return -1;
        }
        int strLen = str2.length();
        for (int i = 0; i < strLen; ++i) {
            boolean chFound;
            char ch = str2.charAt(i);
            boolean bl = chFound = searchChars.indexOf(ch) >= 0;
            if (i + 1 < strLen && CharUtils.isHighSurrogate(ch)) {
                char ch2 = str2.charAt(i + 1);
                if (!chFound || searchChars.indexOf(ch2) >= 0) continue;
                return i;
            }
            if (chFound) continue;
            return i;
        }
        return -1;
    }

    public static boolean containsOnly(String str2, char[] valid) {
        if (valid == null || str2 == null) {
            return false;
        }
        if (str2.length() == 0) {
            return true;
        }
        if (valid.length == 0) {
            return false;
        }
        return StringUtils.indexOfAnyBut(str2, valid) == -1;
    }

    public static boolean containsOnly(String str2, String validChars) {
        if (str2 == null || validChars == null) {
            return false;
        }
        return StringUtils.containsOnly(str2, validChars.toCharArray());
    }

    public static boolean containsNone(String str2, char[] searchChars) {
        if (str2 == null || searchChars == null) {
            return true;
        }
        int csLen = str2.length();
        int csLast = csLen - 1;
        int searchLen = searchChars.length;
        int searchLast = searchLen - 1;
        for (int i = 0; i < csLen; ++i) {
            char ch = str2.charAt(i);
            for (int j = 0; j < searchLen; ++j) {
                if (searchChars[j] != ch) continue;
                if (CharUtils.isHighSurrogate(ch)) {
                    if (j == searchLast) {
                        return false;
                    }
                    if (i >= csLast || searchChars[j + 1] != str2.charAt(i + 1)) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    public static boolean containsNone(String str2, String invalidChars) {
        if (str2 == null || invalidChars == null) {
            return true;
        }
        return StringUtils.containsNone(str2, invalidChars.toCharArray());
    }

    public static int indexOfAny(String str2, String[] searchStrs) {
        if (str2 == null || searchStrs == null) {
            return -1;
        }
        int sz = searchStrs.length;
        int ret = Integer.MAX_VALUE;
        int tmp = 0;
        for (int i = 0; i < sz; ++i) {
            String search = searchStrs[i];
            if (search == null || (tmp = str2.indexOf(search)) == -1 || tmp >= ret) continue;
            ret = tmp;
        }
        return ret == Integer.MAX_VALUE ? -1 : ret;
    }

    public static int lastIndexOfAny(String str2, String[] searchStrs) {
        if (str2 == null || searchStrs == null) {
            return -1;
        }
        int sz = searchStrs.length;
        int ret = -1;
        int tmp = 0;
        for (int i = 0; i < sz; ++i) {
            String search = searchStrs[i];
            if (search == null || (tmp = str2.lastIndexOf(search)) <= ret) continue;
            ret = tmp;
        }
        return ret;
    }

    public static String substring(String str2, int start) {
        if (str2 == null) {
            return null;
        }
        if (start < 0) {
            start = str2.length() + start;
        }
        if (start < 0) {
            start = 0;
        }
        if (start > str2.length()) {
            return EMPTY;
        }
        return str2.substring(start);
    }

    public static String substring(String str2, int start, int end) {
        if (str2 == null) {
            return null;
        }
        if (end < 0) {
            end = str2.length() + end;
        }
        if (start < 0) {
            start = str2.length() + start;
        }
        if (end > str2.length()) {
            end = str2.length();
        }
        if (start > end) {
            return EMPTY;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        return str2.substring(start, end);
    }

    public static String left(String str2, int len) {
        if (str2 == null) {
            return null;
        }
        if (len < 0) {
            return EMPTY;
        }
        if (str2.length() <= len) {
            return str2;
        }
        return str2.substring(0, len);
    }

    public static String right(String str2, int len) {
        if (str2 == null) {
            return null;
        }
        if (len < 0) {
            return EMPTY;
        }
        if (str2.length() <= len) {
            return str2;
        }
        return str2.substring(str2.length() - len);
    }

    public static String mid(String str2, int pos, int len) {
        if (str2 == null) {
            return null;
        }
        if (len < 0 || pos > str2.length()) {
            return EMPTY;
        }
        if (pos < 0) {
            pos = 0;
        }
        if (str2.length() <= pos + len) {
            return str2.substring(pos);
        }
        return str2.substring(pos, pos + len);
    }

    public static String substringBefore(String str2, String separator) {
        if (StringUtils.isEmpty(str2) || separator == null) {
            return str2;
        }
        if (separator.length() == 0) {
            return EMPTY;
        }
        int pos = str2.indexOf(separator);
        if (pos == -1) {
            return str2;
        }
        return str2.substring(0, pos);
    }

    public static String substringAfter(String str2, String separator) {
        if (StringUtils.isEmpty(str2)) {
            return str2;
        }
        if (separator == null) {
            return EMPTY;
        }
        int pos = str2.indexOf(separator);
        if (pos == -1) {
            return EMPTY;
        }
        return str2.substring(pos + separator.length());
    }

    public static String substringBeforeLast(String str2, String separator) {
        if (StringUtils.isEmpty(str2) || StringUtils.isEmpty(separator)) {
            return str2;
        }
        int pos = str2.lastIndexOf(separator);
        if (pos == -1) {
            return str2;
        }
        return str2.substring(0, pos);
    }

    public static String substringAfterLast(String str2, String separator) {
        if (StringUtils.isEmpty(str2)) {
            return str2;
        }
        if (StringUtils.isEmpty(separator)) {
            return EMPTY;
        }
        int pos = str2.lastIndexOf(separator);
        if (pos == -1 || pos == str2.length() - separator.length()) {
            return EMPTY;
        }
        return str2.substring(pos + separator.length());
    }

    public static String substringBetween(String str2, String tag) {
        return StringUtils.substringBetween(str2, tag, tag);
    }

    public static String substringBetween(String str2, String open, String close) {
        int end;
        if (str2 == null || open == null || close == null) {
            return null;
        }
        int start = str2.indexOf(open);
        if (start != -1 && (end = str2.indexOf(close, start + open.length())) != -1) {
            return str2.substring(start + open.length(), end);
        }
        return null;
    }

    public static String[] substringsBetween(String str2, String open, String close) {
        int end;
        int start;
        if (str2 == null || StringUtils.isEmpty(open) || StringUtils.isEmpty(close)) {
            return null;
        }
        int strLen = str2.length();
        if (strLen == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        int closeLen = close.length();
        int openLen = open.length();
        ArrayList<String> list = new ArrayList<String>();
        int pos = 0;
        while (pos < strLen - closeLen && (start = str2.indexOf(open, pos)) >= 0 && (end = str2.indexOf(close, start += openLen)) >= 0) {
            list.add(str2.substring(start, end));
            pos = end + closeLen;
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public static String getNestedString(String str2, String tag) {
        return StringUtils.substringBetween(str2, tag, tag);
    }

    public static String getNestedString(String str2, String open, String close) {
        return StringUtils.substringBetween(str2, open, close);
    }

    public static String[] split(String str2) {
        return StringUtils.split(str2, null, -1);
    }

    public static String[] split(String str2, char separatorChar) {
        return StringUtils.splitWorker(str2, separatorChar, false);
    }

    public static String[] split(String str2, String separatorChars) {
        return StringUtils.splitWorker(str2, separatorChars, -1, false);
    }

    public static String[] split(String str2, String separatorChars, int max2) {
        return StringUtils.splitWorker(str2, separatorChars, max2, false);
    }

    public static String[] splitByWholeSeparator(String str2, String separator) {
        return StringUtils.splitByWholeSeparatorWorker(str2, separator, -1, false);
    }

    public static String[] splitByWholeSeparator(String str2, String separator, int max2) {
        return StringUtils.splitByWholeSeparatorWorker(str2, separator, max2, false);
    }

    public static String[] splitByWholeSeparatorPreserveAllTokens(String str2, String separator) {
        return StringUtils.splitByWholeSeparatorWorker(str2, separator, -1, true);
    }

    public static String[] splitByWholeSeparatorPreserveAllTokens(String str2, String separator, int max2) {
        return StringUtils.splitByWholeSeparatorWorker(str2, separator, max2, true);
    }

    private static String[] splitByWholeSeparatorWorker(String str2, String separator, int max2, boolean preserveAllTokens) {
        if (str2 == null) {
            return null;
        }
        int len = str2.length();
        if (len == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        if (separator == null || EMPTY.equals(separator)) {
            return StringUtils.splitWorker(str2, null, max2, preserveAllTokens);
        }
        int separatorLength = separator.length();
        ArrayList<String> substrings = new ArrayList<String>();
        int numberOfSubstrings = 0;
        int beg = 0;
        int end = 0;
        while (end < len) {
            end = str2.indexOf(separator, beg);
            if (end > -1) {
                if (end > beg) {
                    if (++numberOfSubstrings == max2) {
                        end = len;
                        substrings.add(str2.substring(beg));
                        continue;
                    }
                    substrings.add(str2.substring(beg, end));
                    beg = end + separatorLength;
                    continue;
                }
                if (preserveAllTokens) {
                    if (++numberOfSubstrings == max2) {
                        end = len;
                        substrings.add(str2.substring(beg));
                    } else {
                        substrings.add(EMPTY);
                    }
                }
                beg = end + separatorLength;
                continue;
            }
            substrings.add(str2.substring(beg));
            end = len;
        }
        return substrings.toArray(new String[substrings.size()]);
    }

    public static String[] splitPreserveAllTokens(String str2) {
        return StringUtils.splitWorker(str2, null, -1, true);
    }

    public static String[] splitPreserveAllTokens(String str2, char separatorChar) {
        return StringUtils.splitWorker(str2, separatorChar, true);
    }

    private static String[] splitWorker(String str2, char separatorChar, boolean preserveAllTokens) {
        if (str2 == null) {
            return null;
        }
        int len = str2.length();
        if (len == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match2 = false;
        boolean lastMatch = false;
        while (i < len) {
            if (str2.charAt(i) == separatorChar) {
                if (match2 || preserveAllTokens) {
                    list.add(str2.substring(start, i));
                    match2 = false;
                    lastMatch = true;
                }
                start = ++i;
                continue;
            }
            lastMatch = false;
            match2 = true;
            ++i;
        }
        if (match2 || preserveAllTokens && lastMatch) {
            list.add(str2.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] splitPreserveAllTokens(String str2, String separatorChars) {
        return StringUtils.splitWorker(str2, separatorChars, -1, true);
    }

    public static String[] splitPreserveAllTokens(String str2, String separatorChars, int max2) {
        return StringUtils.splitWorker(str2, separatorChars, max2, true);
    }

    private static String[] splitWorker(String str2, String separatorChars, int max2, boolean preserveAllTokens) {
        if (str2 == null) {
            return null;
        }
        int len = str2.length();
        if (len == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int sizePlus1 = 1;
        int i = 0;
        int start = 0;
        boolean match2 = false;
        boolean lastMatch = false;
        if (separatorChars == null) {
            while (i < len) {
                if (Character.isWhitespace(str2.charAt(i))) {
                    if (match2 || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max2) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str2.substring(start, i));
                        match2 = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match2 = true;
                ++i;
            }
        } else if (separatorChars.length() == 1) {
            char sep = separatorChars.charAt(0);
            while (i < len) {
                if (str2.charAt(i) == sep) {
                    if (match2 || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max2) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str2.substring(start, i));
                        match2 = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match2 = true;
                ++i;
            }
        } else {
            while (i < len) {
                if (separatorChars.indexOf(str2.charAt(i)) >= 0) {
                    if (match2 || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max2) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str2.substring(start, i));
                        match2 = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match2 = true;
                ++i;
            }
        }
        if (match2 || preserveAllTokens && lastMatch) {
            list.add(str2.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] splitByCharacterType(String str2) {
        return StringUtils.splitByCharacterType(str2, false);
    }

    public static String[] splitByCharacterTypeCamelCase(String str2) {
        return StringUtils.splitByCharacterType(str2, true);
    }

    private static String[] splitByCharacterType(String str2, boolean camelCase) {
        if (str2 == null) {
            return null;
        }
        if (str2.length() == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        char[] c = str2.toCharArray();
        ArrayList<String> list = new ArrayList<String>();
        int tokenStart = 0;
        int currentType = Character.getType(c[tokenStart]);
        for (int pos = tokenStart + 1; pos < c.length; ++pos) {
            int type = Character.getType(c[pos]);
            if (type == currentType) continue;
            if (camelCase && type == 2 && currentType == 1) {
                int newTokenStart = pos - 1;
                if (newTokenStart != tokenStart) {
                    list.add(new String(c, tokenStart, newTokenStart - tokenStart));
                    tokenStart = newTokenStart;
                }
            } else {
                list.add(new String(c, tokenStart, pos - tokenStart));
                tokenStart = pos;
            }
            currentType = type;
        }
        list.add(new String(c, tokenStart, c.length - tokenStart));
        return list.toArray(new String[list.size()]);
    }

    public static String concatenate(Object[] array) {
        return StringUtils.join(array, null);
    }

    public static String join(Object[] array) {
        return StringUtils.join(array, null);
    }

    public static String join(Object[] array, char separator) {
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, separator, 0, array.length);
    }

    public static String join(Object[] array, char separator, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        int bufSize = endIndex - startIndex;
        if (bufSize <= 0) {
            return EMPTY;
        }
        StrBuilder buf = new StrBuilder(bufSize *= (array[startIndex] == null ? 16 : array[startIndex].toString().length()) + 1);
        for (int i = startIndex; i < endIndex; ++i) {
            if (i > startIndex) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static String join(Object[] array, String separator) {
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, separator, 0, array.length);
    }

    public static String join(Object[] array, String separator, int startIndex, int endIndex) {
        int bufSize;
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = EMPTY;
        }
        if ((bufSize = endIndex - startIndex) <= 0) {
            return EMPTY;
        }
        StrBuilder buf = new StrBuilder(bufSize *= (array[startIndex] == null ? 16 : array[startIndex].toString().length()) + separator.length());
        for (int i = startIndex; i < endIndex; ++i) {
            if (i > startIndex) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static String join(Iterator iterator, char separator) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            return ObjectUtils.toString(first);
        }
        StrBuilder buf = new StrBuilder(256);
        if (first != null) {
            buf.append(first);
        }
        while (iterator.hasNext()) {
            buf.append(separator);
            Object obj = iterator.next();
            if (obj == null) continue;
            buf.append(obj);
        }
        return buf.toString();
    }

    public static String join(Iterator iterator, String separator) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            return ObjectUtils.toString(first);
        }
        StrBuilder buf = new StrBuilder(256);
        if (first != null) {
            buf.append(first);
        }
        while (iterator.hasNext()) {
            Object obj;
            if (separator != null) {
                buf.append(separator);
            }
            if ((obj = iterator.next()) == null) continue;
            buf.append(obj);
        }
        return buf.toString();
    }

    public static String join(Collection collection, char separator) {
        if (collection == null) {
            return null;
        }
        return StringUtils.join(collection.iterator(), separator);
    }

    public static String join(Collection collection, String separator) {
        if (collection == null) {
            return null;
        }
        return StringUtils.join(collection.iterator(), separator);
    }

    public static String deleteSpaces(String str2) {
        if (str2 == null) {
            return null;
        }
        return CharSetUtils.delete(str2, " \t\r\n\b");
    }

    public static String deleteWhitespace(String str2) {
        if (StringUtils.isEmpty(str2)) {
            return str2;
        }
        int sz = str2.length();
        char[] chs = new char[sz];
        int count = 0;
        for (int i = 0; i < sz; ++i) {
            if (Character.isWhitespace(str2.charAt(i))) continue;
            chs[count++] = str2.charAt(i);
        }
        if (count == sz) {
            return str2;
        }
        return new String(chs, 0, count);
    }

    public static String removeStart(String str2, String remove) {
        if (StringUtils.isEmpty(str2) || StringUtils.isEmpty(remove)) {
            return str2;
        }
        if (str2.startsWith(remove)) {
            return str2.substring(remove.length());
        }
        return str2;
    }

    public static String removeStartIgnoreCase(String str2, String remove) {
        if (StringUtils.isEmpty(str2) || StringUtils.isEmpty(remove)) {
            return str2;
        }
        if (StringUtils.startsWithIgnoreCase(str2, remove)) {
            return str2.substring(remove.length());
        }
        return str2;
    }

    public static String removeEnd(String str2, String remove) {
        if (StringUtils.isEmpty(str2) || StringUtils.isEmpty(remove)) {
            return str2;
        }
        if (str2.endsWith(remove)) {
            return str2.substring(0, str2.length() - remove.length());
        }
        return str2;
    }

    public static String removeEndIgnoreCase(String str2, String remove) {
        if (StringUtils.isEmpty(str2) || StringUtils.isEmpty(remove)) {
            return str2;
        }
        if (StringUtils.endsWithIgnoreCase(str2, remove)) {
            return str2.substring(0, str2.length() - remove.length());
        }
        return str2;
    }

    public static String remove(String str2, String remove) {
        if (StringUtils.isEmpty(str2) || StringUtils.isEmpty(remove)) {
            return str2;
        }
        return StringUtils.replace(str2, remove, EMPTY, -1);
    }

    public static String remove(String str2, char remove) {
        if (StringUtils.isEmpty(str2) || str2.indexOf(remove) == -1) {
            return str2;
        }
        char[] chars = str2.toCharArray();
        int pos = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == remove) continue;
            chars[pos++] = chars[i];
        }
        return new String(chars, 0, pos);
    }

    public static String replaceOnce(String text, String searchString, String replacement) {
        return StringUtils.replace(text, searchString, replacement, 1);
    }

    public static String replace(String text, String searchString, String replacement) {
        return StringUtils.replace(text, searchString, replacement, -1);
    }

    public static String replace(String text, String searchString, String replacement, int max2) {
        if (StringUtils.isEmpty(text) || StringUtils.isEmpty(searchString) || replacement == null || max2 == 0) {
            return text;
        }
        int start = 0;
        int end = text.indexOf(searchString, start);
        if (end == -1) {
            return text;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        int n = increase = increase < 0 ? 0 : increase;
        StrBuilder buf = new StrBuilder(text.length() + (increase *= max2 < 0 ? 16 : (max2 > 64 ? 64 : max2)));
        while (end != -1) {
            buf.append(text.substring(start, end)).append(replacement);
            start = end + replLength;
            if (--max2 == 0) break;
            end = text.indexOf(searchString, start);
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static String replaceEach(String text, String[] searchList, String[] replacementList) {
        return StringUtils.replaceEach(text, searchList, replacementList, false, 0);
    }

    public static String replaceEachRepeatedly(String text, String[] searchList, String[] replacementList) {
        int timeToLive = searchList == null ? 0 : searchList.length;
        return StringUtils.replaceEach(text, searchList, replacementList, true, timeToLive);
    }

    private static String replaceEach(String text, String[] searchList, String[] replacementList, boolean repeat, int timeToLive) {
        if (text == null || text.length() == 0 || searchList == null || searchList.length == 0 || replacementList == null || replacementList.length == 0) {
            return text;
        }
        if (timeToLive < 0) {
            throw new IllegalStateException("TimeToLive of " + timeToLive + " is less than 0: " + text);
        }
        int searchLength = searchList.length;
        int replacementLength = replacementList.length;
        if (searchLength != replacementLength) {
            throw new IllegalArgumentException("Search and Replace array lengths don't match: " + searchLength + " vs " + replacementLength);
        }
        boolean[] noMoreMatchesForReplIndex = new boolean[searchLength];
        int textIndex = -1;
        int replaceIndex = -1;
        int tempIndex = -1;
        for (int i = 0; i < searchLength; ++i) {
            if (noMoreMatchesForReplIndex[i] || searchList[i] == null || searchList[i].length() == 0 || replacementList[i] == null) continue;
            tempIndex = text.indexOf(searchList[i]);
            if (tempIndex == -1) {
                noMoreMatchesForReplIndex[i] = true;
                continue;
            }
            if (textIndex != -1 && tempIndex >= textIndex) continue;
            textIndex = tempIndex;
            replaceIndex = i;
        }
        if (textIndex == -1) {
            return text;
        }
        int start = 0;
        int increase = 0;
        for (int i = 0; i < searchList.length; ++i) {
            int greater;
            if (searchList[i] == null || replacementList[i] == null || (greater = replacementList[i].length() - searchList[i].length()) <= 0) continue;
            increase += 3 * greater;
        }
        increase = Math.min(increase, text.length() / 5);
        StrBuilder buf = new StrBuilder(text.length() + increase);
        while (textIndex != -1) {
            int i;
            for (i = start; i < textIndex; ++i) {
                buf.append(text.charAt(i));
            }
            buf.append(replacementList[replaceIndex]);
            start = textIndex + searchList[replaceIndex].length();
            textIndex = -1;
            replaceIndex = -1;
            tempIndex = -1;
            for (i = 0; i < searchLength; ++i) {
                if (noMoreMatchesForReplIndex[i] || searchList[i] == null || searchList[i].length() == 0 || replacementList[i] == null) continue;
                tempIndex = text.indexOf(searchList[i], start);
                if (tempIndex == -1) {
                    noMoreMatchesForReplIndex[i] = true;
                    continue;
                }
                if (textIndex != -1 && tempIndex >= textIndex) continue;
                textIndex = tempIndex;
                replaceIndex = i;
            }
        }
        int textLength = text.length();
        for (int i = start; i < textLength; ++i) {
            buf.append(text.charAt(i));
        }
        String result = buf.toString();
        if (!repeat) {
            return result;
        }
        return StringUtils.replaceEach(result, searchList, replacementList, repeat, timeToLive - 1);
    }

    public static String replaceChars(String str2, char searchChar, char replaceChar) {
        if (str2 == null) {
            return null;
        }
        return str2.replace(searchChar, replaceChar);
    }

    public static String replaceChars(String str2, String searchChars, String replaceChars) {
        if (StringUtils.isEmpty(str2) || StringUtils.isEmpty(searchChars)) {
            return str2;
        }
        if (replaceChars == null) {
            replaceChars = EMPTY;
        }
        boolean modified = false;
        int replaceCharsLength = replaceChars.length();
        int strLength = str2.length();
        StrBuilder buf = new StrBuilder(strLength);
        for (int i = 0; i < strLength; ++i) {
            char ch = str2.charAt(i);
            int index = searchChars.indexOf(ch);
            if (index >= 0) {
                modified = true;
                if (index >= replaceCharsLength) continue;
                buf.append(replaceChars.charAt(index));
                continue;
            }
            buf.append(ch);
        }
        if (modified) {
            return buf.toString();
        }
        return str2;
    }

    public static String overlayString(String text, String overlay, int start, int end) {
        return new StrBuilder(start + overlay.length() + text.length() - end + 1).append(text.substring(0, start)).append(overlay).append(text.substring(end)).toString();
    }

    public static String overlay(String str2, String overlay, int start, int end) {
        if (str2 == null) {
            return null;
        }
        if (overlay == null) {
            overlay = EMPTY;
        }
        int len = str2.length();
        if (start < 0) {
            start = 0;
        }
        if (start > len) {
            start = len;
        }
        if (end < 0) {
            end = 0;
        }
        if (end > len) {
            end = len;
        }
        if (start > end) {
            int temp = start;
            start = end;
            end = temp;
        }
        return new StrBuilder(len + start - end + overlay.length() + 1).append(str2.substring(0, start)).append(overlay).append(str2.substring(end)).toString();
    }

    public static String chomp(String str2) {
        if (StringUtils.isEmpty(str2)) {
            return str2;
        }
        if (str2.length() == 1) {
            char ch = str2.charAt(0);
            if (ch == '\r' || ch == '\n') {
                return EMPTY;
            }
            return str2;
        }
        int lastIdx = str2.length() - 1;
        char last = str2.charAt(lastIdx);
        if (last == '\n') {
            if (str2.charAt(lastIdx - 1) == '\r') {
                --lastIdx;
            }
        } else if (last != '\r') {
            ++lastIdx;
        }
        return str2.substring(0, lastIdx);
    }

    public static String chomp(String str2, String separator) {
        if (StringUtils.isEmpty(str2) || separator == null) {
            return str2;
        }
        if (str2.endsWith(separator)) {
            return str2.substring(0, str2.length() - separator.length());
        }
        return str2;
    }

    public static String chompLast(String str2) {
        return StringUtils.chompLast(str2, "\n");
    }

    public static String chompLast(String str2, String sep) {
        if (str2.length() == 0) {
            return str2;
        }
        String sub = str2.substring(str2.length() - sep.length());
        if (sep.equals(sub)) {
            return str2.substring(0, str2.length() - sep.length());
        }
        return str2;
    }

    public static String getChomp(String str2, String sep) {
        int idx = str2.lastIndexOf(sep);
        if (idx == str2.length() - sep.length()) {
            return sep;
        }
        if (idx != -1) {
            return str2.substring(idx);
        }
        return EMPTY;
    }

    public static String prechomp(String str2, String sep) {
        int idx = str2.indexOf(sep);
        if (idx == -1) {
            return str2;
        }
        return str2.substring(idx + sep.length());
    }

    public static String getPrechomp(String str2, String sep) {
        int idx = str2.indexOf(sep);
        if (idx == -1) {
            return EMPTY;
        }
        return str2.substring(0, idx + sep.length());
    }

    public static String chop(String str2) {
        if (str2 == null) {
            return null;
        }
        int strLen = str2.length();
        if (strLen < 2) {
            return EMPTY;
        }
        int lastIdx = strLen - 1;
        String ret = str2.substring(0, lastIdx);
        char last = str2.charAt(lastIdx);
        if (last == '\n' && ret.charAt(lastIdx - 1) == '\r') {
            return ret.substring(0, lastIdx - 1);
        }
        return ret;
    }

    public static String chopNewline(String str2) {
        int lastIdx = str2.length() - 1;
        if (lastIdx <= 0) {
            return EMPTY;
        }
        char last = str2.charAt(lastIdx);
        if (last == '\n') {
            if (str2.charAt(lastIdx - 1) == '\r') {
                --lastIdx;
            }
        } else {
            ++lastIdx;
        }
        return str2.substring(0, lastIdx);
    }

    public static String escape(String str2) {
        return StringEscapeUtils.escapeJava(str2);
    }

    public static String repeat(String str2, int repeat) {
        if (str2 == null) {
            return null;
        }
        if (repeat <= 0) {
            return EMPTY;
        }
        int inputLength = str2.length();
        if (repeat == 1 || inputLength == 0) {
            return str2;
        }
        if (inputLength == 1 && repeat <= 8192) {
            return StringUtils.padding(repeat, str2.charAt(0));
        }
        int outputLength = inputLength * repeat;
        switch (inputLength) {
            case 1: {
                char ch = str2.charAt(0);
                char[] output1 = new char[outputLength];
                for (int i = repeat - 1; i >= 0; --i) {
                    output1[i] = ch;
                }
                return new String(output1);
            }
            case 2: {
                char ch0 = str2.charAt(0);
                char ch1 = str2.charAt(1);
                char[] output2 = new char[outputLength];
                for (int i = repeat * 2 - 2; i >= 0; --i) {
                    output2[i] = ch0;
                    output2[i + 1] = ch1;
                    --i;
                }
                return new String(output2);
            }
        }
        StrBuilder buf = new StrBuilder(outputLength);
        for (int i = 0; i < repeat; ++i) {
            buf.append(str2);
        }
        return buf.toString();
    }

    public static String repeat(String str2, String separator, int repeat) {
        if (str2 == null || separator == null) {
            return StringUtils.repeat(str2, repeat);
        }
        String result = StringUtils.repeat(str2 + separator, repeat);
        return StringUtils.removeEnd(result, separator);
    }

    private static String padding(int repeat, char padChar) throws IndexOutOfBoundsException {
        if (repeat < 0) {
            throw new IndexOutOfBoundsException("Cannot pad a negative amount: " + repeat);
        }
        char[] buf = new char[repeat];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = padChar;
        }
        return new String(buf);
    }

    public static String rightPad(String str2, int size) {
        return StringUtils.rightPad(str2, size, ' ');
    }

    public static String rightPad(String str2, int size, char padChar) {
        if (str2 == null) {
            return null;
        }
        int pads = size - str2.length();
        if (pads <= 0) {
            return str2;
        }
        if (pads > 8192) {
            return StringUtils.rightPad(str2, size, String.valueOf(padChar));
        }
        return str2.concat(StringUtils.padding(pads, padChar));
    }

    public static String rightPad(String str2, int size, String padStr) {
        if (str2 == null) {
            return null;
        }
        if (StringUtils.isEmpty(padStr)) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str2.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str2;
        }
        if (padLen == 1 && pads <= 8192) {
            return StringUtils.rightPad(str2, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return str2.concat(padStr);
        }
        if (pads < padLen) {
            return str2.concat(padStr.substring(0, pads));
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return str2.concat(new String(padding));
    }

    public static String leftPad(String str2, int size) {
        return StringUtils.leftPad(str2, size, ' ');
    }

    public static String leftPad(String str2, int size, char padChar) {
        if (str2 == null) {
            return null;
        }
        int pads = size - str2.length();
        if (pads <= 0) {
            return str2;
        }
        if (pads > 8192) {
            return StringUtils.leftPad(str2, size, String.valueOf(padChar));
        }
        return StringUtils.padding(pads, padChar).concat(str2);
    }

    public static String leftPad(String str2, int size, String padStr) {
        if (str2 == null) {
            return null;
        }
        if (StringUtils.isEmpty(padStr)) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str2.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str2;
        }
        if (padLen == 1 && pads <= 8192) {
            return StringUtils.leftPad(str2, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return padStr.concat(str2);
        }
        if (pads < padLen) {
            return padStr.substring(0, pads).concat(str2);
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return new String(padding).concat(str2);
    }

    public static int length(String str2) {
        return str2 == null ? 0 : str2.length();
    }

    public static String center(String str2, int size) {
        return StringUtils.center(str2, size, ' ');
    }

    public static String center(String str2, int size, char padChar) {
        if (str2 == null || size <= 0) {
            return str2;
        }
        int strLen = str2.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str2;
        }
        str2 = StringUtils.leftPad(str2, strLen + pads / 2, padChar);
        str2 = StringUtils.rightPad(str2, size, padChar);
        return str2;
    }

    public static String center(String str2, int size, String padStr) {
        int strLen;
        int pads;
        if (str2 == null || size <= 0) {
            return str2;
        }
        if (StringUtils.isEmpty(padStr)) {
            padStr = " ";
        }
        if ((pads = size - (strLen = str2.length())) <= 0) {
            return str2;
        }
        str2 = StringUtils.leftPad(str2, strLen + pads / 2, padStr);
        str2 = StringUtils.rightPad(str2, size, padStr);
        return str2;
    }

    public static String upperCase(String str2) {
        if (str2 == null) {
            return null;
        }
        return str2.toUpperCase();
    }

    public static String upperCase(String str2, Locale locale) {
        if (str2 == null) {
            return null;
        }
        return str2.toUpperCase(locale);
    }

    public static String lowerCase(String str2) {
        if (str2 == null) {
            return null;
        }
        return str2.toLowerCase();
    }

    public static String lowerCase(String str2, Locale locale) {
        if (str2 == null) {
            return null;
        }
        return str2.toLowerCase(locale);
    }

    public static String capitalize(String str2) {
        int strLen;
        if (str2 == null || (strLen = str2.length()) == 0) {
            return str2;
        }
        return new StrBuilder(strLen).append(Character.toTitleCase(str2.charAt(0))).append(str2.substring(1)).toString();
    }

    public static String capitalise(String str2) {
        return StringUtils.capitalize(str2);
    }

    public static String uncapitalize(String str2) {
        int strLen;
        if (str2 == null || (strLen = str2.length()) == 0) {
            return str2;
        }
        return new StrBuilder(strLen).append(Character.toLowerCase(str2.charAt(0))).append(str2.substring(1)).toString();
    }

    public static String uncapitalise(String str2) {
        return StringUtils.uncapitalize(str2);
    }

    public static String swapCase(String str2) {
        int strLen;
        if (str2 == null || (strLen = str2.length()) == 0) {
            return str2;
        }
        StrBuilder buffer = new StrBuilder(strLen);
        char ch = '\u0000';
        for (int i = 0; i < strLen; ++i) {
            ch = str2.charAt(i);
            if (Character.isUpperCase(ch)) {
                ch = Character.toLowerCase(ch);
            } else if (Character.isTitleCase(ch)) {
                ch = Character.toLowerCase(ch);
            } else if (Character.isLowerCase(ch)) {
                ch = Character.toUpperCase(ch);
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static String capitaliseAllWords(String str2) {
        return WordUtils.capitalize(str2);
    }

    public static int countMatches(String str2, String sub) {
        if (StringUtils.isEmpty(str2) || StringUtils.isEmpty(sub)) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = str2.indexOf(sub, idx)) != -1) {
            ++count;
            idx += sub.length();
        }
        return count;
    }

    public static boolean isAlpha(String str2) {
        if (str2 == null) {
            return false;
        }
        int sz = str2.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isLetter(str2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaSpace(String str2) {
        if (str2 == null) {
            return false;
        }
        int sz = str2.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isLetter(str2.charAt(i)) || str2.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphanumeric(String str2) {
        if (str2 == null) {
            return false;
        }
        int sz = str2.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isLetterOrDigit(str2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphanumericSpace(String str2) {
        if (str2 == null) {
            return false;
        }
        int sz = str2.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isLetterOrDigit(str2.charAt(i)) || str2.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isAsciiPrintable(String str2) {
        if (str2 == null) {
            return false;
        }
        int sz = str2.length();
        for (int i = 0; i < sz; ++i) {
            if (CharUtils.isAsciiPrintable(str2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String str2) {
        if (str2 == null) {
            return false;
        }
        int sz = str2.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(str2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumericSpace(String str2) {
        if (str2 == null) {
            return false;
        }
        int sz = str2.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(str2.charAt(i)) || str2.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(String str2) {
        if (str2 == null) {
            return false;
        }
        int sz = str2.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isWhitespace(str2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllLowerCase(String str2) {
        if (str2 == null || StringUtils.isEmpty(str2)) {
            return false;
        }
        int sz = str2.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isLowerCase(str2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllUpperCase(String str2) {
        if (str2 == null || StringUtils.isEmpty(str2)) {
            return false;
        }
        int sz = str2.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isUpperCase(str2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String defaultString(String str2) {
        return str2 == null ? EMPTY : str2;
    }

    public static String defaultString(String str2, String defaultStr) {
        return str2 == null ? defaultStr : str2;
    }

    public static String defaultIfBlank(String str2, String defaultStr) {
        return StringUtils.isBlank(str2) ? defaultStr : str2;
    }

    public static String defaultIfEmpty(String str2, String defaultStr) {
        return StringUtils.isEmpty(str2) ? defaultStr : str2;
    }

    public static String reverse(String str2) {
        if (str2 == null) {
            return null;
        }
        return new StrBuilder(str2).reverse().toString();
    }

    public static String reverseDelimited(String str2, char separatorChar) {
        if (str2 == null) {
            return null;
        }
        Object[] strs = StringUtils.split(str2, separatorChar);
        ArrayUtils.reverse(strs);
        return StringUtils.join(strs, separatorChar);
    }

    public static String reverseDelimitedString(String str2, String separatorChars) {
        if (str2 == null) {
            return null;
        }
        Object[] strs = StringUtils.split(str2, separatorChars);
        ArrayUtils.reverse(strs);
        if (separatorChars == null) {
            return StringUtils.join(strs, ' ');
        }
        return StringUtils.join(strs, separatorChars);
    }

    public static String abbreviate(String str2, int maxWidth) {
        return StringUtils.abbreviate(str2, 0, maxWidth);
    }

    public static String abbreviate(String str2, int offset, int maxWidth) {
        if (str2 == null) {
            return null;
        }
        if (maxWidth < 4) {
            throw new IllegalArgumentException("Minimum abbreviation width is 4");
        }
        if (str2.length() <= maxWidth) {
            return str2;
        }
        if (offset > str2.length()) {
            offset = str2.length();
        }
        if (str2.length() - offset < maxWidth - 3) {
            offset = str2.length() - (maxWidth - 3);
        }
        if (offset <= 4) {
            return str2.substring(0, maxWidth - 3) + "...";
        }
        if (maxWidth < 7) {
            throw new IllegalArgumentException("Minimum abbreviation width with offset is 7");
        }
        if (offset + (maxWidth - 3) < str2.length()) {
            return "..." + StringUtils.abbreviate(str2.substring(offset), maxWidth - 3);
        }
        return "..." + str2.substring(str2.length() - (maxWidth - 3));
    }

    public static String abbreviateMiddle(String str2, String middle, int length) {
        if (StringUtils.isEmpty(str2) || StringUtils.isEmpty(middle)) {
            return str2;
        }
        if (length >= str2.length() || length < middle.length() + 2) {
            return str2;
        }
        int targetSting = length - middle.length();
        int startOffset = targetSting / 2 + targetSting % 2;
        int endOffset = str2.length() - targetSting / 2;
        StrBuilder builder = new StrBuilder(length);
        builder.append(str2.substring(0, startOffset));
        builder.append(middle);
        builder.append(str2.substring(endOffset));
        return builder.toString();
    }

    public static String difference(String str1, String str2) {
        if (str1 == null) {
            return str2;
        }
        if (str2 == null) {
            return str1;
        }
        int at = StringUtils.indexOfDifference(str1, str2);
        if (at == -1) {
            return EMPTY;
        }
        return str2.substring(at);
    }

    public static int indexOfDifference(String str1, String str2) {
        int i;
        if (str1 == str2) {
            return -1;
        }
        if (str1 == null || str2 == null) {
            return 0;
        }
        for (i = 0; i < str1.length() && i < str2.length() && str1.charAt(i) == str2.charAt(i); ++i) {
        }
        if (i < str2.length() || i < str1.length()) {
            return i;
        }
        return -1;
    }

    public static int indexOfDifference(String[] strs) {
        if (strs == null || strs.length <= 1) {
            return -1;
        }
        boolean anyStringNull = false;
        boolean allStringsNull = true;
        int arrayLen = strs.length;
        int shortestStrLen = Integer.MAX_VALUE;
        int longestStrLen = 0;
        for (int i = 0; i < arrayLen; ++i) {
            if (strs[i] == null) {
                anyStringNull = true;
                shortestStrLen = 0;
                continue;
            }
            allStringsNull = false;
            shortestStrLen = Math.min(strs[i].length(), shortestStrLen);
            longestStrLen = Math.max(strs[i].length(), longestStrLen);
        }
        if (allStringsNull || longestStrLen == 0 && !anyStringNull) {
            return -1;
        }
        if (shortestStrLen == 0) {
            return 0;
        }
        int firstDiff = -1;
        for (int stringPos = 0; stringPos < shortestStrLen; ++stringPos) {
            char comparisonChar = strs[0].charAt(stringPos);
            for (int arrayPos = 1; arrayPos < arrayLen; ++arrayPos) {
                if (strs[arrayPos].charAt(stringPos) == comparisonChar) continue;
                firstDiff = stringPos;
                break;
            }
            if (firstDiff != -1) break;
        }
        if (firstDiff == -1 && shortestStrLen != longestStrLen) {
            return shortestStrLen;
        }
        return firstDiff;
    }

    public static String getCommonPrefix(String[] strs) {
        if (strs == null || strs.length == 0) {
            return EMPTY;
        }
        int smallestIndexOfDiff = StringUtils.indexOfDifference(strs);
        if (smallestIndexOfDiff == -1) {
            if (strs[0] == null) {
                return EMPTY;
            }
            return strs[0];
        }
        if (smallestIndexOfDiff == 0) {
            return EMPTY;
        }
        return strs[0].substring(0, smallestIndexOfDiff);
    }

    public static int getLevenshteinDistance(String s, String t) {
        int i;
        if (s == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        if (n > m) {
            String tmp = s;
            s = t;
            t = tmp;
            n = m;
            m = t.length();
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = t.charAt(j - 1);
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int cost = s.charAt(i - 1) == t_j ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }

    public static boolean startsWith(String str2, String prefix) {
        return StringUtils.startsWith(str2, prefix, false);
    }

    public static boolean startsWithIgnoreCase(String str2, String prefix) {
        return StringUtils.startsWith(str2, prefix, true);
    }

    private static boolean startsWith(String str2, String prefix, boolean ignoreCase) {
        if (str2 == null || prefix == null) {
            return str2 == null && prefix == null;
        }
        if (prefix.length() > str2.length()) {
            return false;
        }
        return str2.regionMatches(ignoreCase, 0, prefix, 0, prefix.length());
    }

    public static boolean startsWithAny(String string, String[] searchStrings) {
        if (StringUtils.isEmpty(string) || ArrayUtils.isEmpty(searchStrings)) {
            return false;
        }
        for (int i = 0; i < searchStrings.length; ++i) {
            String searchString = searchStrings[i];
            if (!StringUtils.startsWith(string, searchString)) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWith(String str2, String suffix) {
        return StringUtils.endsWith(str2, suffix, false);
    }

    public static boolean endsWithIgnoreCase(String str2, String suffix) {
        return StringUtils.endsWith(str2, suffix, true);
    }

    private static boolean endsWith(String str2, String suffix, boolean ignoreCase) {
        if (str2 == null || suffix == null) {
            return str2 == null && suffix == null;
        }
        if (suffix.length() > str2.length()) {
            return false;
        }
        int strOffset = str2.length() - suffix.length();
        return str2.regionMatches(ignoreCase, strOffset, suffix, 0, suffix.length());
    }

    public static String normalizeSpace(String str2) {
        if ((str2 = StringUtils.strip(str2)) == null || str2.length() <= 2) {
            return str2;
        }
        StrBuilder b = new StrBuilder(str2.length());
        for (int i = 0; i < str2.length(); ++i) {
            char c = str2.charAt(i);
            if (Character.isWhitespace(c)) {
                if (i <= 0 || Character.isWhitespace(str2.charAt(i - 1))) continue;
                b.append(' ');
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static boolean endsWithAny(String string, String[] searchStrings) {
        if (StringUtils.isEmpty(string) || ArrayUtils.isEmpty(searchStrings)) {
            return false;
        }
        for (int i = 0; i < searchStrings.length; ++i) {
            String searchString = searchStrings[i];
            if (!StringUtils.endsWith(string, searchString)) continue;
            return true;
        }
        return false;
    }
}

