/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.convert;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.log4j.Logger;
import org.dataone.cn.indexer.XmlDocumentUtility;
import org.dataone.configuration.Settings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class MemberNodeServiceRegistrationTypeDocumentService {
    private static Logger log = Logger.getLogger(MemberNodeServiceRegistrationTypeDocumentService.class.getName());
    private static final String SERVICE_DOC_LOCATION_URL = Settings.getConfiguration().getString("dataone.mn.registration.serviceType.url");
    @Autowired
    private HttpComponentsClientHttpRequestFactory httpRequestFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getMemberNodeServiceRegistrationTypeDocument() {
        Document doc = null;
        InputStream stream = this.fetchServiceTypeDoc();
        if (stream != null) {
            try {
                doc = XmlDocumentUtility.generateXmlDocument(stream);
            }
            catch (SAXException e2) {
                log.error("Unable to create w3c Document from input stream", e2);
                e2.printStackTrace();
            }
            finally {
                IOUtils.closeQuietly(stream);
            }
        }
        return doc;
    }

    private InputStream fetchServiceTypeDoc() {
        InputStream stream = null;
        HttpClient httpClient = this.httpRequestFactory.getHttpClient();
        HttpGet get = new HttpGet(SERVICE_DOC_LOCATION_URL);
        try {
            HttpResponse response = httpClient.execute(get);
            HttpEntity entity = response.getEntity();
            stream = entity.getContent();
        }
        catch (ClientProtocolException e2) {
            e2.printStackTrace();
            log.error("Unable to fetch service type doc from: " + SERVICE_DOC_LOCATION_URL, e2);
        }
        catch (IOException e3) {
            e3.printStackTrace();
            log.error("Unable to fetch service type doc from: " + SERVICE_DOC_LOCATION_URL, e3);
        }
        return stream;
    }

    protected String getServiceTypeDocUrl() {
        return SERVICE_DOC_LOCATION_URL;
    }

    protected HttpComponentsClientHttpRequestFactory getHttpClientFactory() {
        return this.httpRequestFactory;
    }
}

