/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser;

import com.github.jsonldjava.core.DocumentLoader;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.utils.JsonUtils;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.cn.index.util.PerformanceLogger;
import org.dataone.cn.indexer.annotation.SparqlField;
import org.dataone.cn.indexer.annotation.TripleStoreService;
import org.dataone.cn.indexer.parser.DerivedSolrField;
import org.dataone.cn.indexer.parser.IDocumentSubprocessor;
import org.dataone.cn.indexer.parser.ISolrDataField;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.cn.indexer.solrhttp.SolrElementField;
import org.dataone.configuration.Settings;

public class JsonLdSubprocessor
implements IDocumentSubprocessor {
    private static Log log = LogFactory.getLog(JsonLdSubprocessor.class);
    private static PerformanceLogger perfLog = PerformanceLogger.getInstance();
    private List<String> matchDocuments = null;
    private List<ISolrDataField> fieldList = new ArrayList<ISolrDataField>();
    private static String schemaOrghttpContextFn = "jsonldcontext_http.jsonld";
    private static String schemaOrgHttpsContextFn = "jsonldcontext_https.jsonld";
    private static String schemaOrgHttpListContextFn = "jsonldcontext_http_list.jsonld";
    private static String schemaOrghttpContextPath = Settings.getConfiguration().getString("dataone.indexing.schema.org.httpcontext.path", "/etc/dataone/index/schema-org-contexts/" + schemaOrghttpContextFn);
    private static String schemaOrgHttpsContextPath = Settings.getConfiguration().getString("dataone.indexing.schema.org.httpscontext.path", "/etc/dataone/index/schema-org-contexts/" + schemaOrgHttpsContextFn);
    private static String schemaOrgHttpListContextPath = Settings.getConfiguration().getString("dataone.indexing.schema.org.httpListcontext.path", "/etc/dataone/index/schema-org-contexts/" + schemaOrgHttpListContextFn);
    private static final String HTTP_SCHEMAORG = "http://schema.org";
    private static final String HTTPS_SCHEMAORG = "https://schema.org";

    @Override
    public boolean canProcess(String formatId) {
        return this.matchDocuments.contains(formatId);
    }

    public List<String> getMatchDocuments() {
        return this.matchDocuments;
    }

    public void setMatchDocuments(List<String> matchDocuments) {
        this.matchDocuments = matchDocuments;
    }

    public List<ISolrDataField> getFieldList() {
        return this.fieldList;
    }

    public void setFieldList(List<ISolrDataField> fieldList) {
        this.fieldList = fieldList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, SolrDoc> processDocument(String identifier, Map<String, SolrDoc> docs, InputStream is) throws Exception {
        Map<String, Object> compactedJSONLD;
        HashMap<String, String> ctx;
        Object object;
        String httpListContextStr;
        String httpsContextStr;
        String httpContextStr;
        File schemaOrghttp = new File(schemaOrghttpContextPath);
        File schemaOrghttps = new File(schemaOrgHttpsContextPath);
        File schemaOrghttpList = new File(schemaOrgHttpListContextPath);
        FileInputStream fis = null;
        InputStream resourceIS = null;
        if (schemaOrghttp.exists()) {
            log.info("reading schema files from the local file system " + schemaOrghttp.getCanonicalPath());
            try {
                fis = new FileInputStream(schemaOrghttp);
                httpContextStr = IOUtils.toString((InputStream)fis, "UTF-8");
            }
            finally {
                fis.close();
            }
        }
        log.info("reading schema files from the jar file " + schemaOrghttpContextFn);
        try {
            resourceIS = this.getClass().getResourceAsStream("/contexts/" + schemaOrghttpContextFn);
            httpContextStr = IOUtils.toString(resourceIS, "UTF-8");
        }
        finally {
            resourceIS.close();
        }
        if (schemaOrghttps.exists()) {
            log.info("reading schema files from the local file system " + schemaOrghttps.getCanonicalPath());
            try {
                fis = new FileInputStream(schemaOrghttps);
                httpsContextStr = IOUtils.toString((InputStream)fis, "UTF-8");
            }
            finally {
                fis.close();
            }
        }
        log.info("reading schema files from the jar file " + schemaOrgHttpsContextFn);
        try {
            resourceIS = this.getClass().getResourceAsStream("/contexts/" + schemaOrgHttpsContextFn);
            httpsContextStr = IOUtils.toString(resourceIS, "UTF-8");
        }
        finally {
            resourceIS.close();
        }
        if (schemaOrghttpList.exists()) {
            log.info("reading schema files from the local file system " + schemaOrghttpList.getCanonicalPath());
            try {
                fis = new FileInputStream(schemaOrghttpList);
                httpListContextStr = IOUtils.toString((InputStream)fis, "UTF-8");
            }
            finally {
                fis.close();
            }
        }
        log.info("reading schema files from the jar file " + schemaOrgHttpListContextFn);
        try {
            resourceIS = this.getClass().getResourceAsStream("/contexts/" + schemaOrgHttpListContextFn);
            httpListContextStr = IOUtils.toString(resourceIS, "UTF-8");
        }
        finally {
            resourceIS.close();
        }
        try {
            object = JsonUtils.fromInputStream(is, "UTF-8");
        }
        finally {
            is.close();
        }
        DocumentLoader dlAll = new DocumentLoader();
        dlAll.addInjectedDoc(HTTP_SCHEMAORG, httpContextStr);
        dlAll.addInjectedDoc("http://schema.org/", httpContextStr);
        dlAll.addInjectedDoc("http://schema.org/docs/jsonldcontext.jsonld", httpContextStr);
        dlAll.addInjectedDoc(HTTPS_SCHEMAORG, httpsContextStr);
        dlAll.addInjectedDoc("https://schema.org/", httpsContextStr);
        dlAll.addInjectedDoc("https://schema.org/docs/jsonldcontext.jsonld", httpsContextStr);
        JsonLdOptions options = new JsonLdOptions();
        options.setDocumentLoader(dlAll);
        List<Object> expandedJSONLD = JsonLdProcessor.expand(object, options);
        log.trace("JSON document after expand: ");
        log.trace(JsonUtils.toPrettyString(expandedJSONLD));
        if (this.isHttps(expandedJSONLD)) {
            log.debug("processing a JSONLD document containing an https://schema.org context");
            options = new JsonLdOptions();
            ctx = new HashMap<String, String>();
            ctx.put("@context", "https://schema.org/");
            options.setDocumentLoader(dlAll);
            compactedJSONLD = JsonLdProcessor.compact(expandedJSONLD, ctx, options);
            log.trace("JSON document after compaction: ");
            log.trace(JsonUtils.toPrettyString(compactedJSONLD));
        } else {
            log.debug("processing a JSONLD document containing an http://schema.org context");
            options = new JsonLdOptions();
            ctx = new HashMap();
            ctx.put("@context", "http://schema.org/");
            options.setDocumentLoader(dlAll);
            compactedJSONLD = JsonLdProcessor.compact(expandedJSONLD, ctx, options);
            log.trace("JSON document after compaction: ");
            log.trace(JsonUtils.toPrettyString(compactedJSONLD));
        }
        DocumentLoader dl = new DocumentLoader();
        dl.addInjectedDoc(HTTP_SCHEMAORG, httpListContextStr);
        dl.addInjectedDoc("http://schema.org/", httpListContextStr);
        dl.addInjectedDoc(HTTPS_SCHEMAORG, httpListContextStr);
        dl.addInjectedDoc("https://schema.org/", httpListContextStr);
        dl.addInjectedDoc("http://schema.org/docs/jsonldcontext.jsonld", httpListContextStr);
        dl.addInjectedDoc("https://schema.org/docs/jsonldcontext.jsonld", httpListContextStr);
        options = new JsonLdOptions();
        options.setDocumentLoader(dl);
        expandedJSONLD = JsonLdProcessor.expand(compactedJSONLD, options);
        String str2 = JsonUtils.toString(expandedJSONLD);
        log.trace("JSON document after expand: " + str2);
        is = new ByteArrayInputStream(str2.getBytes());
        SolrDoc metaDocument = docs.get(identifier);
        if (metaDocument == null) {
            metaDocument = new SolrDoc();
            docs.put(identifier, metaDocument);
        }
        long start = System.currentTimeMillis();
        Dataset dataset = TripleStoreService.getInstance().getDataset();
        try {
            perfLog.log("JsonLdSubprocessor.process gets a dataset from tripe store service ", System.currentTimeMillis() - start);
            long startOntModel = System.currentTimeMillis();
            Model model = ModelFactory.createDefaultModel();
            model.read(is, "", "JSON-LD");
            dataset.getDefaultModel().add(model);
            perfLog.log("JsonLdSubprocessor.process adds the model ", System.currentTimeMillis() - startOntModel);
            long startField = System.currentTimeMillis();
            for (ISolrDataField field : this.fieldList) {
                long filed = System.currentTimeMillis();
                String q = null;
                String separator = null;
                log.trace("Processing field: " + field.getName());
                if (field instanceof SparqlField) {
                    String fullValue = null;
                    Boolean concatValues = ((SparqlField)field).getConcatValues();
                    if (concatValues == null) {
                        concatValues = false;
                    }
                    if ((separator = ((SparqlField)field).getSeparator()) == null) {
                        separator = " ";
                    }
                    q = ((SparqlField)field).getQuery();
                    Query query2 = QueryFactory.create(q);
                    log.trace("Executing SPARQL query:\n" + query2.toString());
                    QueryExecution qexec = QueryExecutionFactory.create(query2, dataset);
                    ResultSet results = qexec.execSelect();
                    while (results.hasNext()) {
                        Object solrDoc = null;
                        QuerySolution solution = results.next();
                        log.trace(solution.toString());
                        if (!solution.contains(field.getName())) continue;
                        String value = solution.get(field.getName()).toString();
                        if (((SparqlField)field).getConverter() != null) {
                            value = ((SparqlField)field).getConverter().convert(value);
                        }
                        if (concatValues.booleanValue()) {
                            if (fullValue == null) {
                                fullValue = value;
                                continue;
                            }
                            fullValue = fullValue + separator + value;
                            continue;
                        }
                        SolrElementField f = new SolrElementField(field.getName(), value);
                        log.trace("JsonLdSubprocessor.process process the field " + field.getName() + " with value " + value);
                        metaDocument.addField(f);
                    }
                    if (concatValues.booleanValue()) {
                        SolrElementField f = new SolrElementField(field.getName(), fullValue);
                        log.trace("JsonLdSubprocessor.process process the concat field " + field.getName() + " with value " + fullValue);
                        metaDocument.addField(f);
                    }
                } else if (field instanceof DerivedSolrField) {
                    Object solrDoc = null;
                    List<SolrElementField> fields = ((DerivedSolrField)field).getFields(dataset);
                    for (SolrElementField sel : fields) {
                        log.trace("JsonLdSubprocessor.process processed the field " + sel.getName() + " with value " + sel.getValue());
                        metaDocument.addField(sel);
                    }
                }
                perfLog.log("JsonLdSubprocessor.process process the field " + field.getName(), System.currentTimeMillis() - filed);
            }
            perfLog.log("JsonLdSubprocessor.process() total take ", System.currentTimeMillis() - start);
        }
        finally {
            try {
                TripleStoreService.getInstance().destoryDataset(dataset);
            }
            catch (Exception e2) {
                log.warn("A tdb directory can't be removed since " + e2.getMessage(), e2);
            }
        }
        return docs;
    }

    public boolean isHttps(List expandedJsonld) throws Exception {
        boolean https = false;
        Vector<String> schema = new Vector<String>();
        this.findSchemaDotOrg(expandedJsonld, schema);
        if (schema != null && schema.size() > 0 && schema.get(0).equals(HTTPS_SCHEMAORG)) {
            https = true;
        } else if (schema != null && schema.size() > 0 && schema.get(0).equals(HTTP_SCHEMAORG)) {
            https = false;
        } else {
            throw new Exception("The Processor cannot find the either prefix of https://schema.org or http://schema.org in the expanded json-ld object.");
        }
        return https;
    }

    private void findSchemaDotOrg(Object expandedJsonld, Vector<String> schema) {
        if (expandedJsonld instanceof List) {
            List list = (List)expandedJsonld;
            for (int i = 0; i < list.size(); ++i) {
                Object obj = list.get(i);
                if (!(obj instanceof Map)) continue;
                Map map = (Map)obj;
                Set keys = map.keySet();
                for (Object key : keys) {
                    Object value;
                    log.debug("JsonLdSubProcess.findSchemaDotOrg - the key is " + key + " and value is " + map.get(key));
                    if (key instanceof String) {
                        if (((String)key).startsWith(HTTPS_SCHEMAORG)) {
                            schema.add(HTTPS_SCHEMAORG);
                            log.debug("JsonLdSubProcess.findSchemaDotOrg - after setting the schema" + schema);
                            return;
                        }
                        if (((String)key).startsWith(HTTP_SCHEMAORG)) {
                            schema.add(HTTP_SCHEMAORG);
                            log.debug("JsonLdSubProcess.findSchemaDotOrg - after setting theschema " + schema);
                            return;
                        }
                    }
                    if ((value = map.get(key)) == null || !(value instanceof List) && !(value instanceof Map)) continue;
                    this.findSchemaDotOrg(value, schema);
                }
            }
        } else if (expandedJsonld instanceof Map) {
            Map map = (Map)expandedJsonld;
            Set keys = map.keySet();
            for (Object key : keys) {
                Object value;
                log.debug("JsonLdSubProcess.findSchemaDotOrg - the key is " + key + " and value is " + map.get(key));
                if (key instanceof String) {
                    if (((String)key).startsWith(HTTPS_SCHEMAORG)) {
                        schema.add(HTTPS_SCHEMAORG);
                        log.debug("JsonLdSubProcess.findSchemaDotOrg - after setting the schema" + schema);
                        return;
                    }
                    if (((String)key).startsWith(HTTP_SCHEMAORG)) {
                        schema.add(HTTP_SCHEMAORG);
                        log.debug("JsonLdSubProcess.findSchemaDotOrg - after setting theschema " + schema);
                        return;
                    }
                }
                if ((value = map.get(key)) == null || !(value instanceof List) && !(value instanceof Map)) continue;
                this.findSchemaDotOrg(value, schema);
            }
        }
        log.debug("JsonLdSubProcess.findSchemaDotOrg - end of findschema method , the schema is " + schema);
    }

    @Override
    public SolrDoc mergeWithIndexedDocument(SolrDoc indexDocument) throws IOException, EncoderException, XPathExpressionException {
        return indexDocument;
    }
}

