/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.predicate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.CriteriaQueryCompiler;
import org.hibernate.ejb.criteria.ParameterContainer;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.Renderable;
import org.hibernate.ejb.criteria.predicate.AbstractPredicateImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundPredicate
extends AbstractPredicateImpl
implements Serializable {
    private Predicate.BooleanOperator operator;
    private final List<Expression<Boolean>> expressions = new ArrayList<Expression<Boolean>>();

    public CompoundPredicate(CriteriaBuilderImpl criteriaBuilder, Predicate.BooleanOperator operator) {
        super(criteriaBuilder);
        this.operator = operator;
    }

    public CompoundPredicate(CriteriaBuilderImpl criteriaBuilder, Predicate.BooleanOperator operator, Expression<Boolean> ... expressions) {
        this(criteriaBuilder, operator);
        this.applyExpressions(expressions);
    }

    public CompoundPredicate(CriteriaBuilderImpl criteriaBuilder, Predicate.BooleanOperator operator, List<Expression<Boolean>> expressions) {
        this(criteriaBuilder, operator);
        this.applyExpressions(expressions);
    }

    private void applyExpressions(Expression<Boolean> ... expressions) {
        this.applyExpressions(Arrays.asList(expressions));
    }

    private void applyExpressions(List<Expression<Boolean>> expressions) {
        this.expressions.clear();
        this.expressions.addAll(expressions);
    }

    @Override
    public Predicate.BooleanOperator getOperator() {
        return this.operator;
    }

    @Override
    public List<Expression<Boolean>> getExpressions() {
        return this.expressions;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        for (Expression<Boolean> expression : this.getExpressions()) {
            ParameterContainer.Helper.possibleParameter(expression, registry);
        }
    }

    @Override
    public String render(CriteriaQueryCompiler.RenderingContext renderingContext) {
        if (this.getExpressions().size() == 0) {
            boolean implicitTrue;
            boolean bl = implicitTrue = this.getOperator() == Predicate.BooleanOperator.AND;
            if (this.isNegated()) {
                implicitTrue = !implicitTrue;
            }
            return implicitTrue ? "1=1" : "0=1";
        }
        if (this.getExpressions().size() == 1) {
            return ((Renderable)((Object)this.getExpressions().get(0))).render(renderingContext);
        }
        StringBuilder buffer = new StringBuilder();
        String sep = "";
        for (Expression<Boolean> expression : this.getExpressions()) {
            buffer.append(sep).append("( ").append(((Renderable)((Object)expression)).render(renderingContext)).append(" )");
            sep = this.operatorTextWithSeparator();
        }
        return buffer.toString();
    }

    private String operatorTextWithSeparator() {
        return this.getOperator() == Predicate.BooleanOperator.AND ? " and " : " or ";
    }

    @Override
    public String renderProjection(CriteriaQueryCompiler.RenderingContext renderingContext) {
        return this.render(renderingContext);
    }

    @Override
    public Predicate not() {
        this.toggleOperator();
        for (Expression<Boolean> expr : this.getExpressions()) {
            if (!Predicate.class.isInstance(expr)) continue;
            ((Predicate)expr).not();
        }
        return this;
    }

    private void toggleOperator() {
        this.operator = this.operator == Predicate.BooleanOperator.AND ? Predicate.BooleanOperator.OR : Predicate.BooleanOperator.AND;
    }
}

