/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.domain;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.joda.time.DateTime;
import org.springframework.data.domain.Auditable;
import org.springframework.data.jpa.domain.AbstractPersistable;

@MappedSuperclass
public abstract class AbstractAuditable<U, PK extends Serializable>
extends AbstractPersistable<PK>
implements Auditable<U, PK> {
    private static final long serialVersionUID = 141481953116476081L;
    @ManyToOne
    private U createdBy;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdDate;
    @ManyToOne
    private U lastModifiedBy;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastModifiedDate;

    @Override
    public U getCreatedBy() {
        return this.createdBy;
    }

    @Override
    public void setCreatedBy(U createdBy) {
        this.createdBy = createdBy;
    }

    @Override
    public DateTime getCreatedDate() {
        return null == this.createdDate ? null : new DateTime(this.createdDate);
    }

    @Override
    public void setCreatedDate(DateTime createdDate) {
        this.createdDate = null == createdDate ? null : createdDate.toDate();
    }

    @Override
    public U getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    @Override
    public void setLastModifiedBy(U lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    @Override
    public DateTime getLastModifiedDate() {
        return null == this.lastModifiedDate ? null : new DateTime(this.lastModifiedDate);
    }

    @Override
    public void setLastModifiedDate(DateTime lastModifiedDate) {
        this.lastModifiedDate = null == lastModifiedDate ? null : lastModifiedDate.toDate();
    }
}

