/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClusterClientException;
import com.hazelcast.client.PacketReader;
import com.hazelcast.client.PacketWriter;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.GroupProperties;
import com.hazelcast.util.ByteUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;

public class Packet {
    private byte[] key;
    private byte[] value;
    private String name;
    private ClusterOperation operation;
    private int threadId;
    private long ttl = -1L;
    private long timeout = -1L;
    private long longValue;
    private byte responseType = (byte)2;
    private long callId = -1L;
    private static final byte PACKET_VERSION = GroupProperties.PACKET_VERSION.getByte();
    private int keyHash = -1;
    private int valueHash = -1;

    public void reset() {
        this.name = null;
        this.operation = null;
        this.key = null;
        this.value = null;
        this.threadId = -1;
        this.ttl = -1L;
        this.timeout = -1L;
        this.longValue = 0L;
        this.responseType = (byte)2;
        this.callId = -1L;
        this.keyHash = -1;
        this.valueHash = -1;
    }

    public void writeTo(PacketWriter packetWriter, DataOutputStream outputStream) throws IOException {
        ByteBuffer writeHeaderBuffer = packetWriter.writeHeaderBuffer;
        writeHeaderBuffer.clear();
        writeHeaderBuffer.position(13);
        this.writeHeader(packetWriter);
        int size = writeHeaderBuffer.position();
        int headerSize = size - 13;
        writeHeaderBuffer.position(0);
        writeHeaderBuffer.putInt(headerSize);
        writeHeaderBuffer.putInt(this.key == null ? 0 : this.key.length);
        writeHeaderBuffer.putInt(this.value == null ? 0 : this.value.length);
        writeHeaderBuffer.put(PACKET_VERSION);
        outputStream.write(writeHeaderBuffer.array(), 0, size);
        if (this.key != null) {
            outputStream.write(this.key);
        }
        if (this.value != null) {
            outputStream.write(this.value);
        }
    }

    public void readFrom(PacketReader packetReader, DataInputStream dis) throws IOException {
        ByteBuffer readHeaderBuffer = packetReader.readHeaderBuffer;
        int headerSize = dis.readInt();
        int keySize = dis.readInt();
        int valueSize = dis.readInt();
        byte packetVersion = dis.readByte();
        if (packetVersion != PACKET_VERSION) {
            throw new ClusterClientException("Invalid packet version. Expected:" + PACKET_VERSION + ", Found:" + packetVersion);
        }
        readHeaderBuffer.clear();
        readHeaderBuffer.limit(headerSize);
        dis.readFully(readHeaderBuffer.array(), 0, headerSize);
        this.operation = ClusterOperation.create(readHeaderBuffer.getShort());
        int blockId = readHeaderBuffer.getInt();
        this.threadId = readHeaderBuffer.getInt();
        byte booleans = readHeaderBuffer.get();
        if (ByteUtil.isTrue(booleans, 1)) {
            this.timeout = readHeaderBuffer.getLong();
        }
        if (ByteUtil.isTrue(booleans, 2)) {
            this.ttl = readHeaderBuffer.getLong();
        }
        if (ByteUtil.isTrue(booleans, 4)) {
            this.longValue = readHeaderBuffer.getLong();
        }
        if (!ByteUtil.isTrue(booleans, 7)) {
            throw new ClusterClientException("LockAddress cannot be sent to the client!" + (Object)((Object)this.operation));
        }
        this.callId = readHeaderBuffer.getLong();
        this.responseType = readHeaderBuffer.get();
        int nameLength = readHeaderBuffer.getInt();
        if (nameLength > 0) {
            byte[] b = new byte[nameLength];
            readHeaderBuffer.get(b);
            this.name = new String(b);
        }
        readHeaderBuffer.get();
        this.keyHash = readHeaderBuffer.getInt();
        this.valueHash = readHeaderBuffer.getInt();
        readHeaderBuffer.get();
        this.key = new byte[keySize];
        dis.readFully(this.key);
        this.value = new byte[valueSize];
        dis.readFully(this.value);
    }

    private void writeHeader(PacketWriter packetWriter) throws IOException {
        ByteBuffer writeHeaderBuffer = packetWriter.writeHeaderBuffer;
        Map<String, byte[]> nameCache = packetWriter.nameCache;
        writeHeaderBuffer.putShort(this.operation.getValue());
        writeHeaderBuffer.putInt(-1);
        writeHeaderBuffer.putInt(this.threadId);
        byte booleans = 0;
        if (this.timeout != -1L) {
            booleans = ByteUtil.setTrue(booleans, 1);
        }
        if (this.ttl != -1L) {
            booleans = ByteUtil.setTrue(booleans, 2);
        }
        if (this.longValue != Long.MIN_VALUE) {
            booleans = ByteUtil.setTrue(booleans, 4);
        }
        booleans = ByteUtil.setTrue(booleans, 6);
        booleans = ByteUtil.setTrue(booleans, 7);
        writeHeaderBuffer.put(booleans);
        if (this.timeout != -1L) {
            writeHeaderBuffer.putLong(this.timeout);
        }
        if (this.ttl != -1L) {
            writeHeaderBuffer.putLong(this.ttl);
        }
        if (this.longValue != Long.MIN_VALUE) {
            writeHeaderBuffer.putLong(this.longValue);
        }
        writeHeaderBuffer.putLong(this.callId);
        writeHeaderBuffer.put(this.responseType);
        int nameLen = 0;
        byte[] nameInBytes = null;
        if (this.name != null) {
            nameInBytes = nameCache.get(this.name);
            if (nameInBytes == null) {
                nameInBytes = this.name.getBytes();
                if (nameCache.size() > 10000) {
                    nameCache.clear();
                }
                nameCache.put(this.name, nameInBytes);
            }
            nameLen = nameInBytes.length;
        }
        writeHeaderBuffer.putInt(nameLen);
        if (nameLen > 0) {
            writeHeaderBuffer.put(nameInBytes);
        }
        writeHeaderBuffer.put((byte)0);
        writeHeaderBuffer.putInt(this.keyHash);
        writeHeaderBuffer.putInt(this.valueHash);
        writeHeaderBuffer.put((byte)0);
    }

    public void set(String name, ClusterOperation operation, byte[] key, byte[] value) {
        this.name = name;
        this.operation = operation;
        this.setKey(key);
        this.setValue(value);
    }

    public byte[] getKey() {
        return this.key;
    }

    public void setKey(byte[] key) {
        this.key = key;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public void setCallId(long callId) {
        this.callId = callId;
    }

    public long getCallId() {
        return this.callId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ClusterOperation getOperation() {
        return this.operation;
    }

    public void setOperation(ClusterOperation operation) {
        this.operation = operation;
    }

    public int getThreadId() {
        return this.threadId;
    }

    public void setThreadId(int threadId) {
        this.threadId = threadId;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(long longValue) {
        this.longValue = longValue;
    }

    public byte getResponseType() {
        return this.responseType;
    }

    public void setResponseType(byte responseType) {
        this.responseType = responseType;
    }

    public int getKeyHash() {
        return this.keyHash;
    }

    public void setKeyHash(int keyHash) {
        this.keyHash = keyHash;
    }

    public long getTtl() {
        return this.ttl;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public int getValueHash() {
        return this.valueHash;
    }

    public void setValueHash(int valueHash) {
        this.valueHash = valueHash;
    }

    public String toString() {
        return "Packet [callId = " + this.callId + "  name = " + this.name + " operation = " + (Object)((Object)this.operation) + "]";
    }
}

