/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.impl.base.SystemLogService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.nio.InOutSelector;
import com.hazelcast.nio.SelectionHandler;
import com.hazelcast.nio.SocketChannelWrapper;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.logging.Level;

abstract class AbstractSelectionHandler
implements SelectionHandler {
    protected final ILogger logger;
    protected final SocketChannelWrapper socketChannel;
    protected final Connection connection;
    protected final InOutSelector inOutSelector;
    protected final ConnectionManager connectionManager;
    protected final SystemLogService systemLogService;
    protected SelectionKey sk = null;

    public AbstractSelectionHandler(Connection connection, InOutSelector inOutSelector) {
        this.connection = connection;
        this.inOutSelector = inOutSelector;
        this.socketChannel = connection.getSocketChannelWrapper();
        this.connectionManager = connection.getConnectionManager();
        this.logger = this.connectionManager.ioService.getLogger(this.getClass().getName());
        this.systemLogService = this.connectionManager.ioService.getSystemLogService();
    }

    protected void shutdown() {
    }

    final void handleSocketException(Throwable e2) {
        if (e2 instanceof OutOfMemoryError) {
            this.connectionManager.ioService.onOutOfMemory((OutOfMemoryError)e2);
        }
        if (this.sk != null) {
            this.sk.cancel();
        }
        this.connection.close(e2);
        if (this.connection.getType().isClient() && !this.connection.getType().isBinary()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Thread.currentThread().getName());
        sb.append(" Closing socket to endpoint ");
        sb.append(this.connection.getEndPoint());
        sb.append(", Cause:").append(e2);
        if (e2 instanceof IOException) {
            this.logger.log(Level.WARNING, sb.toString());
        } else {
            this.logger.log(Level.WARNING, sb.toString(), e2);
        }
    }

    final void registerOp(Selector selector, int operation) {
        try {
            if (!this.connection.live()) {
                return;
            }
            if (this.sk == null) {
                this.sk = this.socketChannel.keyFor(selector);
            }
            if (this.sk == null) {
                this.sk = this.socketChannel.register(selector, operation, this.connection);
            } else {
                this.sk.interestOps(this.sk.interestOps() | operation);
                if (this.sk.attachment() != this.connection) {
                    this.sk.attach(this.connection);
                }
            }
        }
        catch (Throwable e2) {
            this.handleSocketException(e2);
        }
    }
}

