/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.optimize;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.PropertyFunctionGenerator;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpTriple;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunctionRegistry;
import com.hp.hpl.jena.sparql.util.Context;

public class TransformPropertyFunction
extends TransformCopy {
    private final Context context;
    private final boolean doingMagicProperties;
    private final PropertyFunctionRegistry registry;

    public TransformPropertyFunction(Context context) {
        this.context = context;
        this.doingMagicProperties = context.isTrue(ARQ.enablePropertyFunctions);
        this.registry = PropertyFunctionRegistry.chooseRegistry(context);
    }

    @Override
    public Op transform(OpTriple opTriple) {
        if (!this.doingMagicProperties) {
            return opTriple;
        }
        Op x = this.transform(opTriple.asBGP());
        if (!(x instanceof OpBGP)) {
            return x;
        }
        if (opTriple.equivalent((OpBGP)x)) {
            return opTriple;
        }
        return x;
    }

    @Override
    public Op transform(OpBGP opBGP) {
        if (!this.doingMagicProperties) {
            return opBGP;
        }
        return PropertyFunctionGenerator.buildPropertyFunctions(this.registry, opBGP, this.context);
    }
}

