/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.E_Function;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprFunctionN;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.util.Context;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class E_Call
extends ExprFunctionN {
    private static final String symbol = "call";
    private Map<String, Expr> functionCache = new HashMap<String, Expr>();
    private Expr identExpr;
    private List<Expr> argExprs;

    public E_Call(ExprList args) {
        this(symbol, args);
    }

    protected E_Call(String sym2, ExprList args) {
        super(sym2, args);
        if (args.size() == 0) {
            this.identExpr = null;
        } else {
            this.identExpr = args.get(0);
            this.argExprs = args.getList().subList(1, args.size());
        }
    }

    @Override
    public NodeValue evalSpecial(Binding binding, FunctionEnv env) {
        if (this.identExpr == null) {
            throw new ExprEvalException("CALL() has no arguments");
        }
        NodeValue func = this.identExpr.eval(binding, env);
        if (func == null) {
            throw new ExprEvalException("CALL: Function identifier unbound");
        }
        if (func.isIRI()) {
            Expr e2 = this.buildFunction(func.getNode().getURI(), this.argExprs, env.getContext());
            if (e2 == null) {
                throw new ExprEvalException("CALL: Function identifier <" + func.getNode().getURI() + "> does not identify a known function");
            }
            return e2.eval(binding, env);
        }
        throw new ExprEvalException("CALL: Function identifier not an IRI");
    }

    @Override
    public Expr copy(ExprList newArgs) {
        return new E_Call(newArgs);
    }

    @Override
    public NodeValue eval(List<NodeValue> args, FunctionEnv env) {
        NodeValue func = args.get(0);
        if (func == null) {
            throw new ExprEvalException("CALL: Function identifier unbound");
        }
        if (func.isIRI()) {
            ExprList a = new ExprList();
            for (int i = 1; i < args.size(); ++i) {
                a.add(args.get(i));
            }
            E_Function e2 = new E_Function(func.getNode().getURI(), a);
            return e2.eval((Binding)null, env);
        }
        throw new ExprEvalException("CALL: Function identifier not an IRI");
    }

    @Override
    public NodeValue eval(List<NodeValue> args) {
        throw new ARQInternalErrorException();
    }

    private Expr buildFunction(String functionIRI, List<Expr> args, Context cxt) {
        if (this.functionCache.containsKey(functionIRI)) {
            return this.functionCache.get(functionIRI);
        }
        try {
            E_Function e2 = new E_Function(functionIRI, new ExprList(args));
            e2.buildFunction(cxt);
            this.functionCache.put(functionIRI, e2);
            return e2;
        }
        catch (Throwable e3) {
            this.functionCache.put(functionIRI, null);
            return null;
        }
    }
}

