/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.rdf.model.impl.StmtIteratorImpl;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorResourceClosing;
import org.apache.jena.atlas.iterator.Transform;
import org.apache.jena.atlas.lib.Closeable;

public class ModelUtils {
    public static RDFNode convertGraphNodeToRDFNode(Node n, Model model) {
        if (n.isVariable()) {
            throw new QueryException("Variable: " + n);
        }
        if (model != null) {
            return model.asRDFNode(n);
        }
        if (n.isLiteral()) {
            return new LiteralImpl(n, null);
        }
        if (n.isURI() || n.isBlank()) {
            return new ResourceImpl(n, null);
        }
        throw new ARQInternalErrorException("Unknown node type for node: " + n);
    }

    public static Statement tripleToStatement(Model model, Triple t) {
        Node oNode;
        Node pNode;
        if (model == null) {
            throw new ARQInternalErrorException("Attempt to create statement with null model");
        }
        Node sNode = t.getSubject();
        if (!ModelUtils.isValidAsStatement(sNode, pNode = t.getPredicate(), oNode = t.getObject())) {
            return null;
        }
        return model.asStatement(t);
    }

    public static boolean isValidAsStatement(Node s, Node p, Node o) {
        if (s.isLiteral() || s.isVariable()) {
            return false;
        }
        if (!p.isURI()) {
            return false;
        }
        return !o.isVariable();
    }

    public static StmtIterator triplesToStatements(final Iterator<Triple> it, final Model refModel) {
        return new StmtIteratorImpl(Iter.map(it, new Transform<Triple, Statement>(){

            @Override
            public Statement convert(Triple item) {
                return refModel.asStatement(item);
            }
        })){

            @Override
            public void close() {
                if (it instanceof ClosableIterator) {
                    ((ClosableIterator)it).close();
                } else {
                    Iter.close(it);
                }
            }
        };
    }

    public static Iterator<Triple> statementsToTriples(final Iterator<Statement> it) {
        return new IteratorResourceClosing<Triple>(Iter.map(it, new Transform<Statement, Triple>(){

            @Override
            public Triple convert(Statement item) {
                return item.asTriple();
            }
        }), new Closeable(){

            @Override
            public void close() {
                if (it instanceof ClosableIterator) {
                    ((ClosableIterator)it).close();
                } else {
                    Iter.close(it);
                }
            }
        });
    }
}

