/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.Arrays;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.RegularSequenceChecker;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.CopyOptions;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.InScopeNamespaces;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.tiny.TinyElementImpl;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public final class ComplexContentOutputter
extends SequenceReceiver {
    private Receiver nextReceiver;
    private NodeName pendingStartTag = null;
    private int level = -1;
    private boolean[] currentLevelIsDocument = new boolean[20];
    private InScopeNamespaces[] copyNamespacesStack = new InScopeNamespaces[20];
    private Boolean elementIsInNullNamespace;
    private NodeName[] pendingAttCode = new NodeName[20];
    private SimpleType[] pendingAttType = new SimpleType[20];
    private String[] pendingAttValue = new String[20];
    private Location[] pendingAttLocation = new Location[20];
    private int[] pendingAttProp = new int[20];
    private int pendingAttListSize = 0;
    private NamespaceBinding[] pendingNSList = new NamespaceBinding[20];
    private int pendingNSListSize = 0;
    private SchemaType currentSimpleType = null;
    private int startElementProperties;
    private Location startElementLocationId = ExplicitLocation.UNKNOWN_LOCATION;
    private boolean declaresDefaultNamespace;
    private int hostLanguage = 50;
    private RegularSequenceChecker.State state = RegularSequenceChecker.State.Initial;

    public ComplexContentOutputter(Receiver next) {
        super(next.getPipelineConfiguration());
        this.setReceiver(next);
        this.setHostLanguage(next.getPipelineConfiguration().getHostLanguage());
    }

    public static Receiver makeComplexContentReceiver(Receiver receiver, ParseOptions options) {
        boolean validate;
        String systemId = receiver.getSystemId();
        boolean bl = validate = options != null && options.getSchemaValidationMode() != 3;
        if (receiver instanceof ComplexContentOutputter && !validate) {
            return receiver;
        }
        if (validate) {
            Configuration config = receiver.getPipelineConfiguration().getConfiguration();
            receiver = config.getDocumentValidator(receiver, systemId, options, null);
        }
        NamespaceReducer ne = new NamespaceReducer(receiver);
        ne.setSystemId(receiver.getSystemId());
        receiver = ne;
        receiver = new ComplexContentOutputter(ne);
        receiver.setSystemId(systemId);
        return receiver;
    }

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        if (this.pipelineConfiguration != pipe) {
            this.pipelineConfiguration = pipe;
            if (this.nextReceiver != null) {
                this.nextReceiver.setPipelineConfiguration(pipe);
            }
        }
    }

    @Override
    public void setSystemId(String systemId) {
        super.setSystemId(systemId);
        this.nextReceiver.setSystemId(systemId);
    }

    public void setHostLanguage(int language) {
        this.hostLanguage = language;
    }

    public void setReceiver(Receiver receiver) {
        this.nextReceiver = receiver;
    }

    public Receiver getReceiver() {
        return this.nextReceiver;
    }

    @Override
    public void open() throws XPathException {
        this.nextReceiver.open();
        this.previousAtomic = false;
        this.state = RegularSequenceChecker.State.Open;
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        ++this.level;
        if (this.level == 0) {
            this.nextReceiver.startDocument(properties);
        } else if (this.state == RegularSequenceChecker.State.StartTag) {
            this.startContent();
        }
        this.previousAtomic = false;
        if (this.currentLevelIsDocument.length < this.level + 1) {
            this.currentLevelIsDocument = Arrays.copyOf(this.currentLevelIsDocument, this.level * 2);
        }
        this.currentLevelIsDocument[this.level] = true;
        this.state = RegularSequenceChecker.State.Content;
    }

    @Override
    public void endDocument() throws XPathException {
        if (this.level == 0) {
            this.nextReceiver.endDocument();
        }
        this.previousAtomic = false;
        --this.level;
        this.state = this.level < 0 ? RegularSequenceChecker.State.Open : RegularSequenceChecker.State.Content;
    }

    @Override
    public void setUnparsedEntity(String name, String systemID, String publicID) throws XPathException {
        this.nextReceiver.setUnparsedEntity(name, systemID, publicID);
    }

    @Override
    public void characters(CharSequence s, Location locationId, int properties) throws XPathException {
        if (this.level >= 0) {
            this.previousAtomic = false;
            if (s == null) {
                return;
            }
            int len = s.length();
            if (len == 0) {
                return;
            }
            if (this.state == RegularSequenceChecker.State.StartTag) {
                this.startContent();
            }
        }
        this.nextReceiver.characters(s, locationId, properties);
    }

    @Override
    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
        ++this.level;
        if (this.state == RegularSequenceChecker.State.StartTag) {
            this.startContent();
        }
        this.startElementProperties = properties;
        this.startElementLocationId = location.saveLocation();
        this.pendingAttListSize = 0;
        this.pendingNSListSize = 0;
        this.pendingStartTag = elemName;
        this.elementIsInNullNamespace = null;
        this.declaresDefaultNamespace = false;
        this.currentSimpleType = typeCode;
        this.previousAtomic = false;
        if (this.currentLevelIsDocument.length < this.level + 1) {
            this.currentLevelIsDocument = Arrays.copyOf(this.currentLevelIsDocument, this.level * 2);
        }
        if (this.copyNamespacesStack.length < this.level + 1) {
            this.copyNamespacesStack = Arrays.copyOf(this.copyNamespacesStack, this.level * 2);
        }
        this.currentLevelIsDocument[this.level] = false;
        this.state = RegularSequenceChecker.State.StartTag;
    }

    @Override
    public void namespace(NamespaceBindingSet nsBindings, int properties) throws XPathException {
        if (nsBindings instanceof InScopeNamespaces) {
            this.copyNamespacesStack[this.level] = (InScopeNamespaces)nsBindings;
            if (this.level > 0 && this.copyNamespacesStack[this.level - 1] != null && this.copyNamespacesStack[this.level - 1].getElement().equals(((InScopeNamespaces)nsBindings).getElement())) {
                return;
            }
        }
        for (NamespaceBinding ns : nsBindings) {
            if (this.state != RegularSequenceChecker.State.StartTag) {
                throw NoOpenStartTagException.makeNoOpenStartTagException(13, ns.getPrefix(), this.hostLanguage, this.currentLevelIsDocument[this.level], this.startElementLocationId);
            }
            boolean rejectDuplicates = (properties & 0x20) != 0;
            for (int i = 0; i < this.pendingNSListSize; ++i) {
                if (!ns.getPrefix().equals(this.pendingNSList[i].getPrefix())) continue;
                if (ns.getURI().equals(this.pendingNSList[i].getURI())) {
                    return;
                }
                if (this.pendingNSList[i].isDefaultUndeclaration() || ns.isDefaultUndeclaration()) {
                    this.pendingNSList[i] = ns;
                    continue;
                }
                if (rejectDuplicates) {
                    String prefix = ns.getPrefix();
                    String uri1 = ns.getURI();
                    String uri2 = this.pendingNSList[i].getURI();
                    XPathException err = new XPathException("Cannot create two namespace nodes with the same prefix mapped to different URIs (prefix=" + (prefix.isEmpty() ? "\"\"" : prefix) + ", URI=" + (uri1.isEmpty() ? "\"\"" : uri1) + ", URI=" + (uri2.isEmpty() ? "\"\"" : uri2) + ")");
                    err.setErrorCode(this.hostLanguage == 50 ? "XTDE0430" : "XQDY0102");
                    throw err;
                }
                return;
            }
            if (ns.getPrefix().isEmpty() && !ns.getURI().isEmpty()) {
                this.declaresDefaultNamespace = true;
                if (this.elementIsInNullNamespace == null) {
                    this.elementIsInNullNamespace = this.pendingStartTag.hasURI("");
                }
                if (this.elementIsInNullNamespace.booleanValue()) {
                    XPathException err = new XPathException("Cannot output a namespace node for the default namespace when the element is in no namespace");
                    err.setErrorCode(this.hostLanguage == 50 ? "XTDE0440" : "XQDY0102");
                    throw err;
                }
            }
            if (this.pendingNSListSize + 1 > this.pendingNSList.length) {
                this.pendingNSList = Arrays.copyOf(this.pendingNSList, this.pendingNSListSize * 2);
            }
            this.pendingNSList[this.pendingNSListSize++] = ns;
            this.previousAtomic = false;
        }
    }

    @Override
    public void attribute(NodeName attName, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        if (this.level >= 0 && this.state != RegularSequenceChecker.State.StartTag) {
            NoOpenStartTagException err = NoOpenStartTagException.makeNoOpenStartTagException(2, attName.getDisplayName(), this.hostLanguage, this.currentLevelIsDocument[this.level], this.startElementLocationId);
            err.setLocator(locationId);
            throw err;
        }
        if (this.level >= 0 && (properties & 0x100000) == 0) {
            for (int a = 0; a < this.pendingAttListSize; ++a) {
                if (!this.pendingAttCode[a].equals(attName)) continue;
                if (this.hostLanguage == 50) {
                    this.pendingAttType[a] = typeCode;
                    this.pendingAttValue[a] = value.toString();
                    this.pendingAttLocation[a] = locationId;
                    this.pendingAttProp[a] = properties;
                    return;
                }
                XPathException err = new XPathException("Cannot create an element having two attributes with the same name: " + Err.wrap(attName.getDisplayName(), 2));
                err.setErrorCode("XQDY0025");
                throw err;
            }
        }
        if (this.level == 0 && !typeCode.equals(BuiltInAtomicType.UNTYPED_ATOMIC) && this.currentLevelIsDocument[0] && typeCode.isNamespaceSensitive()) {
            XPathException err = new XPathException("Cannot copy attributes whose type is namespace-sensitive (QName or NOTATION): " + Err.wrap(attName.getDisplayName(), 2));
            err.setErrorCode(this.hostLanguage == 50 ? "XTTE0950" : "XQTY0086");
            throw err;
        }
        if (this.level < 0) {
            this.nextReceiver.attribute(attName, typeCode, value, locationId, properties);
        }
        if (this.pendingAttListSize >= this.pendingAttCode.length) {
            this.pendingAttCode = Arrays.copyOf(this.pendingAttCode, this.pendingAttListSize * 2);
            this.pendingAttType = Arrays.copyOf(this.pendingAttType, this.pendingAttListSize * 2);
            this.pendingAttValue = Arrays.copyOf(this.pendingAttValue, this.pendingAttListSize * 2);
            this.pendingAttLocation = Arrays.copyOf(this.pendingAttLocation, this.pendingAttListSize * 2);
            this.pendingAttProp = Arrays.copyOf(this.pendingAttProp, this.pendingAttListSize * 2);
        }
        this.pendingAttCode[this.pendingAttListSize] = attName;
        this.pendingAttType[this.pendingAttListSize] = typeCode;
        this.pendingAttValue[this.pendingAttListSize] = value.toString();
        this.pendingAttLocation[this.pendingAttListSize] = locationId;
        this.pendingAttProp[this.pendingAttListSize] = properties;
        ++this.pendingAttListSize;
        this.previousAtomic = false;
    }

    private NodeName checkProposedPrefix(NodeName nodeName, int seq2) throws XPathException {
        NamespaceBinding binding = nodeName.getNamespaceBinding();
        String nsprefix = binding.getPrefix();
        for (int i = 0; i < this.pendingNSListSize; ++i) {
            if (!nsprefix.equals(this.pendingNSList[i].getPrefix())) continue;
            if (binding.getURI().equals(this.pendingNSList[i].getURI())) {
                return nodeName;
            }
            String prefix = this.getSubstitutePrefix(binding, seq2);
            FingerprintedQName newName = new FingerprintedQName(prefix, nodeName.getURI(), nodeName.getLocalPart());
            this.namespace(newName.getNamespaceBinding(), 0);
            return newName;
        }
        if (seq2 > 0 && nsprefix.isEmpty()) {
            String prefix = this.getSubstitutePrefix(binding, seq2);
            FingerprintedQName newName = new FingerprintedQName(prefix, nodeName.getURI(), nodeName.getLocalPart());
            this.namespace(newName.getNamespaceBinding(), 0);
            return newName;
        }
        this.namespace(binding, 0);
        return nodeName;
    }

    private String getSubstitutePrefix(NamespaceBinding nscode, int seq2) {
        if (nscode.getURI().equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        return nscode.getPrefix() + '_' + seq2;
    }

    @Override
    public void endElement() throws XPathException {
        if (this.state == RegularSequenceChecker.State.StartTag) {
            this.startContent();
        } else {
            this.pendingStartTag = null;
        }
        this.nextReceiver.endElement();
        --this.level;
        this.previousAtomic = false;
        this.state = this.level < 0 ? RegularSequenceChecker.State.Open : RegularSequenceChecker.State.Content;
    }

    @Override
    public void comment(CharSequence comment, Location locationId, int properties) throws XPathException {
        if (this.level >= 0) {
            if (this.state == RegularSequenceChecker.State.StartTag) {
                this.startContent();
            }
            this.previousAtomic = false;
        }
        this.nextReceiver.comment(comment, locationId, properties);
    }

    @Override
    public void processingInstruction(String target, CharSequence data, Location locationId, int properties) throws XPathException {
        if (this.level >= 0) {
            if (this.state == RegularSequenceChecker.State.StartTag) {
                this.startContent();
            }
            this.previousAtomic = false;
        }
        this.nextReceiver.processingInstruction(target, data, locationId, properties);
    }

    @Override
    public void append(Item item, Location locationId, int copyNamespaces) throws XPathException {
        if (this.level >= 0) {
            this.decompose(item, locationId, copyNamespaces);
        } else {
            this.nextReceiver.append(item, locationId, copyNamespaces);
        }
    }

    @Override
    public void close() throws XPathException {
        this.nextReceiver.close();
        this.previousAtomic = false;
        this.state = RegularSequenceChecker.State.Final;
    }

    @Override
    public void startContent() throws XPathException {
        int a;
        if (this.state != RegularSequenceChecker.State.StartTag) {
            return;
        }
        NodeName elcode = this.checkProposedPrefix(this.pendingStartTag, 0);
        int props = this.startElementProperties | 0x40;
        this.nextReceiver.startElement(elcode, this.currentSimpleType, this.startElementLocationId, props);
        for (a = 0; a < this.pendingAttListSize; ++a) {
            NodeName attcode = this.pendingAttCode[a];
            if (attcode.hasURI("")) continue;
            this.pendingAttCode[a] = attcode = this.checkProposedPrefix(attcode, a + 1);
        }
        for (int n = 0; n < this.pendingNSListSize; ++n) {
            this.nextReceiver.namespace(this.pendingNSList[n], 0);
        }
        for (a = 0; a < this.pendingAttListSize; ++a) {
            this.nextReceiver.attribute(this.pendingAttCode[a], this.pendingAttType[a], this.pendingAttValue[a], this.pendingAttLocation[a], this.pendingAttProp[a]);
        }
        this.nextReceiver.startContent();
        this.pendingAttListSize = 0;
        this.pendingNSListSize = 0;
        this.previousAtomic = false;
        this.state = RegularSequenceChecker.State.Content;
    }

    @Override
    public boolean usesTypeAnnotations() {
        return this.nextReceiver.usesTypeAnnotations();
    }

    public boolean isReadyForGrafting() {
        Receiver r2 = this.getReceiver();
        if (r2 instanceof NamespaceReducer && !((NamespaceReducer)r2).isDisinheritingNamespaces()) {
            Receiver r3 = ((NamespaceReducer)r2).getNextReceiver();
            return r3 instanceof TinyBuilder && (this.state == RegularSequenceChecker.State.StartTag && (this.startElementProperties & 0x80) == 0 || ((TinyBuilder)r3).isPositionedAtElement());
        }
        return false;
    }

    public void graftElementNode(TinyElementImpl elementNode, int copyOptions) throws XPathException {
        NamespaceReducer r2 = (NamespaceReducer)this.getReceiver();
        TinyBuilder target = (TinyBuilder)r2.getNextReceiver();
        this.beforeBulkCopy();
        boolean copyNamespaces = CopyOptions.includes(copyOptions, 2);
        target.graft(elementNode, copyNamespaces);
        this.afterBulkCopy();
    }

    public boolean isReadyForBulkCopy() {
        Receiver r2 = this.getReceiver();
        if (r2 instanceof NamespaceReducer && !((NamespaceReducer)r2).isDisinheritingNamespaces()) {
            Receiver r3 = ((NamespaceReducer)r2).getNextReceiver();
            return r3 instanceof TinyBuilder && (this.state == RegularSequenceChecker.State.StartTag && (this.startElementProperties & 0x80) == 0 || ((TinyBuilder)r3).isPositionedAtElement());
        }
        return false;
    }

    public void bulkCopyElementNode(TinyElementImpl elementNode, int copyOptions) throws XPathException {
        NamespaceReducer r2 = (NamespaceReducer)this.getReceiver();
        TinyBuilder target = (TinyBuilder)r2.getNextReceiver();
        this.beforeBulkCopy();
        boolean copyNamespaces = CopyOptions.includes(copyOptions, 2);
        target.bulkCopy(elementNode, copyNamespaces);
        this.afterBulkCopy();
    }

    private void beforeBulkCopy() throws XPathException {
        ++this.level;
        if (this.state == RegularSequenceChecker.State.StartTag) {
            this.startContent();
        }
    }

    private void afterBulkCopy() {
        --this.level;
        this.previousAtomic = false;
    }
}

