/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.LicenseException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.value.Whitespace;

public class XSLImportSchema
extends StyleElement {
    @Override
    public boolean isDeclaration() {
        return true;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String namespace2 = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("schema-location")) continue;
            if (f.equals("namespace")) {
                namespace2 = Whitespace.trim(atts.getValue(a));
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if ("".equals(namespace2)) {
            this.compileError("The zero-length string is not a valid namespace URI. For a schema with no namespace, omit the namespace attribute");
        }
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        this.checkTopLevel("XTSE0010", false);
    }

    @Override
    public void index(ComponentDeclaration decl, PrincipalStylesheetModule top) throws XPathException {
    }

    public void readSchema() throws XPathException {
        try {
            NodeInfo child;
            String schemaLoc = Whitespace.trim(this.getAttributeValue("", "schema-location"));
            String namespace2 = Whitespace.trim(this.getAttributeValue("", "namespace"));
            namespace2 = namespace2 == null ? "" : namespace2.trim();
            Configuration config = this.getConfiguration();
            try {
                config.checkLicensedFeature(2, "xsl:import-schema", this.getPackageData().getLocalLicenseId());
            }
            catch (LicenseException err) {
                XPathException xe = new XPathException(err);
                xe.setErrorCode("XTSE1650");
                xe.setLocator(this);
                throw xe;
            }
            AxisIterator kids = this.iterateAxis((byte)3);
            NodeImpl inlineSchema = null;
            while ((child = kids.next()) != null) {
                if (inlineSchema != null) {
                    this.compileError(this.getDisplayName() + " must not have more than one child element");
                }
                if ((inlineSchema = (NodeImpl)child).getFingerprint() != 617) {
                    this.compileError("The only child element permitted for " + this.getDisplayName() + " is xs:schema");
                }
                if (schemaLoc != null) {
                    this.compileError("The schema-location attribute must be absent if an inline schema is present", "XTSE0215");
                }
                if (namespace2.isEmpty() && (namespace2 = inlineSchema.getAttributeValue("", "targetNamespace")) == null) {
                    namespace2 = "";
                }
                namespace2 = config.readInlineSchema(inlineSchema, namespace2, this.getCompilation().getCompilerInfo().getErrorListener());
                this.getPrincipalStylesheetModule().addImportedSchema(namespace2);
            }
            if (inlineSchema != null) {
                return;
            }
            if (namespace2.equals("http://www.w3.org/XML/1998/namespace") || namespace2.equals("http://www.w3.org/2005/xpath-functions") || namespace2.equals("http://www.w3.org/2001/XMLSchema-instance")) {
                config.addSchemaForBuiltInNamespace(namespace2);
                this.getPrincipalStylesheetModule().addImportedSchema(namespace2);
                return;
            }
            boolean namespaceKnown = config.isSchemaAvailable(namespace2);
            if (schemaLoc == null && !namespaceKnown) {
                this.compileWarning("No schema for this namespace is known, and no schema-location was supplied, so no schema has been imported", "SXWN9006");
                return;
            }
            if (namespaceKnown && !config.getBooleanProperty(Feature.MULTIPLE_SCHEMA_IMPORTS) && schemaLoc != null) {
                this.compileWarning("The schema document at " + schemaLoc + " is ignored because a schema for this namespace is already loaded", "SXWN9006");
            }
            if (!namespaceKnown) {
                PipelineConfiguration pipe = config.makePipelineConfiguration();
                namespace2 = config.readSchema(pipe, this.getBaseURI(), schemaLoc, namespace2);
            }
            this.getPrincipalStylesheetModule().addImportedSchema(namespace2);
        }
        catch (SchemaException err) {
            String errorCode = err.getErrorCodeLocalPart() == null ? "XTSE0220" : err.getErrorCodeLocalPart();
            this.compileError(err.getMessage(), errorCode);
        }
    }

    @Override
    public void compileDeclaration(Compilation compilation, ComponentDeclaration decl) throws XPathException {
    }
}

