/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.util;

import java.util.Arrays;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SimpleType;
import org.xml.sax.Attributes;

public class AttributeCollectionImpl
implements Attributes,
AttributeCollection {
    private Configuration config;
    private NodeName[] names = null;
    private String[] values = null;
    private Location[] locations = null;
    private int[] props = null;
    private int used = 0;
    private SimpleType[] types = null;
    public static AttributeCollectionImpl EMPTY_ATTRIBUTE_COLLECTION = new AttributeCollectionImpl(null);

    public AttributeCollectionImpl(Configuration config) {
        this.config = config;
        this.used = 0;
    }

    public static AttributeCollectionImpl copy(AttributeCollectionImpl atts) {
        if (atts.getLength() == 0) {
            return EMPTY_ATTRIBUTE_COLLECTION;
        }
        AttributeCollectionImpl t = new AttributeCollectionImpl(atts.config);
        t.used = atts.used;
        t.names = new NodeName[atts.used];
        t.values = new String[atts.used];
        t.props = new int[atts.used];
        t.locations = new Location[atts.used];
        System.arraycopy(atts.names, 0, t.names, 0, atts.used);
        System.arraycopy(atts.values, 0, t.values, 0, atts.used);
        System.arraycopy(atts.props, 0, t.props, 0, atts.used);
        System.arraycopy(atts.locations, 0, t.locations, 0, atts.used);
        if (atts.types != null) {
            t.types = new SimpleType[atts.used];
            System.arraycopy(atts.types, 0, t.types, 0, atts.used);
        }
        return t;
    }

    public void addAttribute(NodeName nodeName, SimpleType type, String value, Location locationId, int properties) {
        if (this.values == null) {
            this.names = new NodeName[5];
            this.values = new String[5];
            this.props = new int[5];
            this.locations = new Location[5];
            if (!type.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                this.types = new SimpleType[5];
            }
            this.used = 0;
        }
        if (this.values.length == this.used) {
            int newsize = this.used == 0 ? 5 : this.used * 2;
            this.names = Arrays.copyOf(this.names, newsize);
            this.values = Arrays.copyOf(this.values, newsize);
            this.props = Arrays.copyOf(this.props, newsize);
            this.locations = Arrays.copyOf(this.locations, newsize);
            if (this.types != null) {
                this.types = Arrays.copyOf(this.types, newsize);
            }
        }
        int n = this.used;
        this.names[n] = nodeName;
        this.props[n] = properties;
        this.locations[n] = locationId.saveLocation();
        this.setTypeAnnotation(n, type);
        this.values[this.used++] = value;
    }

    public void setAttribute(int index, NodeName nodeName, SimpleType type, String value, Location locationId, int properties) {
        this.names[index] = nodeName;
        this.props[index] = properties;
        this.locations[index] = locationId;
        this.setTypeAnnotation(index, type);
        this.values[index] = value;
    }

    public void clear() {
        this.used = 0;
    }

    public void compact() {
        if (this.used == 0) {
            this.props = null;
            this.values = null;
        } else if (this.values != null && this.values.length > this.used) {
            this.values = Arrays.copyOf(this.values, this.used);
            this.props = Arrays.copyOf(this.props, this.used);
            this.names = Arrays.copyOf(this.names, this.used);
            this.locations = Arrays.copyOf(this.locations, this.used);
            if (this.types != null) {
                this.types = Arrays.copyOf(this.types, this.used);
            }
        }
    }

    @Override
    public int getLength() {
        return this.values == null ? 0 : this.used;
    }

    @Override
    public int getFingerprint(int index) {
        if (this.names == null) {
            return -1;
        }
        if (index < 0 || index >= this.used || this.names[index] == null) {
            return -1;
        }
        return this.names[index].obtainFingerprint(this.config.getNamePool());
    }

    @Override
    public NodeName getNodeName(int index) {
        if (this.names == null) {
            return null;
        }
        if (index < 0 || index >= this.used) {
            return null;
        }
        return this.names[index];
    }

    @Override
    public SimpleType getTypeAnnotation(int index) {
        if (this.types == null) {
            return BuiltInAtomicType.UNTYPED_ATOMIC;
        }
        if (index < 0 || index >= this.used) {
            return BuiltInAtomicType.UNTYPED_ATOMIC;
        }
        return this.types[index];
    }

    @Override
    public Location getLocation(int index) {
        if (this.locations == null) {
            return ExplicitLocation.UNKNOWN_LOCATION;
        }
        if (index < 0 || index >= this.used) {
            return ExplicitLocation.UNKNOWN_LOCATION;
        }
        return this.locations[index];
    }

    @Override
    public String getSystemId(int index) {
        return this.getLocation(index).getSystemId();
    }

    @Override
    public int getLineNumber(int index) {
        return this.getLocation(index).getLineNumber();
    }

    @Override
    public int getProperties(int index) {
        if (this.props == null) {
            return -1;
        }
        if (index < 0 || index >= this.used) {
            return -1;
        }
        return this.props[index];
    }

    @Override
    public String getPrefix(int index) {
        if (this.names == null) {
            return null;
        }
        if (index < 0 || index >= this.used) {
            return null;
        }
        return this.names[index].getPrefix();
    }

    @Override
    public String getQName(int index) {
        if (this.names == null) {
            return null;
        }
        if (index < 0 || index >= this.used) {
            return null;
        }
        return this.names[index].getDisplayName();
    }

    @Override
    public String getLocalName(int index) {
        if (this.names == null) {
            return null;
        }
        if (index < 0 || index >= this.used) {
            return null;
        }
        return this.names[index].getLocalPart();
    }

    @Override
    public String getURI(int index) {
        if (this.names == null) {
            return null;
        }
        if (index < 0 || index >= this.used) {
            return null;
        }
        return this.names[index].getURI();
    }

    @Override
    public String getType(int index) {
        int typeCode = this.getTypeAnnotation(index).getFingerprint();
        switch (typeCode) {
            case 560: {
                return "ID";
            }
            case 561: {
                return "IDREF";
            }
            case 556: {
                return "NMTOKEN";
            }
            case 563: {
                return "ENTITY";
            }
            case 562: {
                return "IDREFS";
            }
            case 557: {
                return "NMTOKENS";
            }
            case 564: {
                return "ENTITIES";
            }
        }
        return "CDATA";
    }

    @Override
    public String getType(String uri, String localname2) {
        int index = this.findByName(uri, localname2);
        return index < 0 ? null : this.getType(index);
    }

    @Override
    public String getValue(int index) {
        if (this.values == null) {
            return null;
        }
        if (index < 0 || index >= this.used) {
            return null;
        }
        return this.values[index];
    }

    @Override
    public String getValue(String uri, String localname2) {
        int index = this.findByName(uri, localname2);
        return index < 0 ? null : this.getValue(index);
    }

    @Override
    public String getValueByFingerprint(int fingerprint) {
        int index = this.findByFingerprint(fingerprint);
        return index < 0 ? null : this.getValue(index);
    }

    @Override
    public int getIndex(String qname) {
        String[] parts;
        if (this.names == null) {
            return -1;
        }
        if (qname.indexOf(58) < 0) {
            return this.findByName("", qname);
        }
        try {
            parts = NameChecker.getQNameParts(qname);
        }
        catch (QNameException err) {
            return -1;
        }
        String prefix = parts[0];
        if (prefix.isEmpty()) {
            return this.findByName("", qname);
        }
        String localName = parts[1];
        for (int i = 0; i < this.used; ++i) {
            if (this.names[i] == null) continue;
            String lname = this.names[i].getLocalPart();
            String ppref = this.names[i].getPrefix();
            if (!localName.equals(lname) || !prefix.equals(ppref)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getIndex(String uri, String localname2) {
        return this.findByName(uri, localname2);
    }

    @Override
    public int getIndexByFingerprint(int fingerprint) {
        return this.findByFingerprint(fingerprint);
    }

    @Override
    public String getType(String name) {
        int index = this.getIndex(name);
        return this.getType(index);
    }

    @Override
    public String getValue(String name) {
        int index = this.getIndex(name);
        return this.getValue(index);
    }

    public boolean hasAttributeInNamespace(String uri) {
        if (this.names == null || this.config == null) {
            return false;
        }
        for (int i = 0; i < this.used; ++i) {
            if (this.names[i] == null || !this.names[i].hasURI(uri)) continue;
            return true;
        }
        return false;
    }

    private int findByName(String uri, String localName) {
        if (this.names == null || this.config == null) {
            return -1;
        }
        for (int i = 0; i < this.used; ++i) {
            if (this.names[i] == null || !this.names[i].hasURI(uri) || !localName.equals(this.names[i].getLocalPart())) continue;
            return i;
        }
        return -1;
    }

    private int findByFingerprint(int fingerprint) {
        if (this.names == null || this.config == null) {
            return -1;
        }
        NamePool pool = this.config.getNamePool();
        for (int i = 0; i < this.used; ++i) {
            NodeName nn = this.names[i];
            if (nn == null || !(nn.hasFingerprint() ? nn.getFingerprint() == fingerprint : nn.hasURI(pool.getURI(fingerprint)) && nn.getLocalPart().equals(pool.getLocalName(fingerprint)))) continue;
            return i;
        }
        return -1;
    }

    public int findByNodeName(NodeName nodeName) {
        if (this.props == null || this.config == null) {
            return -1;
        }
        if (nodeName.hasFingerprint()) {
            return this.findByFingerprint(nodeName.getFingerprint());
        }
        return this.findByName(nodeName.getURI(), nodeName.getLocalPart());
    }

    @Override
    public boolean isId(int index) {
        try {
            return !this.isDeleted(index) && (StandardNames.XML_ID_NAME.equals(this.names[index]) || (this.getProperties(index) & 0x800) != 0 || this.getTypeAnnotation(index).isIdType());
        }
        catch (MissingComponentException e2) {
            return false;
        }
    }

    @Override
    public boolean isIdref(int index) {
        try {
            return this.getTypeAnnotation(index).isIdRefType();
        }
        catch (MissingComponentException e2) {
            return false;
        }
    }

    public void removeAttribute(int index) {
        this.names[index] = null;
        this.props[index] = -1;
        this.values[index] = null;
        this.locations[index] = null;
        if (this.types != null) {
            this.types[index] = null;
        }
    }

    public boolean isDeleted(int index) {
        return this.names[index] == null;
    }

    public void renameAttribute(int index, NodeName newName) {
        this.names[index] = newName;
        if (this.types != null) {
            this.types[index] = BuiltInAtomicType.UNTYPED_ATOMIC;
        }
    }

    public void replaceAttribute(int index, CharSequence newValue) {
        this.values[index] = newValue.toString();
    }

    public void setTypeAnnotation(int index, SimpleType type) {
        if (type.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            if (this.types != null) {
                this.types[index] = type;
            }
        } else if (this.types == null) {
            this.types = new SimpleType[this.names.length];
            Arrays.fill(this.types, BuiltInAtomicType.UNTYPED_ATOMIC);
            this.types[index] = type;
        } else {
            this.types[index] = type;
        }
    }

    public void swap(int i, int j) {
        NodeName n = this.names[i];
        this.names[i] = this.names[j];
        this.names[j] = n;
        if (this.types != null) {
            SimpleType s = this.types[i];
            this.types[i] = this.types[j];
            this.types[j] = s;
        }
        String c = this.values[i];
        this.values[i] = this.values[j];
        this.values[j] = c;
        int p = this.props[i];
        this.props[i] = this.props[j];
        this.props[j] = p;
        Location l = this.locations[i];
        this.locations[i] = this.locations[j];
        this.locations[j] = l;
    }
}

