/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.impl;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.pool.BaseObjectPool;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

public class SoftReferenceObjectPool
extends BaseObjectPool
implements ObjectPool {
    private List _pool = new ArrayList();
    private PoolableObjectFactory _factory = null;
    private int _numActive = 0;

    public SoftReferenceObjectPool() {
        this._factory = null;
    }

    public SoftReferenceObjectPool(PoolableObjectFactory factory) {
        this._factory = factory;
    }

    public SoftReferenceObjectPool(PoolableObjectFactory factory, int initSize) throws Exception {
        this._factory = factory;
        if (null != this._factory) {
            for (int i = 0; i < initSize; ++i) {
                Object obj = this._factory.makeObject();
                this._factory.passivateObject(obj);
                this._pool.add(new SoftReference<Object>(obj));
            }
        }
    }

    public synchronized Object borrowObject() throws Exception {
        this.assertOpen();
        Object obj = null;
        while (null == obj) {
            if (this._pool.isEmpty()) {
                if (null == this._factory) {
                    throw new NoSuchElementException();
                }
                obj = this._factory.makeObject();
            } else {
                SoftReference ref = (SoftReference)this._pool.remove(this._pool.size() - 1);
                obj = ref.get();
            }
            if (null != this._factory && null != obj) {
                this._factory.activateObject(obj);
            }
            if (null == this._factory || null == obj || this._factory.validateObject(obj)) continue;
            this._factory.destroyObject(obj);
            obj = null;
        }
        ++this._numActive;
        return obj;
    }

    public synchronized void returnObject(Object obj) throws Exception {
        this.assertOpen();
        boolean success = true;
        if (!this._factory.validateObject(obj)) {
            success = false;
        } else {
            try {
                this._factory.passivateObject(obj);
            }
            catch (Exception e2) {
                success = false;
            }
        }
        boolean shouldDestroy = !success;
        --this._numActive;
        if (success) {
            this._pool.add(new SoftReference<Object>(obj));
        }
        this.notifyAll();
        if (shouldDestroy) {
            try {
                this._factory.destroyObject(obj);
            }
            catch (Exception e3) {
                // empty catch block
            }
        }
    }

    public synchronized void invalidateObject(Object obj) throws Exception {
        this.assertOpen();
        --this._numActive;
        this._factory.destroyObject(obj);
        this.notifyAll();
    }

    public synchronized void addObject() throws Exception {
        this.assertOpen();
        Object obj = this._factory.makeObject();
        ++this._numActive;
        this.returnObject(obj);
    }

    public synchronized int getNumIdle() {
        this.assertOpen();
        return this._pool.size();
    }

    public synchronized int getNumActive() {
        this.assertOpen();
        return this._numActive;
    }

    public synchronized void clear() {
        this.assertOpen();
        if (null != this._factory) {
            Iterator iter = this._pool.iterator();
            while (iter.hasNext()) {
                try {
                    Object obj = ((SoftReference)iter.next()).get();
                    if (null == obj) continue;
                    this._factory.destroyObject(obj);
                }
                catch (Exception exception) {}
            }
        }
        this._pool.clear();
    }

    public synchronized void close() throws Exception {
        this.clear();
        this._pool = null;
        this._factory = null;
        super.close();
    }

    public synchronized void setFactory(PoolableObjectFactory factory) throws IllegalStateException {
        this.assertOpen();
        if (0 < this.getNumActive()) {
            throw new IllegalStateException("Objects are already active");
        }
        this.clear();
        this._factory = factory;
    }
}

