/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle;

import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.maven.BuildFailureException;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ReactorManager;
import org.apache.maven.extension.ExtensionManager;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.lifecycle.mapping.LifecycleMapping;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.monitor.event.EventDispatcher;
import org.apache.maven.plugin.InvalidPluginException;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.lifecycle.Execution;
import org.apache.maven.plugin.lifecycle.Phase;
import org.apache.maven.plugin.version.PluginVersionNotFoundException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DefaultLifecycleExecutor
extends AbstractLogEnabled
implements LifecycleExecutor {
    private PluginManager pluginManager;
    private ExtensionManager extensionManager;
    private List lifecycles;
    private ArtifactHandlerManager artifactHandlerManager;
    private List defaultReports;
    private Map phaseToLifecycleMap;

    public void execute(MavenSession session, ReactorManager rm, EventDispatcher dispatcher) throws BuildFailureException, LifecycleExecutionException {
        String goal;
        MavenProject rootProject = rm.getTopLevelProject();
        List<String> goals = session.getGoals();
        if (goals.isEmpty() && rootProject != null && (goal = rootProject.getDefaultGoal()) != null) {
            goals = Collections.singletonList(goal);
        }
        if (goals.isEmpty()) {
            throw new BuildFailureException("You must specify at least one goal. Try 'install'");
        }
        List taskSegments = this.segmentTaskListByAggregationNeeds(goals, session, rootProject);
        this.findExtensions(session);
        this.executeTaskSegments(taskSegments, rm, session, rootProject, dispatcher);
    }

    private void findExtensions(MavenSession session) throws LifecycleExecutionException {
        Iterator i = session.getSortedProjects().iterator();
        while (i.hasNext()) {
            MavenProject project = (MavenProject)i.next();
            Iterator j = project.getBuildExtensions().iterator();
            while (j.hasNext()) {
                Extension extension = (Extension)j.next();
                try {
                    this.extensionManager.addExtension(extension, project, session.getLocalRepository());
                }
                catch (PlexusContainerException e2) {
                    throw new LifecycleExecutionException("Unable to initialise extensions", e2);
                }
                catch (ArtifactResolutionException e3) {
                    throw new LifecycleExecutionException(e3.getMessage(), e3);
                }
                catch (ArtifactNotFoundException e4) {
                    throw new LifecycleExecutionException(e4.getMessage(), e4);
                }
            }
            this.extensionManager.registerWagons();
            try {
                Map handlers = this.findArtifactTypeHandlers(project, session.getSettings(), session.getLocalRepository());
                this.artifactHandlerManager.addHandlers(handlers);
            }
            catch (PluginNotFoundException e5) {
                throw new LifecycleExecutionException(e5.getMessage(), e5);
            }
        }
    }

    private void executeTaskSegments(List taskSegments, ReactorManager rm, MavenSession session, MavenProject rootProject, EventDispatcher dispatcher) throws LifecycleExecutionException, BuildFailureException {
        Iterator it = taskSegments.iterator();
        while (it.hasNext()) {
            TaskSegment segment = (TaskSegment)it.next();
            if (segment.aggregate()) {
                if (!rm.isBlackListed(rootProject)) {
                    this.line();
                    this.getLogger().info("Building " + rootProject.getName());
                    this.getLogger().info("  " + segment);
                    this.line();
                    String event = "project-execute";
                    long buildStartTime = System.currentTimeMillis();
                    String target = rootProject.getId() + " ( " + segment + " )";
                    dispatcher.dispatchStart(event, target);
                    Iterator goalIterator = segment.getTasks().iterator();
                    while (goalIterator.hasNext()) {
                        String task = (String)goalIterator.next();
                        this.executeGoalAndHandleFailures(task, session, rootProject, dispatcher, event, rm, buildStartTime, target);
                    }
                    rm.registerBuildSuccess(rootProject, System.currentTimeMillis() - buildStartTime);
                    dispatcher.dispatchEnd(event, target);
                    continue;
                }
                this.line();
                this.getLogger().info("SKIPPING " + rootProject.getName());
                this.getLogger().info("  " + segment);
                this.getLogger().info("This project has been banned from further executions due to previous failures.");
                this.line();
                continue;
            }
            List sortedProjects = session.getSortedProjects();
            Iterator projectIterator = sortedProjects.iterator();
            while (projectIterator.hasNext()) {
                MavenProject currentProject = (MavenProject)projectIterator.next();
                if (!rm.isBlackListed(currentProject)) {
                    this.line();
                    this.getLogger().info("Building " + currentProject.getName());
                    this.getLogger().info("  " + segment);
                    this.line();
                    String event = "project-execute";
                    long buildStartTime = System.currentTimeMillis();
                    String target = currentProject.getId() + " ( " + segment + " )";
                    dispatcher.dispatchStart(event, target);
                    Iterator goalIterator = segment.getTasks().iterator();
                    while (goalIterator.hasNext()) {
                        String task = (String)goalIterator.next();
                        this.executeGoalAndHandleFailures(task, session, currentProject, dispatcher, event, rm, buildStartTime, target);
                    }
                    rm.registerBuildSuccess(currentProject, System.currentTimeMillis() - buildStartTime);
                    dispatcher.dispatchEnd(event, target);
                    continue;
                }
                this.line();
                this.getLogger().info("SKIPPING " + currentProject.getName());
                this.getLogger().info("  " + segment);
                this.getLogger().info("This project has been banned from further executions due to previous failures.");
                this.line();
            }
        }
    }

    private void executeGoalAndHandleFailures(String task, MavenSession session, MavenProject project, EventDispatcher dispatcher, String event, ReactorManager rm, long buildStartTime, String target) throws BuildFailureException, LifecycleExecutionException {
        block4: {
            try {
                this.executeGoal(task, session, project);
            }
            catch (LifecycleExecutionException e2) {
                dispatcher.dispatchError(event, target, e2);
                if (this.handleExecutionFailure(rm, project, e2, task, buildStartTime)) {
                    throw e2;
                }
            }
            catch (BuildFailureException e3) {
                dispatcher.dispatchError(event, target, e3);
                if (!this.handleExecutionFailure(rm, project, e3, task, buildStartTime)) break block4;
                throw e3;
            }
        }
    }

    private boolean handleExecutionFailure(ReactorManager rm, MavenProject project, Exception e2, String task, long buildStartTime) {
        rm.registerBuildFailure(project, e2, task, System.currentTimeMillis() - buildStartTime);
        if ("fail-fast".equals(rm.getFailureBehavior())) {
            return true;
        }
        if ("fail-at-end".equals(rm.getFailureBehavior())) {
            rm.blackList(project);
        }
        return false;
    }

    private List segmentTaskListByAggregationNeeds(List tasks, MavenSession session, MavenProject project) throws LifecycleExecutionException, BuildFailureException {
        ArrayList<TaskSegment> segments = new ArrayList<TaskSegment>();
        if (project != null) {
            TaskSegment currentSegment = null;
            Iterator it = tasks.iterator();
            while (it.hasNext()) {
                String task = (String)it.next();
                if (this.getPhaseToLifecycleMap().containsKey(task)) {
                    if (currentSegment != null && currentSegment.aggregate()) {
                        segments.add(currentSegment);
                        currentSegment = null;
                    }
                    if (currentSegment == null) {
                        currentSegment = new TaskSegment();
                    }
                    currentSegment.add(task);
                    continue;
                }
                MojoDescriptor mojo = null;
                try {
                    mojo = this.getMojoDescriptor(task, session, project, task, true, false);
                }
                catch (PluginNotFoundException e2) {
                    this.getLogger().info("Cannot find mojo descriptor for: '" + task + "' - Treating as non-aggregator.");
                    this.getLogger().debug("", e2);
                }
                if (mojo != null && (mojo.isAggregator() || !mojo.isProjectRequired())) {
                    if (currentSegment != null && !currentSegment.aggregate()) {
                        segments.add(currentSegment);
                        currentSegment = null;
                    }
                    if (currentSegment == null) {
                        currentSegment = new TaskSegment(true);
                    }
                    currentSegment.add(task);
                    continue;
                }
                if (currentSegment != null && currentSegment.aggregate()) {
                    segments.add(currentSegment);
                    currentSegment = null;
                }
                if (currentSegment == null) {
                    currentSegment = new TaskSegment();
                }
                currentSegment.add(task);
            }
            segments.add(currentSegment);
        } else {
            TaskSegment segment = new TaskSegment(false);
            Iterator i = tasks.iterator();
            while (i.hasNext()) {
                segment.add((String)i.next());
            }
            segments.add(segment);
        }
        return segments;
    }

    private void executeGoal(String task, MavenSession session, MavenProject project) throws LifecycleExecutionException, BuildFailureException {
        try {
            Stack forkEntryPoints = new Stack();
            if (this.getPhaseToLifecycleMap().containsKey(task)) {
                Lifecycle lifecycle = this.getLifecycleForPhase(task);
                Map lifecycleMappings = this.constructLifecycleMappings(session, task, project, lifecycle);
                this.executeGoalWithLifecycle(task, forkEntryPoints, session, lifecycleMappings, project, lifecycle);
            } else {
                this.executeStandaloneGoal(task, forkEntryPoints, session, project);
            }
        }
        catch (PluginNotFoundException e2) {
            throw new BuildFailureException("A required plugin was not found: " + e2.getMessage(), e2);
        }
    }

    private void executeGoalWithLifecycle(String task, Stack forkEntryPoints, MavenSession session, Map lifecycleMappings, MavenProject project, Lifecycle lifecycle) throws LifecycleExecutionException, BuildFailureException, PluginNotFoundException {
        List goals = this.processGoalChain(task, lifecycleMappings, lifecycle);
        if (!goals.isEmpty()) {
            this.executeGoals(goals, forkEntryPoints, session, project);
        } else {
            this.getLogger().info("No goals needed for project - skipping");
        }
    }

    private void executeStandaloneGoal(String task, Stack forkEntryPoints, MavenSession session, MavenProject project) throws LifecycleExecutionException, BuildFailureException, PluginNotFoundException {
        MojoDescriptor mojoDescriptor = this.getMojoDescriptor(task, session, project, task, true, false);
        this.executeGoals(Collections.singletonList(new MojoExecution(mojoDescriptor)), forkEntryPoints, session, project);
    }

    private void executeGoals(List goals, Stack forkEntryPoints, MavenSession session, MavenProject project) throws LifecycleExecutionException, BuildFailureException, PluginNotFoundException {
        Iterator i = goals.iterator();
        while (i.hasNext()) {
            MojoExecution mojoExecution = (MojoExecution)i.next();
            MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
            if (mojoDescriptor.getExecutePhase() != null || mojoDescriptor.getExecuteGoal() != null) {
                forkEntryPoints.push(mojoDescriptor);
                this.forkLifecycle(mojoDescriptor, forkEntryPoints, session, project);
                forkEntryPoints.pop();
            }
            if (mojoDescriptor.isRequiresReports()) {
                List reports = this.getReports(project, mojoExecution, session);
                mojoExecution.setReports(reports);
                Iterator j = mojoExecution.getForkedExecutions().iterator();
                while (j.hasNext()) {
                    MojoExecution forkedExecution = (MojoExecution)j.next();
                    MojoDescriptor descriptor = forkedExecution.getMojoDescriptor();
                    if (descriptor.getExecutePhase() == null) continue;
                    forkEntryPoints.push(descriptor);
                    this.forkLifecycle(descriptor, forkEntryPoints, session, project);
                    forkEntryPoints.pop();
                }
            }
            try {
                this.pluginManager.executeMojo(project, mojoExecution, session);
            }
            catch (PluginManagerException e2) {
                throw new LifecycleExecutionException("Internal error in the plugin manager executing goal '" + mojoDescriptor.getId() + "': " + e2.getMessage(), e2);
            }
            catch (ArtifactNotFoundException e3) {
                throw new LifecycleExecutionException(e3.getMessage(), e3);
            }
            catch (InvalidDependencyVersionException e4) {
                throw new LifecycleExecutionException(e4.getMessage(), e4);
            }
            catch (ArtifactResolutionException e5) {
                throw new LifecycleExecutionException(e5.getMessage(), e5);
            }
            catch (MojoFailureException e6) {
                throw new BuildFailureException(e6.getMessage(), e6);
            }
            catch (MojoExecutionException e7) {
                throw new LifecycleExecutionException(e7.getMessage(), e7);
            }
            catch (PluginConfigurationException e8) {
                throw new LifecycleExecutionException(e8.getMessage(), e8);
            }
        }
    }

    private List getReports(MavenProject project, MojoExecution mojoExecution, MavenSession session) throws LifecycleExecutionException, PluginNotFoundException {
        ArrayList<ReportPlugin> reportPlugins = project.getReportPlugins();
        if (project.getModel().getReports() != null) {
            this.getLogger().error("Plugin contains a <reports/> section: this is IGNORED - please use <reporting/> instead.");
        }
        if (project.getReporting() == null || !project.getReporting().isExcludeDefaults()) {
            reportPlugins = reportPlugins == null ? new ArrayList<ReportPlugin>() : new ArrayList(reportPlugins);
            Iterator i = this.defaultReports.iterator();
            while (i.hasNext()) {
                String report = (String)i.next();
                StringTokenizer tok = new StringTokenizer(report, ":");
                if (tok.countTokens() != 2) {
                    this.getLogger().warn("Invalid default report ignored: '" + report + "' (must be groupId:artifactId)");
                    continue;
                }
                String groupId = tok.nextToken();
                String artifactId = tok.nextToken();
                boolean found = false;
                Iterator j = reportPlugins.iterator();
                while (j.hasNext() && !found) {
                    ReportPlugin reportPlugin = (ReportPlugin)j.next();
                    if (!reportPlugin.getGroupId().equals(groupId) || !reportPlugin.getArtifactId().equals(artifactId)) continue;
                    found = true;
                }
                if (found) continue;
                ReportPlugin reportPlugin = new ReportPlugin();
                reportPlugin.setGroupId(groupId);
                reportPlugin.setArtifactId(artifactId);
                reportPlugins.add(reportPlugin);
            }
        }
        ArrayList reports = new ArrayList();
        if (reportPlugins != null) {
            Iterator it = reportPlugins.iterator();
            while (it.hasNext()) {
                ReportPlugin reportPlugin = (ReportPlugin)it.next();
                List reportSets = reportPlugin.getReportSets();
                if (reportSets == null || reportSets.isEmpty()) {
                    reports.addAll(this.getReports(reportPlugin, null, project, session, mojoExecution));
                    continue;
                }
                Iterator j = reportSets.iterator();
                while (j.hasNext()) {
                    ReportSet reportSet = (ReportSet)j.next();
                    reports.addAll(this.getReports(reportPlugin, reportSet, project, session, mojoExecution));
                }
            }
        }
        return reports;
    }

    private List getReports(ReportPlugin reportPlugin, ReportSet reportSet, MavenProject project, MavenSession session, MojoExecution mojoExecution) throws LifecycleExecutionException, PluginNotFoundException {
        PluginDescriptor pluginDescriptor = this.verifyReportPlugin(reportPlugin, project, session);
        ArrayList<MavenReport> reports = new ArrayList<MavenReport>();
        Iterator i = pluginDescriptor.getMojos().iterator();
        while (i.hasNext()) {
            MojoDescriptor mojoDescriptor = (MojoDescriptor)i.next();
            if (reportSet != null && !reportSet.getReports().contains(mojoDescriptor.getGoal())) continue;
            String id = null;
            if (reportSet != null) {
                id = reportSet.getId();
            }
            MojoExecution reportExecution = new MojoExecution(mojoDescriptor, id);
            try {
                MavenReport reportMojo = this.pluginManager.getReport(project, reportExecution, session);
                if (reportMojo == null) continue;
                reports.add(reportMojo);
                mojoExecution.addMojoExecution(reportExecution);
            }
            catch (PluginManagerException e2) {
                throw new LifecycleExecutionException("Error getting reports from the plugin '" + reportPlugin.getKey() + "': " + e2.getMessage(), e2);
            }
            catch (PluginConfigurationException e3) {
                throw new LifecycleExecutionException("Error getting reports from the plugin '" + reportPlugin.getKey() + "'", e3);
            }
            catch (ArtifactNotFoundException e4) {
                throw new LifecycleExecutionException(e4.getMessage(), e4);
            }
            catch (ArtifactResolutionException e5) {
                throw new LifecycleExecutionException(e5.getMessage(), e5);
            }
        }
        return reports;
    }

    private void forkLifecycle(MojoDescriptor mojoDescriptor, Stack ancestorLifecycleForkers, MavenSession session, MavenProject project) throws LifecycleExecutionException, BuildFailureException, PluginNotFoundException {
        PluginDescriptor pluginDescriptor = mojoDescriptor.getPluginDescriptor();
        this.getLogger().info("Preparing " + pluginDescriptor.getGoalPrefix() + ":" + mojoDescriptor.getGoal());
        if (mojoDescriptor.isAggregator()) {
            Iterator i = session.getSortedProjects().iterator();
            while (i.hasNext()) {
                MavenProject reactorProject = (MavenProject)i.next();
                this.line();
                this.getLogger().info("Building " + reactorProject.getName());
                this.line();
                this.forkProjectLifecycle(mojoDescriptor, ancestorLifecycleForkers, session, reactorProject);
            }
        } else {
            this.forkProjectLifecycle(mojoDescriptor, ancestorLifecycleForkers, session, project);
        }
    }

    private void forkProjectLifecycle(MojoDescriptor mojoDescriptor, Stack forkEntryPoints, MavenSession session, MavenProject project) throws LifecycleExecutionException, BuildFailureException, PluginNotFoundException {
        forkEntryPoints.push(mojoDescriptor);
        PluginDescriptor pluginDescriptor = mojoDescriptor.getPluginDescriptor();
        String targetPhase = mojoDescriptor.getExecutePhase();
        Map lifecycleMappings = null;
        if (targetPhase != null) {
            Lifecycle lifecycle = this.getLifecycleForPhase(targetPhase);
            lifecycleMappings = this.constructLifecycleMappings(session, targetPhase, project, lifecycle);
            String executeLifecycle = mojoDescriptor.getExecuteLifecycle();
            if (executeLifecycle != null) {
                org.apache.maven.plugin.lifecycle.Lifecycle lifecycleOverlay;
                try {
                    lifecycleOverlay = pluginDescriptor.getLifecycleMapping(executeLifecycle);
                }
                catch (IOException e2) {
                    throw new LifecycleExecutionException("Unable to read lifecycle mapping file: " + e2.getMessage(), e2);
                }
                catch (XmlPullParserException e3) {
                    throw new LifecycleExecutionException("Unable to parse lifecycle mapping file: " + e3.getMessage(), e3);
                }
                if (lifecycleOverlay == null) {
                    throw new LifecycleExecutionException("Lifecycle '" + executeLifecycle + "' not found in plugin");
                }
                Iterator i = lifecycleOverlay.getPhases().iterator();
                while (i.hasNext()) {
                    Iterator k;
                    Phase phase = (Phase)i.next();
                    Iterator<Object> j = phase.getExecutions().iterator();
                    while (j.hasNext()) {
                        Execution exec = (Execution)j.next();
                        k = exec.getGoals().iterator();
                        while (k.hasNext()) {
                            PluginDescriptor lifecyclePluginDescriptor;
                            String lifecycleGoal;
                            String goal = (String)k.next();
                            if (goal.indexOf(":") > 0) {
                                String[] s = StringUtils.split(goal, ":");
                                String groupId = s[0];
                                String artifactId = s[1];
                                lifecycleGoal = s[2];
                                Plugin plugin = new Plugin();
                                plugin.setGroupId(groupId);
                                plugin.setArtifactId(artifactId);
                                lifecyclePluginDescriptor = this.verifyPlugin(plugin, project, session.getSettings(), session.getLocalRepository());
                                if (lifecyclePluginDescriptor == null) {
                                    throw new LifecycleExecutionException("Unable to find plugin " + groupId + ":" + artifactId);
                                }
                            } else {
                                lifecyclePluginDescriptor = pluginDescriptor;
                                lifecycleGoal = goal;
                            }
                            Xpp3Dom configuration = (Xpp3Dom)exec.getConfiguration();
                            if (phase.getConfiguration() != null) {
                                configuration = Xpp3Dom.mergeXpp3Dom(new Xpp3Dom((Xpp3Dom)phase.getConfiguration()), configuration);
                            }
                            MojoDescriptor desc = this.getMojoDescriptor(lifecyclePluginDescriptor, lifecycleGoal);
                            MojoExecution mojoExecution = new MojoExecution(desc, configuration);
                            this.addToLifecycleMappings(lifecycleMappings, phase.getId(), mojoExecution, session.getSettings());
                        }
                    }
                    if (phase.getConfiguration() == null) continue;
                    j = lifecycleMappings.values().iterator();
                    while (j.hasNext()) {
                        List tasks = (List)j.next();
                        k = tasks.iterator();
                        while (k.hasNext()) {
                            MojoExecution exec = (MojoExecution)k.next();
                            Xpp3Dom configuration = Xpp3Dom.mergeXpp3Dom(new Xpp3Dom((Xpp3Dom)phase.getConfiguration()), exec.getConfiguration());
                            exec.setConfiguration(configuration);
                        }
                    }
                }
            }
            this.removeFromLifecycle(forkEntryPoints, lifecycleMappings);
        }
        MavenProject executionProject = new MavenProject(project);
        if (targetPhase != null) {
            Lifecycle lifecycle = this.getLifecycleForPhase(targetPhase);
            this.executeGoalWithLifecycle(targetPhase, forkEntryPoints, session, lifecycleMappings, executionProject, lifecycle);
        } else {
            String goal = mojoDescriptor.getExecuteGoal();
            MojoDescriptor desc = this.getMojoDescriptor(pluginDescriptor, goal);
            this.executeGoals(Collections.singletonList(new MojoExecution(desc)), forkEntryPoints, session, executionProject);
        }
        project.setExecutionProject(executionProject);
    }

    private Lifecycle getLifecycleForPhase(String phase) throws BuildFailureException, LifecycleExecutionException {
        Lifecycle lifecycle = (Lifecycle)this.getPhaseToLifecycleMap().get(phase);
        if (lifecycle == null) {
            throw new BuildFailureException("Unable to find lifecycle for phase '" + phase + "'");
        }
        return lifecycle;
    }

    private MojoDescriptor getMojoDescriptor(PluginDescriptor pluginDescriptor, String goal) throws LifecycleExecutionException {
        MojoDescriptor desc = pluginDescriptor.getMojo(goal);
        if (desc == null) {
            String prefix;
            String message = "Required goal '" + goal + "' not found in plugin '" + pluginDescriptor.getGoalPrefix() + "'";
            int index = goal.indexOf(58);
            if (index >= 0 && (prefix = goal.substring(index + 1)).equals(pluginDescriptor.getGoalPrefix())) {
                message = message + " (goals should not be prefixed - try '" + prefix + "')";
            }
            throw new LifecycleExecutionException(message);
        }
        return desc;
    }

    private void removeFromLifecycle(Stack lifecycleForkers, Map lifecycleMappings) {
        Iterator it = ((AbstractList)lifecycleForkers).iterator();
        while (it.hasNext()) {
            MojoDescriptor mojoDescriptor = (MojoDescriptor)it.next();
            Iterator lifecycleIterator = lifecycleMappings.values().iterator();
            while (lifecycleIterator.hasNext()) {
                List tasks = (List)lifecycleIterator.next();
                boolean removed = false;
                Iterator taskIterator = tasks.iterator();
                while (taskIterator.hasNext()) {
                    MojoExecution execution = (MojoExecution)taskIterator.next();
                    if (!mojoDescriptor.equals(execution.getMojoDescriptor())) continue;
                    taskIterator.remove();
                    removed = true;
                }
                if (!removed) continue;
                this.getLogger().warn("Removing: " + mojoDescriptor.getGoal() + " from forked lifecycle, to prevent recursive invocation.");
            }
        }
    }

    private Map constructLifecycleMappings(MavenSession session, String selectedPhase, MavenProject project, Lifecycle lifecycle) throws LifecycleExecutionException, BuildFailureException, PluginNotFoundException {
        Map lifecycleMappings = this.bindLifecycleForPackaging(session, selectedPhase, project, lifecycle);
        Iterator i = project.getBuildPlugins().iterator();
        while (i.hasNext()) {
            Plugin plugin = (Plugin)i.next();
            this.bindPluginToLifecycle(plugin, session, lifecycleMappings, project);
        }
        return lifecycleMappings;
    }

    private Map bindLifecycleForPackaging(MavenSession session, String selectedPhase, MavenProject project, Lifecycle lifecycle) throws LifecycleExecutionException, BuildFailureException, PluginNotFoundException {
        Map mappings = this.findMappingsForLifecycle(session, project, lifecycle);
        List optionalMojos = this.findOptionalMojosForLifecycle(session, project, lifecycle);
        HashMap lifecycleMappings = new HashMap();
        Iterator i = lifecycle.getPhases().iterator();
        while (i.hasNext()) {
            String phase = (String)i.next();
            String phaseTasks = (String)mappings.get(phase);
            if (phaseTasks != null) {
                StringTokenizer tok = new StringTokenizer(phaseTasks, ",");
                while (tok.hasMoreTokens()) {
                    String goal = tok.nextToken().trim();
                    MojoDescriptor mojoDescriptor = this.getMojoDescriptor(goal, session, project, selectedPhase, false, optionalMojos.contains(goal));
                    if (mojoDescriptor == null) continue;
                    if (mojoDescriptor.isDirectInvocationOnly()) {
                        throw new LifecycleExecutionException("Mojo: '" + goal + "' requires direct invocation. It cannot be used as part of lifecycle: '" + project.getPackaging() + "'.");
                    }
                    this.addToLifecycleMappings(lifecycleMappings, phase, new MojoExecution(mojoDescriptor), session.getSettings());
                }
            }
            if (!phase.equals(selectedPhase)) continue;
            break;
        }
        return lifecycleMappings;
    }

    private Map findMappingsForLifecycle(MavenSession session, MavenProject project, Lifecycle lifecycle) throws LifecycleExecutionException, PluginNotFoundException {
        Map defaultMappings;
        Map mappings;
        String packaging;
        block6: {
            packaging = project.getPackaging();
            mappings = null;
            LifecycleMapping m = (LifecycleMapping)this.findExtension(project, LifecycleMapping.ROLE, packaging, session.getSettings(), session.getLocalRepository());
            if (m != null) {
                mappings = m.getPhases(lifecycle.getId());
            }
            defaultMappings = lifecycle.getDefaultPhases();
            if (mappings == null) {
                try {
                    m = (LifecycleMapping)session.lookup(LifecycleMapping.ROLE, packaging);
                    mappings = m.getPhases(lifecycle.getId());
                }
                catch (ComponentLookupException e2) {
                    if (defaultMappings != null) break block6;
                    throw new LifecycleExecutionException("Cannot find lifecycle mapping for packaging: '" + packaging + "'.", e2);
                }
            }
        }
        if (mappings == null) {
            if (defaultMappings == null) {
                throw new LifecycleExecutionException("Cannot find lifecycle mapping for packaging: '" + packaging + "', and there is no default");
            }
            mappings = defaultMappings;
        }
        return mappings;
    }

    private List findOptionalMojosForLifecycle(MavenSession session, MavenProject project, Lifecycle lifecycle) throws LifecycleExecutionException, PluginNotFoundException {
        String packaging = project.getPackaging();
        List optionalMojos = null;
        LifecycleMapping m = (LifecycleMapping)this.findExtension(project, LifecycleMapping.ROLE, packaging, session.getSettings(), session.getLocalRepository());
        if (m != null) {
            optionalMojos = m.getOptionalMojos(lifecycle.getId());
        }
        if (optionalMojos == null) {
            try {
                m = (LifecycleMapping)session.lookup(LifecycleMapping.ROLE, packaging);
                optionalMojos = m.getOptionalMojos(lifecycle.getId());
            }
            catch (ComponentLookupException e2) {
                this.getLogger().debug("Error looking up lifecycle mapping to retrieve optional mojos. Lifecycle ID: " + lifecycle.getId() + ". Error: " + e2.getMessage(), e2);
            }
        }
        if (optionalMojos == null) {
            optionalMojos = Collections.EMPTY_LIST;
        }
        return optionalMojos;
    }

    private Object findExtension(MavenProject project, String role, String roleHint, Settings settings, ArtifactRepository localRepository) throws LifecycleExecutionException, PluginNotFoundException {
        Object pluginComponent = null;
        Iterator i = project.getBuildPlugins().iterator();
        while (i.hasNext() && pluginComponent == null) {
            Plugin plugin = (Plugin)i.next();
            if (!plugin.isExtensions()) continue;
            this.verifyPlugin(plugin, project, settings, localRepository);
            try {
                pluginComponent = this.pluginManager.getPluginComponent(plugin, role, roleHint);
            }
            catch (ComponentLookupException e2) {
                this.getLogger().debug("Unable to find the lifecycle component in the extension", e2);
            }
            catch (PluginManagerException e3) {
                throw new LifecycleExecutionException("Error getting extensions from the plugin '" + plugin.getKey() + "': " + e3.getMessage(), e3);
            }
        }
        return pluginComponent;
    }

    private Map findArtifactTypeHandlers(MavenProject project, Settings settings, ArtifactRepository localRepository) throws LifecycleExecutionException, PluginNotFoundException {
        HashMap map = new HashMap();
        Iterator i = project.getBuildPlugins().iterator();
        while (i.hasNext()) {
            Plugin plugin = (Plugin)i.next();
            if (!plugin.isExtensions()) continue;
            this.verifyPlugin(plugin, project, settings, localRepository);
            try {
                Map components = this.pluginManager.getPluginComponents(plugin, ArtifactHandler.ROLE);
                map.putAll(components);
            }
            catch (ComponentLookupException e2) {
                this.getLogger().debug("Unable to find the lifecycle component in the extension", e2);
            }
            catch (PluginManagerException e3) {
                throw new LifecycleExecutionException("Error looking up available components from plugin '" + plugin.getKey() + "': " + e3.getMessage(), e3);
            }
            Iterator j = map.values().iterator();
            while (j.hasNext()) {
                ArtifactHandler handler = (ArtifactHandler)j.next();
                if (!project.getPackaging().equals(handler.getPackaging())) continue;
                project.getArtifact().setArtifactHandler(handler);
            }
        }
        return map;
    }

    private void bindPluginToLifecycle(Plugin plugin, MavenSession session, Map phaseMap, MavenProject project) throws LifecycleExecutionException, PluginNotFoundException {
        Settings settings = session.getSettings();
        PluginDescriptor pluginDescriptor = this.verifyPlugin(plugin, project, session.getSettings(), session.getLocalRepository());
        if (pluginDescriptor.getMojos() != null && !pluginDescriptor.getMojos().isEmpty() && (plugin.isInheritanceApplied() || pluginDescriptor.isInheritedByDefault())) {
            List executions;
            if (plugin.getGoals() != null) {
                this.getLogger().error("Plugin contains a <goals/> section: this is IGNORED - please use <executions/> instead.");
            }
            if ((executions = plugin.getExecutions()) != null) {
                Iterator it = executions.iterator();
                while (it.hasNext()) {
                    PluginExecution execution = (PluginExecution)it.next();
                    this.bindExecutionToLifecycle(pluginDescriptor, phaseMap, execution, settings);
                }
            }
        }
    }

    private PluginDescriptor verifyPlugin(Plugin plugin, MavenProject project, Settings settings, ArtifactRepository localRepository) throws LifecycleExecutionException, PluginNotFoundException {
        PluginDescriptor pluginDescriptor;
        try {
            pluginDescriptor = this.pluginManager.verifyPlugin(plugin, project, settings, localRepository);
        }
        catch (PluginManagerException e2) {
            throw new LifecycleExecutionException("Internal error in the plugin manager getting plugin '" + plugin.getKey() + "': " + e2.getMessage(), e2);
        }
        catch (PluginVersionResolutionException e3) {
            throw new LifecycleExecutionException(e3.getMessage(), e3);
        }
        catch (InvalidVersionSpecificationException e4) {
            throw new LifecycleExecutionException(e4.getMessage(), e4);
        }
        catch (InvalidPluginException e5) {
            throw new LifecycleExecutionException(e5.getMessage(), e5);
        }
        catch (ArtifactNotFoundException e6) {
            throw new LifecycleExecutionException(e6.getMessage(), e6);
        }
        catch (ArtifactResolutionException e7) {
            throw new LifecycleExecutionException(e7.getMessage(), e7);
        }
        catch (PluginVersionNotFoundException e8) {
            throw new LifecycleExecutionException(e8.getMessage(), e8);
        }
        return pluginDescriptor;
    }

    private PluginDescriptor verifyReportPlugin(ReportPlugin plugin, MavenProject project, MavenSession session) throws LifecycleExecutionException, PluginNotFoundException {
        PluginDescriptor pluginDescriptor;
        try {
            pluginDescriptor = this.pluginManager.verifyReportPlugin(plugin, project, session);
        }
        catch (PluginManagerException e2) {
            throw new LifecycleExecutionException("Internal error in the plugin manager getting report '" + plugin.getKey() + "': " + e2.getMessage(), e2);
        }
        catch (PluginVersionResolutionException e3) {
            throw new LifecycleExecutionException(e3.getMessage(), e3);
        }
        catch (InvalidVersionSpecificationException e4) {
            throw new LifecycleExecutionException(e4.getMessage(), e4);
        }
        catch (InvalidPluginException e5) {
            throw new LifecycleExecutionException(e5.getMessage(), e5);
        }
        catch (ArtifactNotFoundException e6) {
            throw new LifecycleExecutionException(e6.getMessage(), e6);
        }
        catch (ArtifactResolutionException e7) {
            throw new LifecycleExecutionException(e7.getMessage(), e7);
        }
        catch (PluginVersionNotFoundException e8) {
            throw new LifecycleExecutionException(e8.getMessage(), e8);
        }
        return pluginDescriptor;
    }

    private void bindExecutionToLifecycle(PluginDescriptor pluginDescriptor, Map phaseMap, PluginExecution execution, Settings settings) throws LifecycleExecutionException {
        Iterator i = execution.getGoals().iterator();
        while (i.hasNext()) {
            String goal = (String)i.next();
            MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(goal);
            if (mojoDescriptor == null) {
                throw new LifecycleExecutionException("'" + goal + "' was specified in an execution, but not found in the plugin");
            }
            if (!execution.isInheritanceApplied() && !mojoDescriptor.isInheritedByDefault()) continue;
            MojoExecution mojoExecution = new MojoExecution(mojoDescriptor, execution.getId());
            String phase = execution.getPhase();
            if (phase == null) {
                phase = mojoDescriptor.getPhase();
            }
            if (phase == null) continue;
            if (mojoDescriptor.isDirectInvocationOnly()) {
                throw new LifecycleExecutionException("Mojo: '" + goal + "' requires direct invocation. It cannot be used as part of the lifecycle (it was included via the POM).");
            }
            this.addToLifecycleMappings(phaseMap, phase, mojoExecution, settings);
        }
    }

    private void addToLifecycleMappings(Map lifecycleMappings, String phase, MojoExecution mojoExecution, Settings settings) {
        ArrayList<MojoExecution> goals = (ArrayList<MojoExecution>)lifecycleMappings.get(phase);
        if (goals == null) {
            goals = new ArrayList<MojoExecution>();
            lifecycleMappings.put(phase, goals);
        }
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        if (settings.isOffline() && mojoDescriptor.isOnlineRequired()) {
            String goal = mojoDescriptor.getGoal();
            this.getLogger().warn(goal + " requires online mode, but maven is currently offline. Disabling " + goal + ".");
        } else {
            goals.add(mojoExecution);
        }
    }

    private List processGoalChain(String task, Map phaseMap, Lifecycle lifecycle) {
        ArrayList goals = new ArrayList();
        int index = lifecycle.getPhases().indexOf(task);
        for (int i = 0; i <= index; ++i) {
            String p = (String)lifecycle.getPhases().get(i);
            List phaseGoals = (List)phaseMap.get(p);
            if (phaseGoals == null) continue;
            goals.addAll(phaseGoals);
        }
        return goals;
    }

    private MojoDescriptor getMojoDescriptor(String task, MavenSession session, MavenProject project, String invokedVia, boolean canUsePrefix, boolean isOptionalMojo) throws BuildFailureException, LifecycleExecutionException, PluginNotFoundException {
        PluginDescriptor pluginDescriptor = null;
        try {
            Plugin plugin;
            String goal;
            StringTokenizer tok = new StringTokenizer(task, ":");
            int numTokens = tok.countTokens();
            if (numTokens == 2) {
                Plugin buildPlugin;
                Iterator i;
                if (!canUsePrefix) {
                    String msg = "Mapped-prefix lookup of mojos are only supported from direct invocation. Please use specification of the form groupId:artifactId[:version]:goal instead. (Offending mojo: '" + task + "', invoked via: '" + invokedVia + "')";
                    throw new LifecycleExecutionException(msg);
                }
                String prefix = tok.nextToken();
                goal = tok.nextToken();
                pluginDescriptor = this.pluginManager.getPluginDescriptorForPrefix(prefix);
                if (pluginDescriptor == null) {
                    plugin = this.pluginManager.getPluginDefinitionForPrefix(prefix, session, project);
                } else {
                    plugin = new Plugin();
                    plugin.setGroupId(pluginDescriptor.getGroupId());
                    plugin.setArtifactId(pluginDescriptor.getArtifactId());
                    plugin.setVersion(pluginDescriptor.getVersion());
                }
                if (plugin == null) {
                    i = project.getBuildPlugins().iterator();
                    while (i.hasNext()) {
                        buildPlugin = (Plugin)i.next();
                        PluginDescriptor desc = this.verifyPlugin(buildPlugin, project, session.getSettings(), session.getLocalRepository());
                        if (!prefix.equals(desc.getGoalPrefix())) continue;
                        plugin = buildPlugin;
                    }
                }
                if (plugin == null) {
                    plugin = new Plugin();
                    plugin.setGroupId(PluginDescriptor.getDefaultPluginGroupId());
                    plugin.setArtifactId(PluginDescriptor.getDefaultPluginArtifactId(prefix));
                }
                i = project.getBuildPlugins().iterator();
                while (i.hasNext()) {
                    buildPlugin = (Plugin)i.next();
                    if (!buildPlugin.getKey().equals(plugin.getKey())) continue;
                    plugin = buildPlugin;
                    break;
                }
            } else if (numTokens == 3 || numTokens == 4) {
                plugin = new Plugin();
                plugin.setGroupId(tok.nextToken());
                plugin.setArtifactId(tok.nextToken());
                if (numTokens == 4) {
                    plugin.setVersion(tok.nextToken());
                }
                goal = tok.nextToken();
            } else {
                String message = "Invalid task '" + task + "': you must specify a valid lifecycle phase, or" + " a goal in the format plugin:goal or pluginGroupId:pluginArtifactId:pluginVersion:goal";
                throw new BuildFailureException(message);
            }
            project.injectPluginManagementInfo(plugin);
            if (pluginDescriptor == null) {
                pluginDescriptor = this.verifyPlugin(plugin, project, session.getSettings(), session.getLocalRepository());
            }
            project.addPlugin(plugin);
            MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(goal);
            if (mojoDescriptor == null) {
                if (isOptionalMojo) {
                    this.getLogger().info("Skipping missing optional mojo: " + task);
                } else {
                    throw new BuildFailureException("Required goal not found: " + task);
                }
            }
            return mojoDescriptor;
        }
        catch (PluginNotFoundException e2) {
            if (!isOptionalMojo) {
                throw e2;
            }
            this.getLogger().info("Skipping missing optional mojo: " + task);
            this.getLogger().debug("Mojo: " + task + " could not be found. Reason: " + e2.getMessage(), e2);
            return null;
        }
    }

    protected void line() {
        this.getLogger().info("----------------------------------------------------------------------------");
    }

    public Map getPhaseToLifecycleMap() throws LifecycleExecutionException {
        if (this.phaseToLifecycleMap == null) {
            this.phaseToLifecycleMap = new HashMap();
            Iterator i = this.lifecycles.iterator();
            while (i.hasNext()) {
                Lifecycle lifecycle = (Lifecycle)i.next();
                Iterator p = lifecycle.getPhases().iterator();
                while (p.hasNext()) {
                    String phase = (String)p.next();
                    if (this.phaseToLifecycleMap.containsKey(phase)) {
                        Lifecycle prevLifecycle = (Lifecycle)this.phaseToLifecycleMap.get(phase);
                        throw new LifecycleExecutionException("Phase '" + phase + "' is defined in more than one lifecycle: '" + lifecycle.getId() + "' and '" + prevLifecycle.getId() + "'");
                    }
                    this.phaseToLifecycleMap.put(phase, lifecycle);
                }
            }
        }
        return this.phaseToLifecycleMap;
    }

    private static class TaskSegment {
        private boolean aggregate;
        private List tasks = new ArrayList();

        TaskSegment() {
        }

        TaskSegment(boolean aggregate) {
            this.aggregate = aggregate;
        }

        public String toString() {
            StringBuffer message = new StringBuffer();
            message.append(" task-segment: [");
            Iterator it = this.tasks.iterator();
            while (it.hasNext()) {
                String task = (String)it.next();
                message.append(task);
                if (!it.hasNext()) continue;
                message.append(", ");
            }
            message.append("]");
            if (this.aggregate) {
                message.append(" (aggregator-style)");
            }
            return message.toString();
        }

        boolean aggregate() {
            return this.aggregate;
        }

        void add(String task) {
            this.tasks.add(task);
        }

        List getTasks() {
            return this.tasks;
        }
    }
}

