/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.resourcemap;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.dataone.cn.indexer.parser.IDocumentProvider;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ResourceMapDataSource
implements IDocumentProvider {
    private DocumentBuilder documentBuilder;
    private String baseURI = null;

    @Override
    public Document getDocument(String identifier) {
        HttpClient client = this.getClient();
        String uri = this.getResourceMapURI(identifier);
        HttpGet request = new HttpGet(uri);
        HttpResponse response = null;
        try {
            response = client.execute(request);
            Document doc = this.parseDocument(response.getEntity().getContent());
            return doc;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    private String getResourceMapURI(String identifier) {
        return this.getBaseURI() + identifier;
    }

    private Document parseDocument(InputStream inputStream) throws ParserConfigurationException, IOException, SAXException {
        Document doc = null;
        try {
            doc = this.getDocumentBuilder().parse(inputStream);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        return doc;
    }

    public HttpClient getClient() {
        DefaultHttpClient client = null;
        if (client == null) {
            client = new DefaultHttpClient();
        }
        return client;
    }

    public DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (this.documentBuilder == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            this.documentBuilder = factory.newDocumentBuilder();
        }
        return this.documentBuilder;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }
}

