/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.mimemultipart;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.Logger;
import org.dataone.mimemultipart.MultipartRequest;

public class MultipartRequestResolver {
    Logger logger = Logger.getLogger(MultipartRequestResolver.class.getName());
    private DiskFileItemFactory factory = new DiskFileItemFactory();
    private ServletFileUpload upload;
    static final int SIZE = 16384;

    public MultipartRequestResolver() {
        this.upload = new ServletFileUpload(this.factory);
    }

    public MultipartRequestResolver(String tmpUploadDir) {
        this.factory.setRepository(new File(tmpUploadDir));
        this.upload = new ServletFileUpload(this.factory);
    }

    public MultipartRequestResolver(String tmpUploadDir, int maxUploadSize) {
        this.factory.setRepository(new File(tmpUploadDir));
        this.upload = new ServletFileUpload(this.factory);
        this.upload.setSizeMax(maxUploadSize);
    }

    public MultipartRequestResolver(String tmpUploadDir, int maxUploadSize, int maxMemorySize) {
        this.factory.setSizeThreshold(maxMemorySize);
        this.factory.setRepository(new File(tmpUploadDir));
        this.upload = new ServletFileUpload(this.factory);
        this.upload.setSizeMax(maxUploadSize);
    }

    public MultipartRequest resolveMultipart(HttpServletRequest request) throws IOException, FileUploadException, Exception {
        HashMap<String, List<String>> mpParams = new HashMap<String, List<String>>();
        HashMap<String, File> mpFiles = new HashMap<String, File>();
        MultipartRequest multipartRequest = new MultipartRequest(request, mpFiles, mpParams);
        if (!MultipartRequestResolver.isMultipartContent(request)) {
            return multipartRequest;
        }
        List items = this.upload.parseRequest(request);
        for (FileItem item : items) {
            if (item.isFormField()) {
                String name = item.getFieldName();
                String value = item.getString();
                if (mpParams.containsKey(name)) {
                    ((List)mpParams.get(name)).add(value);
                    continue;
                }
                ArrayList<String> values = new ArrayList<String>();
                values.add(value);
                mpParams.put(name, values);
                continue;
            }
            if (item instanceof DiskFileItem) {
                DiskFileItem diskItem = (DiskFileItem)item;
                String fileKey = diskItem.getFieldName();
                if (diskItem.isInMemory()) {
                    File fileItem = diskItem.getStoreLocation();
                    if (fileItem.exists()) {
                        this.logger.info("length: " + Long.toString(fileItem.length()) + " lastModified: " + Long.toString(fileItem.lastModified()) + " is it really a file: " + fileItem.isFile());
                    } else {
                        this.logger.debug("force creation of  " + fileItem.getAbsolutePath());
                        fileItem.createNewFile();
                        fileItem.deleteOnExit();
                        fileItem.setWritable(true);
                        fileItem.setReadable(true);
                        diskItem.write(fileItem);
                    }
                    mpFiles.put(fileKey, fileItem);
                    continue;
                }
                mpFiles.put(fileKey, diskItem.getStoreLocation());
                continue;
            }
            throw new FileUploadException("unable to determine file location of Multipart Form named: " + item.getName());
        }
        return multipartRequest;
    }

    public static final boolean isMultipartContent(HttpServletRequest request) {
        if ("post".equals(request.getMethod().toLowerCase()) || "put".equals(request.getMethod().toLowerCase())) {
            String contentType = request.getContentType();
            if (contentType == null) {
                return false;
            }
            if (contentType.toLowerCase().startsWith("multipart/")) {
                return true;
            }
        }
        return false;
    }
}

