/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.expression.function;

import java.io.Serializable;
import javax.persistence.criteria.Expression;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.CriteriaQueryCompiler;
import org.hibernate.ejb.criteria.expression.LiteralExpression;
import org.hibernate.ejb.criteria.expression.function.ParameterizedFunctionExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregationFunction<T>
extends ParameterizedFunctionExpression<T>
implements Serializable {
    public AggregationFunction(CriteriaBuilderImpl criteriaBuilder, Class<T> returnType, String functionName, Object argument) {
        this(criteriaBuilder, returnType, functionName, (Expression<?>)new LiteralExpression<Object>(criteriaBuilder, argument));
    }

    public AggregationFunction(CriteriaBuilderImpl criteriaBuilder, Class<T> returnType, String functionName, Expression<?> argument) {
        super(criteriaBuilder, returnType, functionName, argument);
    }

    @Override
    public boolean isAggregation() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GREATEST<X extends Comparable<X>>
    extends AggregationFunction<X> {
        public static final String NAME = "max";

        public GREATEST(CriteriaBuilderImpl criteriaBuilder, Expression<X> expression) {
            super(criteriaBuilder, expression.getJavaType(), NAME, (Expression<?>)expression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LEAST<X extends Comparable<X>>
    extends AggregationFunction<X> {
        public static final String NAME = "min";

        public LEAST(CriteriaBuilderImpl criteriaBuilder, Expression<X> expression) {
            super(criteriaBuilder, expression.getJavaType(), NAME, (Expression<?>)expression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MAX<N extends Number>
    extends AggregationFunction<N> {
        public static final String NAME = "max";

        public MAX(CriteriaBuilderImpl criteriaBuilder, Expression<N> expression) {
            super(criteriaBuilder, expression.getJavaType(), NAME, (Expression<?>)expression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MIN<N extends Number>
    extends AggregationFunction<N> {
        public static final String NAME = "min";

        public MIN(CriteriaBuilderImpl criteriaBuilder, Expression<N> expression) {
            super(criteriaBuilder, expression.getJavaType(), NAME, (Expression<?>)expression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SUM<N extends Number>
    extends AggregationFunction<N> {
        public static final String NAME = "sum";

        public SUM(CriteriaBuilderImpl criteriaBuilder, Expression<N> expression) {
            super(criteriaBuilder, expression.getJavaType(), NAME, (Expression<?>)expression);
            this.resetJavaType(expression.getJavaType());
        }

        public SUM(CriteriaBuilderImpl criteriaBuilder, Expression<? extends Number> expression, Class<N> returnType) {
            super(criteriaBuilder, returnType, NAME, (Expression<?>)expression);
            this.resetJavaType(returnType);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AVG
    extends AggregationFunction<Double> {
        public static final String NAME = "avg";

        public AVG(CriteriaBuilderImpl criteriaBuilder, Expression<? extends Number> expression) {
            super(criteriaBuilder, Double.class, NAME, (Expression<?>)expression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class COUNT
    extends AggregationFunction<Long> {
        public static final String NAME = "count";
        private final boolean distinct;

        public COUNT(CriteriaBuilderImpl criteriaBuilder, Expression<?> expression, boolean distinct) {
            super(criteriaBuilder, Long.class, NAME, expression);
            this.distinct = distinct;
        }

        @Override
        protected void renderArguments(StringBuilder buffer, CriteriaQueryCompiler.RenderingContext renderingContext) {
            if (this.isDistinct()) {
                buffer.append("distinct ");
            }
            super.renderArguments(buffer, renderingContext);
        }

        public boolean isDistinct() {
            return this.distinct;
        }
    }
}

