/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime;

import org.jibx.runtime.JiBXException;
import org.jibx.runtime.Utility;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;

public abstract class JodaConvert {
    public static LocalDate deserializeLocalDate(String text) throws JiBXException {
        if (text == null) {
            return null;
        }
        return new LocalDate(Utility.parseDate(text), DateTimeZone.UTC);
    }

    public static String serializeLocalDate(LocalDate date2) {
        return Utility.serializeDate(date2.toDateTimeAtStartOfDay(DateTimeZone.UTC).getMillis());
    }

    protected static DateMidnight deserializeDateMidnight(String text, DateTimeZone zone) throws JiBXException {
        int[] starts;
        if (!Utility.ifDate(text)) {
            throw new JiBXException("Invalid date format");
        }
        int split = text.indexOf(45, 1);
        int year = Utility.parseInt(text.substring(0, split));
        if (year == 0) {
            throw new JiBXException("Year value 0 is not allowed");
        }
        int month = Utility.parseDigits(text, split + 1, 2);
        if (month < 1 || month > 12) {
            throw new JiBXException("Month value out of range");
        }
        int day = Utility.parseDigits(text, split + 4, 2);
        boolean leap = year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
        int[] nArray = starts = leap ? Utility.MONTHS_LEAP : Utility.MONTHS_NONLEAP;
        if (day < 1 || day > starts[month] - starts[month - 1]) {
            throw new JiBXException("Day value out of range");
        }
        return new DateMidnight(year, month, day, zone);
    }

    protected static DateTimeZone findZone(String text, DateTimeZone dflt) throws JiBXException {
        char chr;
        int length = text.length();
        if (text.charAt(length - 1) == 'Z') {
            return DateTimeZone.UTC;
        }
        int offset = length - 6;
        if (text.indexOf(45, 1) < offset && ((chr = text.charAt(offset)) == '-' || chr == '+')) {
            int hour = Utility.parseDigits(text, offset + 1, 2);
            int minute = Utility.parseDigits(text, offset + 4, 2);
            if (hour > 14 || minute > 59 || hour == 14 && minute != 0) {
                throw new JiBXException("Invalid time zone offset: " + text);
            }
            if (chr == '-') {
                return DateTimeZone.forOffsetHoursMinutes(-hour, minute);
            }
            return DateTimeZone.forOffsetHoursMinutes(hour, minute);
        }
        return dflt;
    }

    public static DateMidnight deserializeZonedDateMidnight(String text) throws JiBXException {
        if (text == null) {
            return null;
        }
        DateTimeZone zone = JodaConvert.findZone(text, DateTimeZone.getDefault());
        return JodaConvert.deserializeDateMidnight(text, zone);
    }

    public static DateMidnight deserializeLocalDateMidnight(String text) throws JiBXException {
        if (text == null) {
            return null;
        }
        return JodaConvert.deserializeDateMidnight(text, DateTimeZone.getDefault());
    }

    public static DateMidnight deserializeUTCDateMidnight(String text) throws JiBXException {
        if (text == null) {
            return null;
        }
        return JodaConvert.deserializeDateMidnight(text, DateTimeZone.UTC);
    }

    public static String serializeUnzonedDateMidnight(DateMidnight date2) {
        long millis = date2.getMillis();
        int offset = date2.getZone().getOffset(millis);
        return Utility.serializeDate(millis + (long)offset);
    }

    public static String serializeZonedDateMidnight(DateMidnight date2) {
        long millis = date2.getMillis();
        int offset = date2.getZone().getOffset(millis);
        StringBuffer buff = new StringBuffer(25);
        Utility.formatYearMonthDay(millis + (long)offset + 62135596800000L, buff);
        Utility.serializeOffset(offset, buff);
        return buff.toString();
    }

    public static String serializeUTCDateMidnight(DateMidnight date2) {
        long millis = date2.getMillis();
        int offset = date2.getZone().getOffset(millis);
        StringBuffer buff = new StringBuffer(25);
        Utility.formatYearMonthDay(millis + (long)offset + 62135596800000L, buff);
        buff.append('Z');
        return buff.toString();
    }

    public static LocalTime deserializeLocalTime(String text) throws JiBXException {
        if (text == null) {
            return null;
        }
        return new LocalTime(Utility.parseTimeNoOffset(text, 0, text.length()), DateTimeZone.UTC);
    }

    public static String serializeUnzonedLocalTime(LocalTime time) {
        StringBuffer buff = new StringBuffer(12);
        Utility.serializeTime(time.getMillisOfDay(), buff);
        return buff.toString();
    }

    public static String serializeUTCLocalTime(LocalTime time) {
        StringBuffer buff = new StringBuffer(13);
        Utility.serializeTime(time.getMillisOfDay(), buff);
        buff.append('Z');
        return buff.toString();
    }

    protected static DateTime parseDateTime(String text, boolean full, DateTimeZone zone) throws JiBXException {
        int split = text.indexOf(84);
        if (split < 0) {
            throw new JiBXException("Missing 'T' separator in dateTime");
        }
        int length = text.length();
        long milli = Utility.parseDate(text.substring(0, split)) + Utility.parseTimeNoOffset(text, split + 1, length);
        int start = split + 9;
        boolean utc = false;
        if (length > start) {
            char chr;
            utc = true;
            if (text.charAt(length - 1) != 'Z' && ((chr = text.charAt(length - 6)) == '-' || chr == '+')) {
                int hour = Utility.parseDigits(text, length - 5, 2);
                int minute = Utility.parseDigits(text, length - 2, 2);
                if (hour > 14 || minute > 59 || hour == 14 && minute != 0) {
                    throw new JiBXException("Invalid time zone offset: " + text);
                }
                int offset = (hour * 60 + minute) * 60 * 1000;
                milli = chr == '-' ? (milli += (long)offset) : (milli -= (long)offset);
            }
        } else if (full) {
            throw new JiBXException("Missing required time zone offset: " + text);
        }
        if (!utc) {
            milli -= (long)zone.getOffset(milli);
        }
        return new DateTime(milli, zone);
    }

    public static DateTime deserializeZonedDateTime(String text) throws JiBXException {
        if (text == null) {
            return null;
        }
        DateTimeZone zone = JodaConvert.findZone(text, DateTimeZone.getDefault());
        return JodaConvert.parseDateTime(text, false, zone);
    }

    public static DateTime deserializeUTCDateTime(String text) throws JiBXException {
        if (text == null) {
            return null;
        }
        return new DateTime(Utility.parseDateTime(text), DateTimeZone.UTC);
    }

    public static DateTime deserializeLocalDateTime(String text) throws JiBXException {
        if (text == null) {
            return null;
        }
        return JodaConvert.parseDateTime(text, false, DateTimeZone.getDefault());
    }

    public static DateTime deserializeStrictUTCDateTime(String text) throws JiBXException {
        if (text == null) {
            return null;
        }
        return JodaConvert.parseDateTime(text, true, DateTimeZone.UTC);
    }

    public static DateTime deserializeStrictLocalDateTime(String text) throws JiBXException {
        if (text == null) {
            return null;
        }
        return JodaConvert.parseDateTime(text, true, DateTimeZone.getDefault());
    }

    public static String serializeZonedDateTime(DateTime time) {
        int offset = time.getZone().getOffset(time.getMillis());
        long msec = time.getMillis() + (long)offset;
        StringBuffer buff = new StringBuffer(25);
        int extra = Utility.formatYearMonthDay(msec + 62135596800000L, buff);
        buff.append('T');
        Utility.serializeTime(extra, buff);
        Utility.serializeOffset(offset, buff);
        return buff.toString();
    }

    public static String serializeUTCDateTime(DateTime time) {
        return Utility.serializeDateTime(time.getMillis(), true);
    }
}

