/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.cdi;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.persistence.EntityManager;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;
import org.springframework.data.repository.cdi.CdiRepositoryBean;
import org.springframework.util.Assert;

class JpaRepositoryBean<T>
extends CdiRepositoryBean<T> {
    private final Bean<EntityManager> entityManagerBean;

    JpaRepositoryBean(BeanManager beanManager, Bean<EntityManager> entityManagerBean, Set<Annotation> qualifiers, Class<T> repositoryType) {
        super(qualifiers, repositoryType, beanManager);
        Assert.notNull(entityManagerBean);
        this.entityManagerBean = entityManagerBean;
    }

    @Override
    public T create(CreationalContext<T> creationalContext, Class<T> repositoryType) {
        EntityManager entityManager = this.getDependencyInstance(this.entityManagerBean, EntityManager.class);
        JpaRepositoryFactory factory = new JpaRepositoryFactory(entityManager);
        return factory.getRepository(repositoryType);
    }
}

