/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.support;

import java.util.Collections;
import java.util.Set;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.repository.core.CrudInvoker;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.support.Repositories;
import org.springframework.util.StringUtils;

public class DomainClassConverter<T extends ConversionService & ConverterRegistry>
implements ConditionalGenericConverter,
ApplicationContextAware {
    private final T conversionService;
    private Repositories repositories = Repositories.NONE;

    public DomainClassConverter(T conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, Object.class));
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null || !StringUtils.hasText(source.toString())) {
            return null;
        }
        Class<?> domainType = targetType.getType();
        RepositoryInformation info = this.repositories.getRepositoryInformationFor(domainType);
        CrudInvoker<?> invoker = this.repositories.getCrudInvoker(domainType);
        return invoker.invokeFindOne(this.conversionService.convert(source, info.getIdType()));
    }

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (!this.repositories.hasRepositoryFor(targetType.getType())) {
            return false;
        }
        return this.conversionService.canConvert(sourceType.getType(), this.repositories.getRepositoryInformationFor(targetType.getType()).getIdType());
    }

    @Override
    public void setApplicationContext(ApplicationContext context) {
        this.repositories = new Repositories(context);
        ((ConverterRegistry)this.conversionService).addConverter(this);
    }
}

