/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleNamespaceContext
implements NamespaceContext {
    private Map<String, String> prefixToNamespaceUri = new HashMap<String, String>();
    private Map<String, List<String>> namespaceUriToPrefixes = new HashMap<String, List<String>>();
    private String defaultNamespaceUri = "";

    @Override
    public String getNamespaceURI(String prefix) {
        Assert.notNull(prefix, "prefix is null");
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        if ("".equals(prefix)) {
            return this.defaultNamespaceUri;
        }
        if (this.prefixToNamespaceUri.containsKey(prefix)) {
            return this.prefixToNamespaceUri.get(prefix);
        }
        return "";
    }

    @Override
    public String getPrefix(String namespaceUri) {
        List<String> prefixes = this.getPrefixesInternal(namespaceUri);
        return prefixes.isEmpty() ? null : prefixes.get(0);
    }

    @Override
    public Iterator getPrefixes(String namespaceUri) {
        return this.getPrefixesInternal(namespaceUri).iterator();
    }

    public void setBindings(Map<String, String> bindings2) {
        for (Map.Entry<String, String> entry : bindings2.entrySet()) {
            this.bindNamespaceUri(entry.getKey(), entry.getValue());
        }
    }

    public void bindDefaultNamespaceUri(String namespaceUri) {
        this.bindNamespaceUri("", namespaceUri);
    }

    public void bindNamespaceUri(String prefix, String namespaceUri) {
        Assert.notNull(prefix, "No prefix given");
        Assert.notNull(namespaceUri, "No namespaceUri given");
        if ("".equals(prefix)) {
            this.defaultNamespaceUri = namespaceUri;
        } else {
            this.prefixToNamespaceUri.put(prefix, namespaceUri);
            this.getPrefixesInternal(namespaceUri).add(prefix);
        }
    }

    public void clear() {
        this.prefixToNamespaceUri.clear();
    }

    public Iterator<String> getBoundPrefixes() {
        return this.prefixToNamespaceUri.keySet().iterator();
    }

    private List<String> getPrefixesInternal(String namespaceUri) {
        if (this.defaultNamespaceUri.equals(namespaceUri)) {
            return Collections.singletonList("");
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(namespaceUri)) {
            return Collections.singletonList("xml");
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceUri)) {
            return Collections.singletonList("xmlns");
        }
        List<String> list = this.namespaceUriToPrefixes.get(namespaceUri);
        if (list == null) {
            list = new ArrayList<String>();
            this.namespaceUriToPrefixes.put(namespaceUri, list);
        }
        return list;
    }

    public void removeBinding(String prefix) {
        if ("".equals(prefix)) {
            this.defaultNamespaceUri = "";
        } else {
            String namespaceUri = this.prefixToNamespaceUri.remove(prefix);
            List<String> prefixes = this.getPrefixesInternal(namespaceUri);
            prefixes.remove(prefix);
        }
    }
}

